/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.builders.LetChainBuilder;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import java.util.LinkedList;
import java.util.List;

public class FlattenStreamOptimizer
extends Optimizer {
    private static final int MIN_STRING_COALESCE_SIZE = 5;
    private static final boolean COLAESCE_STRINGS_CODE = true;
    private static final boolean COLAESCE_STRINGS = true;

    protected void collectStream(StreamInstruction streamInstruction, LinkedList linkedList, LetChainBuilder letChainBuilder, StringBuffer stringBuffer) {
        if (streamInstruction.isString() && stringBuffer != null) {
            stringBuffer.append(streamInstruction.getStringContent());
            return;
        }
        int n2 = streamInstruction.getChildInstructionCount();
        for (int i = 0; i < n2; ++i) {
            Instruction instruction2;
            Instruction instruction3 = instruction2 = streamInstruction.getChildInstruction(i);
            if (instruction2 instanceof IdentifierInstruction && (instruction3 = NavigationUtilities.resolveReducedIdentifier(instruction2, this.getCurrentFunction().m_bindingEnvironment)) == null) {
                instruction3 = instruction2;
            }
            if (instruction3 instanceof StreamInstruction) {
                StreamInstruction streamInstruction2 = (StreamInstruction)instruction3;
                this.collectStream(streamInstruction2, linkedList, letChainBuilder, stringBuffer);
                continue;
            }
            if (instruction3 instanceof LiteralInstruction) {
                if (stringBuffer != null) {
                    stringBuffer.append(((Character)((LiteralInstruction)instruction3).getValue()).charValue());
                    continue;
                }
                linkedList.add(instruction3);
                continue;
            }
            this.coalesceString(stringBuffer, linkedList, letChainBuilder);
            linkedList.add(instruction2);
        }
    }

    private void coalesceString(StringBuffer stringBuffer, LinkedList linkedList, LetChainBuilder letChainBuilder) {
        if (stringBuffer != null && stringBuffer.length() > 0) {
            if (stringBuffer.length() > 5) {
                linkedList.add(letChainBuilder.bind(StreamInstruction.charStreamLiteral(stringBuffer.toString())));
            } else {
                for (int i = 0; i < stringBuffer.length(); ++i) {
                    linkedList.add(LiteralInstruction.charLiteral(stringBuffer.charAt(i)));
                }
            }
            stringBuffer.setLength(0);
        }
    }

    @Override
    protected Instruction optimizeStep(Instruction instruction2, Instruction instruction3, int n2) {
        if (instruction2 instanceof LetInstruction && ((LetInstruction)instruction2).getValue() instanceof StreamInstruction) {
            LetInstruction letInstruction = (LetInstruction)instruction2;
            LetChainBuilder letChainBuilder = null;
            letChainBuilder = new LetChainBuilder();
            Instruction instruction4 = this.optimizeStream((StreamInstruction)letInstruction.getValue(), letChainBuilder);
            if (instruction4 == letInstruction.getValue()) {
                return instruction2;
            }
            BindingEnvironment bindingEnvironment = this.getCurrentFunction().getBindingEnvironment();
            TypeEnvironment typeEnvironment = this.getCurrentFunction().getTypeEnvironment();
            LinkedList linkedList = new LinkedList();
            letInstruction.setValue(instruction4);
            LetInstruction letInstruction2 = letInstruction = (LetInstruction)letChainBuilder.packageUp(letInstruction);
            while (letInstruction != instruction2) {
                letInstruction.getValue().typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
                bindingEnvironment.setVariableBinding(letInstruction);
                letInstruction = (LetInstruction)letInstruction.getBody();
            }
            if (instruction3 != null) {
                instruction3.setChildInstruction(n2, letInstruction2);
            } else {
                this.getCurrentFunction().setBody(letInstruction2);
            }
        }
        return instruction2;
    }

    protected Instruction optimizeStream(StreamInstruction streamInstruction, LetChainBuilder letChainBuilder) {
        Object object2;
        if (streamInstruction.isString()) {
            return streamInstruction;
        }
        int n2 = streamInstruction.getChildInstructionCount();
        if (n2 == 1) {
            object2 = streamInstruction.getChildInstruction(0);
            try {
                if (this.resolveType((Instruction)object2).equals(this.resolveType(streamInstruction))) {
                    return object2;
                }
            }
            catch (NullPointerException nullPointerException) {
                return streamInstruction;
            }
        }
        object2 = new LinkedList();
        StringBuffer stringBuffer = null;
        if (streamInstruction.getType(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment()).equals(CharType.s_charType.getStreamType())) {
            stringBuffer = new StringBuffer();
        }
        this.collectStream(streamInstruction, (LinkedList)object2, letChainBuilder, stringBuffer);
        this.coalesceString(stringBuffer, (LinkedList)object2, letChainBuilder);
        StreamInstruction streamInstruction2 = new StreamInstruction(streamInstruction.getElementType(), (List)object2);
        Instruction.propagateInfo(streamInstruction, streamInstruction2);
        return streamInstruction2;
    }
}

