/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ScopedPostOrderOptimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class FindFreeVariables
extends ScopedPostOrderOptimizer {
    private HashSet<Object> m_freeVars = new HashSet();
    private LinkedList<HashSet<Object>> m_freeVarsStack = new LinkedList();

    protected FindFreeVariables() {
    }

    public static Set<Object> findFreeVariables(Instruction instruction2) {
        FindFreeVariables findFreeVariables = new FindFreeVariables();
        findFreeVariables.optimize(instruction2);
        return findFreeVariables.getFreeVars();
    }

    public static Set<IBinding> findFreeBindings(Instruction instruction2, BindingEnvironment bindingEnvironment) {
        FindFreeVariables findFreeVariables = new FindFreeVariables();
        findFreeVariables.optimize(instruction2);
        HashSet<IBinding> hashSet = new HashSet<IBinding>();
        for (Object object2 : findFreeVariables.getFreeVars()) {
            IBinding iBinding = bindingEnvironment.getVariableBinding(object2);
            if (iBinding == null) {
                throw new XylemError("ERR_SYSTEM", "unbound variable " + object2);
            }
            hashSet.add(iBinding);
        }
        return hashSet;
    }

    public HashSet<Object> getFreeVars() {
        return this.m_freeVars;
    }

    @Override
    protected void endOptimize(Instruction instruction2) {
        if (this.m_freeVarsStack.size() != 0) {
            throw new XylemError("ERR_SYSTEM", "!!!" + this.m_freeVarsStack.size());
        }
    }

    @Override
    protected void beginOptimize(Instruction instruction2) {
        this.m_freeVars.clear();
        this.m_freeVarsStack.clear();
    }

    @Override
    protected void preOrderStep(Instruction instruction2, Instruction instruction3, int n2) {
        if (instruction3 instanceof ISpecialForm && ((ISpecialForm)((Object)instruction3)).isChildInstructionBody(n2)) {
            this.m_freeVarsStack.add(this.m_freeVars);
            this.m_freeVars = new HashSet();
        }
    }

    protected void addVars(Instruction instruction2, Instruction instruction3, int n2) {
        if (instruction2 instanceof IdentifierInstruction) {
            this.m_freeVars.add(((IdentifierInstruction)instruction2).getVariable());
        }
    }

    @Override
    protected Instruction optimizeStep(Instruction instruction2, Instruction instruction3, int n2) {
        this.addVars(instruction2, instruction3, n2);
        this.removeVars(instruction2, instruction3, n2);
        return instruction2;
    }

    protected void removeVars(Instruction instruction2, Instruction instruction3, int n2) {
        if (instruction3 instanceof ISpecialForm && ((ISpecialForm)((Object)instruction3)).isChildInstructionBody(n2)) {
            IBinding[] iBindingArray = ((ISpecialForm)((Object)instruction3)).getChildInstructionBindings(n2);
            if (iBindingArray == null) {
                throw new XylemError("ERR_SYSTEM", "!" + n2 + " " + instruction2);
            }
            this.m_freeVars.removeAll(Arrays.asList(Binding.getNames(iBindingArray)));
            HashSet<Object> hashSet = this.m_freeVarsStack.removeLast();
            hashSet.addAll(this.m_freeVars);
            this.m_freeVars = hashSet;
        }
    }
}

