/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PostOrderOptimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class FindFreeBindings
extends PostOrderOptimizer {
    BindingEnvironment m_benv = new BindingEnvironment();
    private HashSet m_freeBindings = new HashSet();

    protected FindFreeBindings(BindingEnvironment bindingEnvironment) {
        this.m_benv = bindingEnvironment;
    }

    public static Set findFreeBindings(Instruction instruction2, BindingEnvironment bindingEnvironment) {
        FindFreeBindings findFreeBindings = new FindFreeBindings(bindingEnvironment);
        findFreeBindings.optimize(instruction2);
        return findFreeBindings.getFreeBindings();
    }

    public HashSet getFreeBindings() {
        return this.m_freeBindings;
    }

    @Override
    public Instruction optimize(Instruction instruction2) {
        this.m_freeBindings.clear();
        return super.optimize(instruction2);
    }

    @Override
    protected Instruction optimizeStep(Instruction instruction2, Instruction instruction3, int n2) {
        if (instruction2 instanceof IdentifierInstruction) {
            this.m_freeBindings.add(((IdentifierInstruction)instruction2).getBinding(this.m_benv));
        }
        return instruction2;
    }

    @Override
    protected void optimizeChildren(Instruction instruction2) {
        HashSet hashSet = null;
        int n2 = instruction2.getChildInstructionCount();
        hashSet = n2 < 2 ? this.m_freeBindings : new HashSet();
        for (int i = 0; i < n2; ++i) {
            Instruction instruction3 = instruction2.getChildInstruction(i);
            this.optimizeChildren(instruction3);
            Instruction instruction4 = this.optimizeStep(instruction3, instruction2, i);
            if (instruction2 instanceof ISpecialForm && ((ISpecialForm)((Object)instruction2)).isChildInstructionBody(i)) {
                IBinding[] iBindingArray = ((ISpecialForm)((Object)instruction2)).getChildInstructionBindings(i);
                if (iBindingArray == null) {
                    throw new XylemError("ERR_SYSTEM", "!" + i + " " + instruction2);
                }
                this.m_freeBindings.removeAll(Arrays.asList(iBindingArray));
            }
            if (hashSet == this.m_freeBindings) continue;
            hashSet.addAll(this.m_freeBindings);
            this.m_freeBindings.clear();
        }
        this.m_freeBindings = hashSet;
    }
}

