/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingDependencyInfo;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.TailRecursiveOptimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.DeadLetEliminatorOptimizer;
import com.ibm.xml.ras.LoggerUtil;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeadParameterEliminatorOptimizer
extends TailRecursiveOptimizer {
    protected Module m_prog;
    protected HashMap m_originalParameterSets;
    private static final Logger s_logger = LoggerUtil.getLogger(DeadParameterEliminatorOptimizer.class);
    private static final String s_className = DeadParameterEliminatorOptimizer.class.getName();
    boolean m_changed;
    ArrayList m_changedFunctions = new ArrayList();

    protected DeadParameterEliminatorOptimizer(Module module, HashMap hashMap) {
        this.m_prog = module;
        this.m_originalParameterSets = hashMap;
    }

    @Override
    protected Instruction optimizeStep2(Instruction instruction2) {
        if (instruction2 instanceof FunctionCallInstruction) {
            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction2;
            Function function2 = this.m_prog.getFunction(functionCallInstruction.getFunction());
            Binding[] bindingArray = (Binding[])this.m_originalParameterSets.get(function2);
            Function function3 = function2.lookupDerivative(DeadParameterEliminatorOptimizer.class);
            if (function3 != null && functionCallInstruction.getChildInstructionCount() != function3.m_parameters.length) {
                ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
                int n2 = bindingArray.length;
                int n3 = 0;
                for (int i = 0; i < n2 && n3 < function3.m_parameters.length; ++i) {
                    if (function3.m_parameters[n3] != bindingArray[i]) continue;
                    arrayList.add(functionCallInstruction.getChildInstruction(i));
                    ++n3;
                }
                functionCallInstruction.m_parameters = new Instruction[arrayList.size()];
                arrayList.toArray(functionCallInstruction.m_parameters);
                functionCallInstruction.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
                this.m_changed = true;
                return instruction2;
            }
        }
        return instruction2;
    }

    @Override
    public void optimizeFunction(Function function2) {
        this.m_changed = false;
        super.optimizeFunction(function2);
        if (this.m_changed) {
            function2.setBody(DeadLetEliminatorOptimizer.eliminateDeadLets(function2.getBody(), function2));
            this.m_changedFunctions.add(function2);
        }
    }

    public static void eliminateDeadParameters(Module module) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "eliminateDeadParameters", "Starting dead param elimination");
        }
        BuildFunctionCallGraph buildFunctionCallGraph = new BuildFunctionCallGraph();
        module.optimize(buildFunctionCallGraph);
        HashMap hashMap = buildFunctionCallGraph.m_callers;
        HashMap hashMap2 = new HashMap();
        final HashMap<Object, Binding[]> hashMap3 = new HashMap<Object, Binding[]>();
        ArrayList arrayList = new ArrayList(module.getFunctions());
        while (true) {
            AbstractCollection abstractCollection;
            Object object2;
            Iterator<Function> iterator = arrayList.iterator();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (iterator.hasNext()) {
                Function function2;
                Binding[] bindingArray;
                Instruction[] instructionArray;
                object2 = iterator.next();
                if (module.m_signature.containsFunction(((Function)object2).getName())) continue;
                abstractCollection = new ArrayList();
                Iterator<Binding> iterator2 = new ArrayList();
                ArrayList<LiteralInstruction> arrayList3 = new ArrayList<LiteralInstruction>();
                int n2 = ((Function)object2).m_parameters.length;
                HashMap hashMap4 = (HashMap)hashMap2.get(((Function)object2).getName());
                if (hashMap4 == null) {
                    hashMap4 = new HashMap();
                    ((Function)object2).determineDataDependencies(((Function)object2).m_parameters, hashMap4);
                    hashMap2.put(((Function)object2).getName(), hashMap4);
                }
                block2: for (int i = 0; i < n2; ++i) {
                    instructionArray = (Instruction[])hashMap4.get(((Function)object2).m_parameters[i]);
                    if (instructionArray == null || instructionArray.isEmpty()) continue;
                    bindingArray = instructionArray.iterator();
                    while (bindingArray.hasNext()) {
                        BindingDependencyInfo bindingDependencyInfo = (BindingDependencyInfo)bindingArray.next();
                        if (bindingDependencyInfo.getParent() instanceof FunctionCallInstruction) {
                            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)bindingDependencyInfo.getParent();
                            int n3 = functionCallInstruction.getChildInstructionIndex(bindingDependencyInfo.m_identifierInstruction);
                            if (n3 == -1) {
                                bindingArray.remove();
                                continue;
                            }
                            if (functionCallInstruction.getFunction().equals(((Function)object2).getName())) continue;
                            ((ArrayList)abstractCollection).add(((Function)object2).m_parameters[i]);
                            continue block2;
                        }
                        ((ArrayList)abstractCollection).add(((Function)object2).m_parameters[i]);
                        continue block2;
                    }
                    if (instructionArray.isEmpty()) continue;
                    ((ArrayList)((Object)iterator2)).add(((Function)object2).m_parameters[i]);
                    arrayList3.add(new LiteralInstruction(((Function)object2).m_parameters[i].getBindingType(), null));
                }
                if (((ArrayList)abstractCollection).size() == n2 || (function2 = ((Function)object2).lookupDerivative(DeadParameterEliminatorOptimizer.class)) != null && function2.m_parameters.length == ((ArrayList)abstractCollection).size()) continue;
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "eliminateDeadParameters", "shrinking " + ((Function)object2).getName());
                }
                hashMap3.put(object2, ((Function)object2).m_parameters);
                ((Function)object2).registerDerivative(DeadParameterEliminatorOptimizer.class, (Function)object2);
                ((Function)object2).setMemoizeResult(((Function)object2).getMemoizeResult());
                ((Function)object2).m_parameters = new Binding[((ArrayList)abstractCollection).size()];
                ((ArrayList)abstractCollection).toArray(((Function)object2).m_parameters);
                instructionArray = new Instruction[arrayList3.size()];
                arrayList3.toArray(instructionArray);
                bindingArray = new Binding[arrayList3.size()];
                ((ArrayList)((Object)iterator2)).toArray((Binding[])bindingArray);
                new TailRecursiveOptimizer(){

                    @Override
                    protected Instruction optimizeStep2(Instruction instruction2) {
                        FunctionCallInstruction functionCallInstruction;
                        if (instruction2 instanceof FunctionCallInstruction && (functionCallInstruction = (FunctionCallInstruction)instruction2).getFunction().equals(this.m_currentFunction.getOriginalFunction().getName())) {
                            Function function2 = this.m_currentFunction.getOriginalFunction();
                            Function function3 = this.m_currentFunction;
                            ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
                            Binding[] bindingArray = (Binding[])hashMap3.get(function2);
                            int n2 = bindingArray.length;
                            int n3 = 0;
                            for (int i = 0; i < n2 && n3 < function3.m_parameters.length; ++i) {
                                if (bindingArray[i] != function3.m_parameters[n3]) continue;
                                arrayList.add(functionCallInstruction.getChildInstruction(i));
                                ++n3;
                            }
                            functionCallInstruction.m_parameters = new Instruction[arrayList.size()];
                            arrayList.toArray(functionCallInstruction.m_parameters);
                            functionCallInstruction.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
                            return functionCallInstruction;
                        }
                        return instruction2;
                    }
                }.optimizeFunction((Function)object2);
                arrayList2.add(((Function)object2).getName());
                if (function2 == null) continue;
                function2.registerDerivative(DeadParameterEliminatorOptimizer.class, (Function)object2);
            }
            if (arrayList2.size() == 0) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "eliminateDeadParameters", "finished dead param elimination");
                }
                return;
            }
            object2 = new DeadParameterEliminatorOptimizer(module, hashMap3);
            abstractCollection = new HashSet();
            for (String string2 : arrayList2) {
                Collection collection2 = (Collection)hashMap.get(string2);
                if (collection2 == null) continue;
                abstractCollection.addAll(collection2);
            }
            for (String string3 : abstractCollection) {
                ((DeadParameterEliminatorOptimizer)object2).optimizeFunction(module.getFunction(string3));
            }
            arrayList = ((DeadParameterEliminatorOptimizer)object2).m_changedFunctions;
        }
    }

    static class BuildFunctionCallGraph
    extends TailRecursiveOptimizer {
        protected HashMap m_callers = new HashMap();

        BuildFunctionCallGraph() {
        }

        @Override
        protected Instruction optimizeStep2(Instruction instruction2) {
            if (instruction2 instanceof FunctionCallInstruction) {
                FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction2;
                HashSet<String> hashSet = (HashSet<String>)this.m_callers.get(functionCallInstruction.getFunction());
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                    this.m_callers.put(functionCallInstruction.getFunction(), hashSet);
                }
                hashSet.add(this.getCurrentFunction().getName());
            }
            return instruction2;
        }
    }
}

