/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetBaseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.LinkedList;

public class DeadLetEliminatorOptimizer
extends Optimizer {
    protected int m_eliminatedLetCount;

    public Instruction optimize(Instruction instruction2, Function function2) {
        this.m_currentFunction = function2;
        Instruction instruction3 = this.optimize(instruction2);
        this.m_currentFunction = null;
        return instruction3;
    }

    @Override
    public Instruction optimize(Instruction instruction2) {
        if (this.getCurrentFunction().getBindingEnvironment() == null) {
            return instruction2;
        }
        this.m_eliminatedLetCount = 0;
        LinkedList<Instruction> linkedList = new LinkedList<Instruction>();
        linkedList.add(instruction2);
        this.markUsedLets(this.getCurrentFunction().getBindingEnvironment(), linkedList);
        instruction2 = super.optimize(instruction2);
        return instruction2;
    }

    protected void markUsedLets(BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        while (!linkedList.isEmpty()) {
            Instruction instruction2;
            Instruction instruction3 = (Instruction)linkedList.removeFirst();
            while (instruction3 instanceof LetInstruction) {
                instruction2 = (LetInstruction)instruction3;
                ((LetInstruction)instruction2).m_inUse = false;
                instruction3 = ((LetBaseInstruction)instruction2).getBody();
            }
            if (instruction3 instanceof LiteralInstruction) continue;
            if (instruction3 instanceof IdentifierInstruction) {
                instruction2 = ((IdentifierInstruction)instruction3).getBinding(bindingEnvironment).getLet();
                if (instruction2 == null || ((LetInstruction)instruction2).m_inUse) continue;
                ((LetInstruction)instruction2).m_inUse = true;
                linkedList.add(((LetBaseInstruction)instruction2).getValue());
                continue;
            }
            if (instruction3 instanceof StreamInstruction && ((StreamInstruction)(instruction2 = (StreamInstruction)instruction3)).isStoredAsString()) continue;
            int n2 = instruction3.getChildInstructionCount();
            ISpecialForm iSpecialForm = instruction3 instanceof ISpecialForm ? (ISpecialForm)((Object)instruction3) : null;
            for (int i = 0; i < n2; ++i) {
                Instruction instruction4 = instruction3.getChildInstruction(i);
                if (iSpecialForm != null && iSpecialForm.isChildInstructionBody(i)) {
                    linkedList.add(instruction4);
                    continue;
                }
                if (instruction4 instanceof IdentifierInstruction) {
                    if (((IdentifierInstruction)instruction4).getBinding(bindingEnvironment) == null) {
                        throw new RuntimeException();
                    }
                    LetInstruction letInstruction = ((IdentifierInstruction)instruction4).getBinding(bindingEnvironment).getLet();
                    if (letInstruction == null || letInstruction.m_inUse) continue;
                    letInstruction.m_inUse = true;
                    linkedList.add(letInstruction.getValue());
                    continue;
                }
                if (instruction4 instanceof LiteralInstruction && instruction4 instanceof StreamInstruction) continue;
            }
        }
    }

    @Override
    protected Instruction optimizeStep(Instruction instruction2, Instruction instruction3, int n2) {
        if (!(instruction2 instanceof LetInstruction)) {
            return instruction2;
        }
        Instruction instruction4 = null;
        LetInstruction letInstruction = (LetInstruction)instruction2;
        while (true) {
            if (letInstruction.getBinding() == null) {
                if (instruction3 instanceof LetInstruction) {
                    throw new XylemError("ERR_SYSTEM", "let has null binding (or no dependancy info)" + ((LetInstruction)instruction3).getValue() + " " + letInstruction.getBody() + " " + instruction3.getClass());
                }
                throw new XylemError("ERR_SYSTEM", "let has null binding (or no dependancy info)" + letInstruction.getValue() + " " + letInstruction.getBody() + " " + instruction3.getClass());
            }
            Instruction instruction5 = null;
            if (!letInstruction.m_inUse) {
                ++this.m_eliminatedLetCount;
                instruction5 = letInstruction.optimizeOut();
            }
            if (instruction5 != null) {
                if (instruction3 != null) {
                    instruction3.setChildInstruction(n2, instruction5);
                } else {
                    instruction4 = instruction5;
                }
                if (!(instruction5 instanceof LetInstruction)) {
                    this.optimizeChildren(instruction5);
                    return instruction4;
                }
                letInstruction = (LetInstruction)instruction5;
                continue;
            }
            Instruction instruction6 = letInstruction.getBody();
            if (!(instruction6 instanceof LetInstruction)) break;
            Instruction instruction7 = letInstruction.getValue();
            Instruction instruction8 = this.optimizeStep(instruction7, letInstruction, 0);
            if (instruction8 == instruction7) {
                this.optimizeChildren(instruction8);
            } else {
                letInstruction.setValue(instruction8);
            }
            instruction3 = letInstruction;
            n2 = 1;
            letInstruction = (LetInstruction)instruction6;
        }
        this.optimizeChildren(letInstruction);
        return instruction4;
    }

    public static void eliminateDeadLets(Module module) {
        module.optimize(new DeadLetEliminatorOptimizer());
    }

    public static Instruction eliminateDeadLets(Instruction instruction2, Function function2) {
        DeadLetEliminatorOptimizer deadLetEliminatorOptimizer = new DeadLetEliminatorOptimizer();
        deadLetEliminatorOptimizer.m_currentFunction = function2;
        return deadLetEliminatorOptimizer.optimize(instruction2);
    }
}

