/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.interpreter;

import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.interpreter.AbstractDataObject;
import com.ibm.xltxe.rnm1.xylem.interpreter.IAppendableStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.IConvertible;
import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.InterpreterUtilities;
import com.ibm.xltxe.rnm1.xylem.interpreter.StreamUtilities;
import com.ibm.xltxe.rnm1.xylem.interpreter.Tuple;
import com.ibm.xltxe.rnm1.xylem.types.IForkReleaseManaged;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xltxe.rnm1.xylem.xci.prototype.XCIConstruction;
import com.ibm.xml.xci.Cursor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ListStream
implements IAppendableStream,
IConvertible,
IForkReleaseManaged {
    protected List<Object> m_list;
    protected boolean m_mustForkAndRelease = false;

    public ListStream() {
        this.m_list = new ArrayList<Object>();
    }

    public ListStream(List list) {
        this.init(list);
    }

    public ListStream(List list, boolean bl) {
        this.init(list, bl);
    }

    protected void init(List list) {
        this.init(list, true);
    }

    protected void init(List list, boolean bl) {
        this.m_list = new ArrayList<Object>();
        for (Object object2 : list) {
            if (object2 instanceof IForkReleaseManaged) {
                if (!this.m_mustForkAndRelease) {
                    this.m_mustForkAndRelease |= ((IForkReleaseManaged)object2).requiresRelease();
                }
                if (bl) {
                    object2 = ((IForkReleaseManaged)object2).evaluateInstanceFork();
                }
            } else if (object2 instanceof Cursor) {
                Cursor cursor2 = (Cursor)object2;
                if (bl) {
                    object2 = cursor2.fork(false, XCIConstruction.FEATURES_FOR_PROTOTYPE, XCIConstruction.FEATURES_LIMIT_FOR_PROTOTYPE);
                }
                if (!this.m_mustForkAndRelease) {
                    this.m_mustForkAndRelease = ((Cursor)object2).requiresRelease();
                }
            }
            this.m_list.add(object2);
        }
    }

    public ListStream(Object object2) {
        this.m_list = new ArrayList<Object>();
        if (object2 instanceof IForkReleaseManaged) {
            this.m_mustForkAndRelease = ((IForkReleaseManaged)object2).mustForkAndRelease();
            object2 = ((IForkReleaseManaged)object2).evaluateInstanceFork();
        } else if (object2 instanceof Cursor) {
            Cursor cursor2 = (Cursor)object2;
            object2 = cursor2.fork(false, XCIConstruction.FEATURES_FOR_PROTOTYPE, XCIConstruction.FEATURES_LIMIT_FOR_PROTOTYPE);
            this.m_mustForkAndRelease = true;
        }
        this.m_list.add(object2);
    }

    public Iterator iterator() {
        return new ForkingIterator(this.m_list.iterator());
    }

    @Override
    public void append(Object object2, Type type2) {
        assert (type2 != null);
        if (object2 instanceof ListStream) {
            ListStream listStream = (ListStream)object2;
            Iterator iterator = listStream.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                Object object3 = type2.evaluateVariableFork(object2);
                if (object3 != object2) {
                    this.m_mustForkAndRelease = true;
                }
                this.m_list.add(object3);
            }
        } else if (object2 instanceof IStream) {
            IStream iStream = (IStream)object2;
            Iterator<Object> iterator = iStream.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                Object object4 = type2.evaluateVariableFork(object2);
                if (object4 != object2) {
                    this.m_mustForkAndRelease = true;
                }
                this.m_list.add(object4);
            }
        } else {
            Object object5 = type2.evaluateVariableFork(object2);
            if (object5 != object2) {
                this.m_mustForkAndRelease = true;
            }
            this.m_list.add(object5);
        }
    }

    @Override
    public String toString() {
        InterpreterUtilities interpreterUtilities = new InterpreterUtilities();
        if (this.m_list.size() > 0 && this.m_list.get(0) instanceof AbstractDataObject) {
            return this.m_list.toString();
        }
        if (this.m_list.size() > 0 && this.m_list.get(0) instanceof Tuple && interpreterUtilities.getDebuggerflag()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (Tuple tuple : this.m_list) {
                stringBuffer.append(tuple.toString());
            }
            return stringBuffer.toString();
        }
        if (this.m_list.size() == 0 || this.m_list.get(0) instanceof Character) {
            return new String(this.toCharArray());
        }
        String string2 = "[";
        Iterator<Object> iterator = this.m_list.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            boolean bl2;
            Object object2 = iterator.next();
            string2 = string2 + (bl2 ? "" : ", ") + object2.toString();
            bl2 = false;
        }
        string2 = string2 + "]";
        return string2;
    }

    @Override
    public char[] toCharArray() {
        char[] cArray = new char[this.m_list.size()];
        Iterator<Object> iterator = this.m_list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            Character c = (Character)object2;
            cArray[n2++] = c.charValue();
        }
        return cArray;
    }

    @Override
    public Object convert(IntegerSettings integerSettings, Type type2) {
        if (type2 instanceof StreamType) {
            Type type3 = ((StreamType)type2).getElementType();
            Class clazz = type3.getJavaType(integerSettings);
            int[] nArray = new int[]{this.size()};
            Object object2 = Array.newInstance(clazz, nArray);
            for (int i = 0; i < this.size(); ++i) {
                Object object3 = this.get(i);
                if (object3 instanceof IConvertible) {
                    object3 = ((IConvertible)object3).convert(integerSettings, type3);
                }
                Array.set(object2, i, object3);
            }
            return object2;
        }
        if (type2.equals(JavaObjectType.s_javaStringType)) {
            return this.toString();
        }
        throw new XylemError("ERR_SYSTEM", "Can't convert ListStream to " + type2);
    }

    @Override
    public int size() {
        return this.m_list.size();
    }

    @Override
    public Object get(int n2) {
        return this.m_list.get(n2);
    }

    public boolean equals(Object object2) {
        if (object2 == null || !(object2 instanceof IStream)) {
            return false;
        }
        return StreamUtilities.equals(this, (IStream)object2);
    }

    @Override
    public void release() {
        if (this.m_mustForkAndRelease) {
            for (Object object2 : this.m_list) {
                if (object2 instanceof IForkReleaseManaged) {
                    ((IForkReleaseManaged)object2).release();
                    continue;
                }
                if (!(object2 instanceof Cursor)) continue;
                ((Cursor)object2).release();
            }
        }
    }

    @Override
    public boolean requiresRelease() {
        return this.m_mustForkAndRelease;
    }

    @Override
    public Object evaluateInstanceFork() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(this.m_list);
        ListStream listStream = new ListStream(arrayList);
        return listStream;
    }

    @Override
    public boolean mustForkAndRelease() {
        return this.m_mustForkAndRelease;
    }

    public class ForkingIterator
    implements Iterator {
        Iterator m_iter;

        public ForkingIterator(Iterator iterator) {
            this.m_iter = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.m_iter.hasNext();
        }

        public Object next() {
            Object e = this.m_iter.next();
            return XCIConstruction.evalForkIfNeeded(e);
        }

        @Override
        public void remove() {
            this.m_iter.remove();
        }
    }
}

