/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.interpreter;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.dataflow.ForkInformation;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.dp.util.misc.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FramedStack {
    private static final long serialVersionUID = 177098682861761697L;
    private static final Logger s_logger = LoggerUtil.getLogger(FramedStack.class);
    private static final String s_className = FramedStack.class.getName();
    private static final UnboundValue UNBOUNDVALUE = new UnboundValue();
    private static final UnboundIBinding UNBOUNDBINDING = new UnboundIBinding();
    private static final boolean LOG = false;
    private Object[] values;
    private IBinding[] ibindings;
    private int startCurrentStackFrame;
    private Stack<Integer> stackFrameStarts = new Stack();
    private int totalSizeOfStack;
    private Stack<Integer> framesSizes = new Stack();
    private static int INCREMENTSIZE = 65536;

    public FramedStack(int n2) {
        this.values = new Object[n2];
        this.ibindings = new IBinding[n2];
        this.framesSizes.push(0);
        this.stackFrameStarts.push(0);
        this.startCurrentStackFrame = 0;
    }

    public final void establishStackFrame(int n2) {
        this.totalSizeOfStack += n2;
        this.framesSizes.push(n2);
        if (this.totalSizeOfStack > this.values.length) {
            int n3 = n2 > INCREMENTSIZE ? n2 + INCREMENTSIZE : INCREMENTSIZE;
            Object[] objectArray = new Object[this.values.length + n3];
            IBinding[] iBindingArray = new IBinding[this.ibindings.length + n3];
            System.arraycopy(this.values, 0, objectArray, 0, this.values.length);
            System.arraycopy(this.ibindings, 0, iBindingArray, 0, this.ibindings.length);
            this.values = objectArray;
            this.ibindings = iBindingArray;
        }
        assert (this.garbageCurrentFrame(this.totalSizeOfStack - n2, n2));
    }

    public final void establishStackFrame(int n2, String string2) {
        this.totalSizeOfStack += n2;
        this.framesSizes.push(n2);
        assert (this.garbageCurrentFrame(this.totalSizeOfStack - n2, n2));
    }

    public final void pushStackFrame() {
        this.stackFrameStarts.push(this.startCurrentStackFrame);
        this.startCurrentStackFrame = this.totalSizeOfStack - this.framesSizes.peek();
    }

    public final void pushStackFrame(String string2) {
        this.stackFrameStarts.push(this.startCurrentStackFrame);
        this.startCurrentStackFrame = this.totalSizeOfStack - this.framesSizes.peek();
    }

    public final void popStackFrame() {
        assert (this.garbageCurrentFrame(this.startCurrentStackFrame, this.framesSizes.peek()));
        this.startCurrentStackFrame = this.stackFrameStarts.pop();
        int n2 = this.framesSizes.pop();
        this.totalSizeOfStack -= n2;
    }

    public final void popStackFrame(String string2) {
        assert (this.garbageCurrentFrame(this.startCurrentStackFrame, this.framesSizes.peek()));
        this.startCurrentStackFrame = this.stackFrameStarts.pop();
        int n2 = this.framesSizes.pop();
        this.totalSizeOfStack -= n2;
    }

    public final void bindInCurrentFrame(IBinding iBinding, Object object2) {
        assert (this.isGoodStackPos(iBinding));
        int n2 = this.startCurrentStackFrame + iBinding.getStackFramePos();
        this.values[n2] = object2;
        this.ibindings[n2] = iBinding;
    }

    public final void bindInEstablishedFrame(IBinding iBinding, Object object2) {
        assert (this.isGoodStackPos(iBinding));
        int n2 = this.totalSizeOfStack - this.framesSizes.peek() + iBinding.getStackFramePos();
        this.values[n2] = object2;
        this.ibindings[n2] = iBinding;
    }

    private boolean isGoodStackPos(IBinding iBinding) {
        if (iBinding.getStackFramePos() < 0) {
            String string2 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Bad binding: " + iBinding});
            RuntimeException runtimeException = new RuntimeException(string2);
            s_logger.logp(Level.SEVERE, s_className, "isGoodStackPos", string2, runtimeException);
            throw runtimeException;
        }
        return true;
    }

    public final Object lookupIBinding(IBinding iBinding) {
        int n2 = this.startCurrentStackFrame + iBinding.getStackFramePos();
        return this.ibindings[n2];
    }

    public final Object lookupBoundValue(IBinding iBinding) {
        int n2 = this.startCurrentStackFrame + iBinding.getStackFramePos();
        Object object2 = this.values[n2];
        assert (!(object2 instanceof UnboundValue));
        return object2;
    }

    public final IBinding lookupIBinding(int n2) {
        int n3 = this.startCurrentStackFrame + n2;
        IBinding iBinding = this.ibindings[n3];
        assert (!(iBinding instanceof UnboundIBinding));
        return iBinding;
    }

    public final Object lookupBoundValue(int n2) {
        int n3 = this.startCurrentStackFrame + n2;
        return this.values[n3];
    }

    private boolean garbageCurrentFrame(int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            this.values[n2 + i] = UNBOUNDVALUE;
            this.ibindings[n2 + i] = UNBOUNDBINDING;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendStackDump(stringBuffer);
        return stringBuffer.toString();
    }

    private void appendStackDump(StringBuffer stringBuffer) {
        stringBuffer.append("--- current stack freme ");
        stringBuffer.append(this.framesSizes.size() - 1);
        stringBuffer.append(" ---\n");
        int n2 = this.framesSizes.peek();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append("Value: ");
            stringBuffer.append(this.values[this.startCurrentStackFrame + i]);
            stringBuffer.append("  IBinding: ");
            stringBuffer.append(this.ibindings[this.startCurrentStackFrame + i]);
            stringBuffer.append(";\n");
        }
    }

    private static final void diag(String string2) {
    }

    private static class UnboundIBinding
    implements IBinding {
        private UnboundIBinding() {
        }

        public String toString() {
            return "(No Binding)";
        }

        @Override
        public Type getBindingType() {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public Type getBindingType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public LetInstruction getLet() {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public Object getName() {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public ISpecialForm getOrigin() {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public int getStackFramePos() {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public void setName(Object object2) {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public void setStackFramePos(int n2) {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public int compareTo(Object object2) {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public int getVariableUse() {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public void incrementVariableUse() {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public void passingIterator() {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public ForkInformation getForkInformation() {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public void setForkInformation(ForkInformation forkInformation) {
            throw new RuntimeException("called unbound variable binding!!");
        }
    }

    private static class UnboundValue {
        private UnboundValue() {
        }

        public String toString() {
            return "(Not Bound)";
        }
    }
}

