/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.interpreter;

import com.ibm.xltxe.rnm1.xylem.types.IForkReleaseManaged;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.Releasable;
import com.ibm.xml.xci.dp.util.misc.IntStack;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ForkStack {
    private int cursorCount = 0;
    static final int INITIALSTACKSIZE = 32;
    static final int GROWSTACKAMOUNT = 128;
    private Releasable[] forkedCursorsForRelease = new Releasable[32];
    private IntStack forkedCursorScopes = new IntStack(128);
    static int DEBUG_FORKSCOPE_COUNT = 0;
    static NullReleasable nullReleasable = new NullReleasable();

    public final void pushForkScope() {
        this.forkedCursorScopes.push(this.cursorCount);
    }

    public final void popForkScope(Releasable releasable) {
        boolean bl = false;
        int n2 = this.forkedCursorScopes.pop();
        for (int i = this.cursorCount - 1; i >= n2; --i) {
            Releasable releasable2 = this.forkedCursorsForRelease[i];
            if (bl || releasable2 != releasable) {
                releasable2.release();
                continue;
            }
            bl = true;
        }
        this.cursorCount = n2;
        if (bl) {
            this.pushForkForRelease(releasable);
        }
    }

    public final void popForkScope(Object object2) {
        boolean bl = false;
        int n2 = this.forkedCursorScopes.pop();
        for (int i = this.cursorCount - 1; i >= n2; --i) {
            Releasable releasable = this.forkedCursorsForRelease[i];
            if (bl || releasable != object2) {
                releasable.release();
                continue;
            }
            bl = true;
        }
        this.cursorCount = n2;
        if (bl) {
            this.pushForkForRelease((Releasable)object2);
        }
    }

    public final void popForkScope() {
        int n2 = this.forkedCursorScopes.pop();
        for (int i = this.cursorCount - 1; i >= n2; --i) {
            Releasable releasable = this.forkedCursorsForRelease[i];
            releasable.release();
        }
        this.cursorCount = n2;
    }

    public boolean popTopForkIfMatch(Releasable releasable) {
        Releasable releasable2;
        int n2 = this.cursorCount - 1;
        if (n2 >= 0 && releasable == (releasable2 = this.forkedCursorsForRelease[n2])) {
            --this.cursorCount;
            return true;
        }
        return false;
    }

    private void grow() {
        int n2 = this.forkedCursorsForRelease.length;
        Releasable[] releasableArray = new Releasable[n2 * 2];
        System.arraycopy(this.forkedCursorsForRelease, 0, releasableArray, 0, n2);
        this.forkedCursorsForRelease = releasableArray;
    }

    private final void push(Releasable releasable) {
        if (releasable.requiresRelease()) {
            if (this.cursorCount == this.forkedCursorsForRelease.length) {
                this.grow();
            }
            this.forkedCursorsForRelease[this.cursorCount++] = releasable;
        }
    }

    private final Releasable pushForkForRelease(Releasable releasable) {
        if (releasable != null) {
            this.push(releasable);
        }
        return releasable;
    }

    public final Cursor pushForkForRelease(Cursor cursor2) {
        if (cursor2 != null) {
            this.push(cursor2);
        }
        return cursor2;
    }

    public final IForkReleaseManaged pushIForkReleaseManagedForRelease(IForkReleaseManaged iForkReleaseManaged) {
        if (iForkReleaseManaged != null) {
            this.push(iForkReleaseManaged);
        }
        return iForkReleaseManaged;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (!this.forkedCursorScopes.isEmpty()) {
            int n2;
            int n3 = this.forkedCursorScopes.size();
            int n4 = n2 = this.cursorCount;
            for (int i = n3 - 1; i >= 0; --i) {
                printWriter.println("=== fork scopes #" + i + " ===");
                int n5 = this.forkedCursorScopes.get(i);
                n4 = this.printScope(printWriter, n4, n5, this.forkedCursorsForRelease, "Cursors");
            }
        } else {
            printWriter.println("=== fork scopes is empty ===");
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    private int printScope(PrintWriter printWriter, int n2, int n3, Releasable[] releasableArray, String string2) {
        int n4 = n2 - n3;
        if (n4 < 0) {
            n4 = 0;
        }
        if (n4 == 0) {
            printWriter.println("  (" + string2 + " empty)");
        } else {
            while (n2 > n3) {
                Releasable releasable;
                if ((releasable = releasableArray[--n2]) != null) {
                    printWriter.println("  " + string2 + " pos #" + n2 + " " + releasable.getClass().getSimpleName() + " - " + releasable.toString());
                    continue;
                }
                printWriter.println("  " + string2 + " pos #" + n2 + " (nulled entry)");
            }
            n2 = n3;
        }
        return n2;
    }

    public void removeForkForRelease(Cursor cursor2, boolean bl) {
        if (this.forkedCursorScopes.isEmpty()) {
            return;
        }
        int n2 = bl ? this.forkedCursorScopes.peek() : 0;
        int n3 = this.cursorCount;
        --n3;
        while (n3 >= n2) {
            Releasable releasable = this.forkedCursorsForRelease[n3];
            if (cursor2 == releasable) {
                this.forkedCursorsForRelease[n3] = nullReleasable;
                return;
            }
            --n3;
        }
    }

    public boolean isFound(Cursor cursor2, boolean bl) {
        return this.isFound(cursor2, bl, this.forkedCursorsForRelease, this.forkedCursorScopes);
    }

    public boolean isFound(IForkReleaseManaged iForkReleaseManaged, boolean bl) {
        return this.isFound(iForkReleaseManaged, bl, this.forkedCursorsForRelease, this.forkedCursorScopes);
    }

    public boolean isFound(Object object2, boolean bl) {
        return this.isFound(object2, bl, this.forkedCursorsForRelease, this.forkedCursorScopes) || this.isFound(object2, bl, this.forkedCursorsForRelease, this.forkedCursorScopes);
    }

    private boolean isFound(Object object2, boolean bl, Releasable[] releasableArray, IntStack intStack) {
        if (intStack.isEmpty()) {
            return false;
        }
        int n2 = bl ? intStack.peek() : 0;
        int n3 = this.cursorCount;
        --n3;
        while (n3 >= n2) {
            Releasable releasable = releasableArray[n3];
            if (object2 == releasable) {
                return true;
            }
            --n3;
        }
        return false;
    }

    public void removeIForkReleaseManagedForRelease(IForkReleaseManaged iForkReleaseManaged, boolean bl) {
        if (this.forkedCursorScopes.isEmpty()) {
            return;
        }
        int n2 = bl ? this.forkedCursorScopes.peek() : 0;
        int n3 = this.cursorCount;
        --n3;
        while (n3 >= n2) {
            Releasable releasable = this.forkedCursorsForRelease[n3];
            if (iForkReleaseManaged == releasable) {
                this.forkedCursorsForRelease[n3] = nullReleasable;
                return;
            }
            --n3;
        }
        assert (false) : "IForkReleaseManaged to be removed not found!";
    }

    static class NullReleasable
    implements Releasable {
        NullReleasable() {
        }

        @Override
        public void release() {
        }

        @Override
        public boolean requiresRelease() {
            return false;
        }
    }
}

