/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.interpreter;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.IContext;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.commandline.XylemC;
import com.ibm.xltxe.rnm1.xylem.instructions.ApplyInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LoopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.DebugTracer;
import com.ibm.xltxe.rnm1.xylem.interpreter.DebuggerQuitException;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.EvaluateTerminateException;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.BasicDynamicContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class Debugger
implements IDebuggerInterceptor {
    protected int m_verbosityLevel = 1;
    private String m_mostRecentConsoleMsg = "";
    private boolean m_sawNewLine = true;
    private ArrayList m_instructionBreakPoints = new ArrayList();
    private boolean m_waitingForBreakpoint = false;
    private ArrayList m_stack = new ArrayList();
    private ArrayList m_contextStack = new ArrayList();
    private Set m_functionBreakPoints = new HashSet();
    private boolean m_breakOnTerminate = true;
    private StackEntry m_target = null;
    private IContext m_contextTarget = null;
    Module m_module = null;
    protected int enterLeaveId = -1;
    InputStreamReader m_charReader = new InputStreamReader(System.in);
    BufferedReader m_reader = new BufferedReader(this.m_charReader);

    public static IDebuggerInterceptor factory(Module module) {
        Debugger debugger = null;
        String string2 = System.getProperty(IDebuggerInterceptor.class.getName());
        if (string2 == null || string2.equals(Debugger.class.getName())) {
            debugger = HiddenOptions.wasSpecified("filtracer") ? new DebugTracer(module) : new Debugger(module);
        } else {
            try {
                Class<?> clazz = Class.forName(string2);
                Constructor<?> constructor = clazz.getConstructor(Module.class);
                return (IDebuggerInterceptor)constructor.newInstance(module);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Debug interceptor class not found: " + string2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println("Debug interceptor class doesn't have the right constructor: " + string2);
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("Debug interceptor class instantiation failedr: " + string2);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("Debug interceptor class instantiation failedr: " + string2);
            }
            catch (InstantiationException instantiationException) {
                System.err.println("Debug interceptor class instantiation failedr: " + string2);
            }
        }
        return debugger;
    }

    public Debugger(Module module) {
        this.m_module = module;
    }

    @Override
    public int getVerbosityLevel() {
        return this.m_verbosityLevel;
    }

    private final StackEntry top() {
        if (this.m_stack.isEmpty()) {
            return null;
        }
        return (StackEntry)this.m_stack.get(this.m_stack.size() - 1);
    }

    private final Environment topEnvironment() {
        StackEntry stackEntry = this.top();
        return null == stackEntry ? null : stackEntry.m_envir;
    }

    private final String topEnvironmentString() {
        Environment environment = this.topEnvironment();
        return null == environment ? "--- No Environment ---" : environment.toString();
    }

    private final boolean shouldBreak(Instruction instruction2) {
        String string2 = ((IContext)this.m_contextStack.get(this.m_contextStack.size() - 1)).getName();
        for (int i = 0; i < this.m_instructionBreakPoints.size(); ++i) {
            InstructionBreakPoint instructionBreakPoint = (InstructionBreakPoint)this.m_instructionBreakPoints.get(i);
            if (!instructionBreakPoint.m_instruction.equals(instruction2.getClass()) || !instructionBreakPoint.m_functionName.equals(string2)) continue;
            if (instructionBreakPoint.m_lineno == 0) {
                return true;
            }
            if (instructionBreakPoint.m_lineno != instruction2.getSourceLineNumber()) continue;
            return true;
        }
        return false;
    }

    public static final Object leave(IDebuggerInterceptor iDebuggerInterceptor, Instruction instruction2, Environment environment, Function function2, Object object2) {
        if (null == iDebuggerInterceptor) {
            return object2;
        }
        iDebuggerInterceptor.leave(instruction2, environment, function2, object2);
        return object2;
    }

    public static final Object quietLeave(IDebuggerInterceptor iDebuggerInterceptor, Instruction instruction2, Environment environment, Function function2, Object object2) {
        if (null == iDebuggerInterceptor) {
            return object2;
        }
        iDebuggerInterceptor.quietLeave(instruction2, environment, function2, object2);
        return object2;
    }

    public static final Object leave(IDebuggerInterceptor iDebuggerInterceptor, String string2, Environment environment, Function function2, Object object2) {
        if (null == iDebuggerInterceptor) {
            return object2;
        }
        iDebuggerInterceptor.leave(string2, environment, function2, object2);
        return object2;
    }

    public static final EvaluateTerminateException terminate(IDebuggerInterceptor iDebuggerInterceptor, Instruction instruction2, Environment environment, Function function2, String string2) {
        EvaluateTerminateException evaluateTerminateException = new EvaluateTerminateException(string2);
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.terminate(instruction2, environment, function2, string2);
        }
        throw evaluateTerminateException;
    }

    public static final void enterContext(IDebuggerInterceptor iDebuggerInterceptor, IContext iContext) {
        if (null == iDebuggerInterceptor) {
            return;
        }
        iDebuggerInterceptor.enterContext(iContext);
    }

    public static final Object leaveContext(IDebuggerInterceptor iDebuggerInterceptor, IContext iContext, Object object2) {
        if (null == iDebuggerInterceptor) {
            return object2;
        }
        iDebuggerInterceptor.leaveContext(iContext, object2);
        return object2;
    }

    protected void enter1(Instruction instruction2, Environment environment, Function function2) throws DebuggerQuitException {
        this.m_stack.add(new StackEntry(instruction2, environment, function2));
        if (this.atStoppingPoint()) {
            this.commandLine(2);
        } else if (this.shouldBreak(instruction2)) {
            if (this.m_verbosityLevel < 2) {
                System.out.println("Found breakpoint");
            }
            this.m_waitingForBreakpoint = false;
            this.commandLine(2);
        }
    }

    @Override
    public void enter(String string2, Instruction instruction2, Environment environment, Function function2) throws DebuggerQuitException {
        if (this.m_verbosityLevel == 0) {
            System.out.println(++this.enterLeaveId + " Enter " + string2);
        } else {
            this.m_mostRecentConsoleMsg = "Enter " + string2;
        }
        this.enter1(instruction2, environment, function2);
    }

    @Override
    public void quietEnter(Instruction instruction2, Environment environment, Function function2) throws DebuggerQuitException {
        if (this.m_verbosityLevel != 0) {
            this.m_mostRecentConsoleMsg = "Enter " + instruction2;
        }
        this.enter1(instruction2, environment, function2);
    }

    @Override
    public void enter(Instruction instruction2, Environment environment, Function function2) throws DebuggerQuitException {
        this.enter(instruction2.toString(), instruction2, environment, function2);
    }

    protected void leave1(Environment environment, Function function2, Object object2) {
        StackEntry stackEntry;
        StackEntry stackEntry2 = stackEntry = this.m_stack.size() > 0 ? (StackEntry)this.m_stack.remove(this.m_stack.size() - 1) : null;
        if (stackEntry == this.m_target) {
            this.m_target = null;
        }
        if (this.atStoppingPoint()) {
            this.commandLine(0);
        }
    }

    @Override
    public void leave(String string2, Environment environment, Function function2, Object object2) {
        if (this.m_verbosityLevel == 0) {
            System.out.println(this.enterLeaveId-- + " Leave " + string2 + " --- value: " + object2);
        } else {
            this.m_mostRecentConsoleMsg = "Leave " + string2 + " --- value: " + object2;
        }
        this.leave1(environment, function2, object2);
    }

    @Override
    public void quietLeave(Instruction instruction2, Environment environment, Function function2, Object object2) {
        if (this.m_verbosityLevel == 0) {
            System.out.println(this.enterLeaveId + 1 + " Enter/Leave " + instruction2 + " --- value: " + object2);
        } else {
            this.m_mostRecentConsoleMsg = "Leave " + instruction2 + " --- value: " + object2;
        }
        this.leave1(environment, function2, object2);
    }

    @Override
    public void leave(Instruction instruction2, Environment environment, Function function2, Object object2) {
        this.leave(instruction2.toString(), environment, function2, object2);
    }

    @Override
    public void terminate(Instruction instruction2, Environment environment, Function function2, String string2) {
        System.out.println("Terminate " + instruction2 + " --- message: " + string2);
        if (this.atStoppingPoint() || this.m_breakOnTerminate) {
            this.commandLine(0);
        }
    }

    @Override
    public void enterContext(IContext iContext) throws DebuggerQuitException {
        if (this.m_verbosityLevel == 0) {
            System.out.println("Enter Context " + iContext.getName());
        } else {
            this.m_mostRecentConsoleMsg = "Enter Context " + iContext.getName();
        }
        this.enterContext1(iContext);
    }

    protected void enterContext1(IContext iContext) throws DebuggerQuitException {
        this.m_contextStack.add(iContext);
        if (this.atStoppingPoint() || this.m_functionBreakPoints.contains(iContext.getName())) {
            this.m_target = null;
            this.m_contextTarget = null;
            this.m_waitingForBreakpoint = false;
            this.commandLine(1);
        }
    }

    @Override
    public void leaveContext(IContext iContext, Object object2) {
        String string2;
        String string3 = string2 = iContext != null ? iContext.getName() : "";
        if (this.m_verbosityLevel == 0) {
            System.out.println("Leave Context " + string2 + " --- value: " + object2);
        } else {
            this.m_mostRecentConsoleMsg = "Leave Context " + string2 + " --- value: " + object2;
        }
        this.leaveContext1(iContext, object2);
    }

    protected void leaveContext1(IContext iContext, Object object2) {
        IContext iContext2 = (IContext)this.m_contextStack.remove(this.m_contextStack.size() - 1);
        if (iContext2 == this.m_contextTarget) {
            this.m_contextTarget = null;
        }
        if (this.atStoppingPoint()) {
            this.commandLine(0);
        }
    }

    private final boolean atStoppingPoint() {
        return null == this.m_target && null == this.m_contextTarget && !this.m_waitingForBreakpoint;
    }

    private void clearLine() throws IOException {
        this.m_reader.readLine();
    }

    protected void commandLine(int n2) throws DebuggerQuitException {
        try {
            block11: while (true) {
                Object object2;
                int n3;
                if (this.m_sawNewLine && this.m_mostRecentConsoleMsg.length() > 0) {
                    System.out.println(this.m_mostRecentConsoleMsg);
                    this.m_mostRecentConsoleMsg = "";
                    this.m_sawNewLine = false;
                }
                if (105 == (n3 = this.m_charReader.read())) {
                    return;
                }
                if (111 == n3) {
                    switch (n2) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.m_contextTarget = (IContext)this.m_contextStack.get(this.m_contextStack.size() - 1);
                            break;
                        }
                        case 2: {
                            this.m_target = (StackEntry)this.m_stack.get(this.m_stack.size() - 1);
                            break;
                        }
                        default: {
                            throw new XylemError("ERR_SYSTEM", "Bad stepOverFlag value (" + n2 + ")");
                        }
                    }
                    return;
                }
                if (101 == n3) {
                    try {
                        System.out.println(this.topEnvironmentString());
                    }
                    catch (Exception exception) {
                        System.err.println("Unexpected Exception: " + exception);
                        exception.printStackTrace();
                    }
                    continue;
                }
                if (115 == n3) {
                    int n4 = 1;
                    int n5 = this.m_contextStack.size() - 1;
                    while (true) {
                        if (n5 < 0) continue block11;
                        object2 = (IContext)this.m_contextStack.get(n5);
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(n4 + ":" + object2.getName());
                        if (object2.getDefinitionURL() != null) {
                            stringBuffer.append(" at " + new File(object2.getDefinitionURL().getFile()).getCanonicalPath() + " line " + object2.getDefinitionLineNumber());
                        }
                        System.out.println(stringBuffer.toString());
                        --n5;
                        ++n4;
                    }
                }
                if (102 == n3) {
                    System.out.print("Name of function to break on? > ");
                    this.clearLine();
                    String string2 = this.m_reader.readLine();
                    if (this.m_functionBreakPoints.contains(string2)) {
                        this.m_functionBreakPoints.remove(string2);
                        System.out.println("Removing function breakpoint for " + string2);
                        continue;
                    }
                    if (!this.lookupFunction(string2, this.m_module)) {
                        System.err.println("Can't find function \"" + string2 + "\".");
                        continue;
                    }
                    this.m_functionBreakPoints.add(string2);
                    System.out.println("Adding function breakpoint for " + string2);
                    continue;
                }
                if (99 == n3) {
                    this.m_target = null;
                    this.m_contextTarget = null;
                    this.m_waitingForBreakpoint = true;
                    return;
                }
                if (116 == n3) {
                    this.m_breakOnTerminate = !this.m_breakOnTerminate;
                    continue;
                }
                if (98 == n3) {
                    this.clearLine();
                    InstructionBreakPoint instructionBreakPoint = InstructionBreakPoint.getFromInput(true, this.m_module, this.m_reader);
                    if (null == instructionBreakPoint) continue;
                    this.m_instructionBreakPoints.add(instructionBreakPoint);
                    continue;
                }
                if (104 == n3) {
                    String string3 = ((IContext)this.m_contextStack.get(this.m_contextStack.size() - 1)).getName();
                    Instruction instruction2 = ((StackEntry)this.m_stack.get((int)(this.m_stack.size() - 1))).m_instr;
                    object2 = instruction2.getClass();
                    int n6 = instruction2.getSourceLineNumber();
                    this.m_instructionBreakPoints.add(new InstructionBreakPoint(string3, (Class)object2, n6));
                    continue;
                }
                if (66 == n3) {
                    int n7 = 0;
                    while (true) {
                        if (n7 >= this.m_instructionBreakPoints.size()) continue block11;
                        System.out.println("Break at " + (InstructionBreakPoint)this.m_instructionBreakPoints.get(n7));
                        ++n7;
                    }
                }
                if (118 == n3) {
                    System.out.print("Debugger verbosity set to ");
                    if (0 == this.m_verbosityLevel) {
                        this.m_verbosityLevel = 1;
                        System.out.println("normal");
                        continue;
                    }
                    this.m_verbosityLevel = 0;
                    System.out.println("verbose");
                    continue;
                }
                if (113 == n3) {
                    throw new DebuggerQuitException();
                }
                if (63 == n3) {
                    System.out.println("FIL Debugger commands:");
                    System.out.println("  f - set function breakpoint");
                    System.out.println("  c - continue FIL program execution");
                    System.out.println("  t - break on terminate");
                    System.out.println("  b - set instruction breakpoint");
                    System.out.println("  B - list instruction breakpoints");
                    System.out.println("  h - set instruction breakpoint here");
                    System.out.println("  v - toggle debugger verbosity level");
                    System.out.println("  q - quit");
                    System.out.println("  ? - show available commands");
                    continue;
                }
                if (10 == n3 || 13 == n3) {
                    this.m_sawNewLine = true;
                    continue;
                }
                System.err.println("Command '" + (char)n3 + "' not understood, try again.");
            }
        }
        catch (DebuggerQuitException debuggerQuitException) {
            throw debuggerQuitException;
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            System.err.println("Unexpected Exception");
        }
    }

    private boolean lookupFunction(String string2, Module module) {
        if (module.getFunction(string2) != null) {
            return true;
        }
        Iterator<Module> iterator = module.getModules().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getFunction(string2) == null) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        LinkedList<URL> linkedList = new LinkedList<URL>();
        try {
            SessionContext sessionContext = new SessionContext();
            linkedList.addFirst(new File(".").toURL());
            ModuleSignatureStore moduleSignatureStore = new ModuleSignatureStore(linkedList);
            URL uRL = new File(stringArray[0]).toURL();
            linkedList.addFirst(uRL);
            Module module = XylemC.XYLEMC.compile(uRL, null, linkedList, moduleSignatureStore);
            linkedList.removeFirst();
            Debugger debugger = new Debugger(module);
            BasicDynamicContext basicDynamicContext = new BasicDynamicContext(sessionContext);
            Environment environment = new Environment(basicDynamicContext);
            Function function2 = module.getFunction("main");
            debugger.enterContext(function2);
            Object object2 = function2.getBody().evaluate(environment, function2, debugger, false);
            debugger.leaveContext(function2, object2);
            environment.release(null);
            System.out.println("End of program execution.");
        }
        catch (DebuggerQuitException debuggerQuitException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class InstructionBreakPoint {
        private static Map m_instrMap = new HashMap();
        private int m_lineno = 0;
        private String m_functionName;
        private Class m_instruction;

        public InstructionBreakPoint(String string2, Class clazz, int n2) {
            this.m_functionName = string2;
            this.m_instruction = clazz;
            this.m_lineno = n2;
        }

        public String toString() {
            return this.m_instruction.getName() + " in " + this.m_functionName + (this.m_lineno != 0 ? " at line " + this.m_lineno : "");
        }

        private static void initInstrMap() {
            if (!m_instrMap.isEmpty()) {
                return;
            }
            m_instrMap.put("loop", LoopInstruction.class);
            m_instrMap.put("choose", ChooseInstruction.class);
            m_instrMap.put("apply", ApplyInstruction.class);
            m_instrMap.put("lambda", LambdaInstruction.class);
        }

        public static final InstructionBreakPoint getFromInput(boolean bl, Module module, BufferedReader bufferedReader) {
            InstructionBreakPoint.initInstrMap();
            try {
                String string2 = null;
                FunctionSignature functionSignature = null;
                if (bl) {
                    while (null == functionSignature) {
                        System.out.println("What's the enclosing function? ('cancel' to not add breakpoint) ");
                        string2 = bufferedReader.readLine();
                        if (string2.equals("cancel")) {
                            return null;
                        }
                        functionSignature = module.getFunctionSignature(string2);
                        if (null != functionSignature) continue;
                        System.err.println("Can't find function \"" + string2 + "\".");
                    }
                } else {
                    while (null == string2) {
                        System.out.println("What's the enclosing closure number? ('cancel' to not add breakpoint) ");
                        string2 = bufferedReader.readLine();
                        if (string2.equals("cancel")) {
                            return null;
                        }
                        string2 = "<closure " + string2 + ">";
                    }
                }
                String string3 = null;
                Class<?> clazz = null;
                while (null == clazz) {
                    System.out.println("What's the instruction? ('cancel' to not add breakpoint) ");
                    string3 = bufferedReader.readLine();
                    if (string3.equals("cancel")) {
                        return null;
                    }
                    clazz = (Class<?>)m_instrMap.get(string3);
                    if (null == clazz) {
                        try {
                            clazz = Class.forName("com.ibm.xltxe.rnm1.xylem.instructions." + string3);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (null == clazz) {
                        try {
                            clazz = Class.forName(string3);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (null != clazz) continue;
                    System.err.println("I don't know about instr \"" + string3 + "\".");
                }
                return new InstructionBreakPoint(string2, clazz, 0);
            }
            catch (IOException iOException) {
                System.out.println("Unexpected IOException: " + iOException);
                return null;
            }
        }
    }

    public class StackEntry {
        Instruction m_instr;
        Environment m_envir;
        Function m_func;

        public StackEntry(Instruction instruction2, Environment environment, Function function2) {
            this.m_instr = instruction2;
            this.m_envir = environment;
            this.m_func = function2;
        }

        public boolean equals(Object object2) {
            if (!(object2 instanceof StackEntry)) {
                return false;
            }
            return this.m_instr == ((StackEntry)object2).m_instr;
        }
    }
}

