/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.interpreter;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IContext;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.DebuggerQuitException;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;

public class DebugTracer
extends Debugger {
    public DebugTracer(Module module) {
        super(module);
        this.m_verbosityLevel = 0;
    }

    @Override
    public void enter(String string2, Instruction instruction2, Environment environment, Function function2) throws DebuggerQuitException {
        System.out.println("<!--" + string2 + "\n-->\n<Evaluate_" + ++this.enterLeaveId + ">\n");
        this.enter1(instruction2, environment, function2);
    }

    @Override
    public void quietEnter(Instruction instruction2, Environment environment, Function function2) throws DebuggerQuitException {
        this.enter1(instruction2, environment, function2);
    }

    @Override
    public void leave(String string2, Environment environment, Function function2, Object object2) {
        System.out.println("</Evaluate_" + this.enterLeaveId-- + "><!--" + object2 + "-->\n");
        this.leave1(environment, function2, object2);
    }

    @Override
    public void quietLeave(Instruction instruction2, Environment environment, Function function2, Object object2) {
        System.out.println("<Evaluate_" + (this.enterLeaveId + 1) + "/><!--" + object2 + "-->\n");
        this.leave1(environment, function2, object2);
    }

    @Override
    public void enterContext(IContext iContext) throws DebuggerQuitException {
        StringBuffer stringBuffer = new StringBuffer("");
        if (iContext != null) {
            if (iContext instanceof Function) {
                Function function2 = (Function)iContext;
                stringBuffer.append("(");
                String string2 = function2.getName();
                stringBuffer.append(string2);
                Binding[] bindingArray = function2.getParameters();
                for (int i = 0; i < bindingArray.length; ++i) {
                    stringBuffer.append(" ");
                    stringBuffer.append(bindingArray[i].getName());
                }
                stringBuffer.append(")");
            } else {
                stringBuffer.append(iContext.getName());
            }
        }
        System.out.println("<!--" + stringBuffer.toString() + "-->\n<context>");
        this.enterContext1(iContext);
    }

    @Override
    public void leaveContext(IContext iContext, Object object2) {
        System.out.println("</context><!--" + object2 + "-->\n");
        this.leaveContext1(iContext, object2);
    }

    private final boolean atStoppingPoint() {
        return false;
    }

    @Override
    protected final void commandLine(int n2) throws DebuggerQuitException {
    }
}

