/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.interpreter;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IContext;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.IForkReleaseManaged;
import com.ibm.xltxe.rnm1.xylem.xci.prototype.XCIConstruction;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.Releasable;
import java.net.URL;

public class Closure
implements IContext,
IForkReleaseManaged {
    public Object[] m_closureValues;
    public IBinding[] m_closureBindings;
    public Function m_function;
    public Instruction m_expression;
    public IBinding[] m_params;
    public URL m_definitionURL;
    public int m_definitionLineNumber;
    public boolean m_mustForkAndRelease = false;
    public boolean m_requiresRelease = false;
    public int m_stackFrameSize;

    public Closure() {
    }

    public Closure(IBinding[] iBindingArray, Object[] objectArray, Function function2, Instruction instruction2, IBinding[] iBindingArray2, URL uRL, int n2, int n3) {
        this.m_closureBindings = iBindingArray;
        this.setClosureValues(objectArray);
        this.m_function = function2;
        this.m_expression = instruction2;
        this.m_params = iBindingArray2;
        this.m_definitionURL = uRL;
        this.m_definitionLineNumber = n2;
        this.m_stackFrameSize = n3;
    }

    public void setClosureValues(Object[] objectArray) {
        this.m_closureValues = objectArray;
        if (this.m_closureValues != null) {
            for (int i = this.m_closureValues.length - 1; i >= 0 && !this.m_mustForkAndRelease; --i) {
                Object object2 = this.m_closureValues[i];
                if (object2 instanceof Cursor) {
                    this.m_mustForkAndRelease = true;
                    if (this.m_requiresRelease) continue;
                    this.m_requiresRelease = ((Cursor)object2).requiresRelease();
                    continue;
                }
                if (!(object2 instanceof IForkReleaseManaged)) continue;
                this.m_mustForkAndRelease |= ((IForkReleaseManaged)object2).mustForkAndRelease();
                if (this.m_requiresRelease) continue;
                this.m_requiresRelease = ((IForkReleaseManaged)object2).requiresRelease();
            }
        }
    }

    @Override
    public String getName() {
        return "<closure " + this.hashCode() + ">";
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public URL getDefinitionURL() {
        return this.m_definitionURL;
    }

    @Override
    public int getDefinitionLineNumber() {
        return this.m_definitionLineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(Environment environment, Object[] objectArray, IDebuggerInterceptor iDebuggerInterceptor) {
        environment.pushForkScope();
        Object object2 = null;
        try {
            int n2;
            IBinding[] iBindingArray = this.getParams();
            environment.establishStackFrame(this.getStackFrameSize(), this.getName());
            assert (iBindingArray.length == objectArray.length);
            for (n2 = 0; n2 < iBindingArray.length; ++n2) {
                environment.bindInEstablishedFrame(iBindingArray[n2], objectArray[n2]);
            }
            environment.pushStackFrame(this.getName());
            Debugger.enterContext(iDebuggerInterceptor, this);
            assert (this.m_closureBindings.length == this.m_closureValues.length);
            n2 = this.m_closureBindings.length;
            for (int i = 0; i < n2; ++i) {
                Object object3 = this.m_closureValues[i];
                IBinding iBinding = this.m_closureBindings[i];
                environment.bindInCurrentFrame(iBinding, object3);
            }
            object2 = this.m_expression.evaluate(environment, this.m_function, iDebuggerInterceptor, false);
            Debugger.leaveContext(iDebuggerInterceptor, this, object2);
            environment.popStackFrame(this.getName());
            environment.popForkScope(object2);
        }
        catch (Throwable throwable) {
            environment.popForkScope(object2);
            throw throwable;
        }
        return object2;
    }

    public Object evaluate(Environment environment, IDebuggerInterceptor iDebuggerInterceptor) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(Environment environment, Function function2, Instruction[] instructionArray, IDebuggerInterceptor iDebuggerInterceptor) {
        environment.pushForkScope();
        Object object2 = null;
        try {
            int n2;
            IBinding[] iBindingArray = this.getParams();
            environment.establishStackFrame(this.getStackFrameSize(), this.getName());
            for (n2 = 0; n2 < iBindingArray.length; ++n2) {
                Object object3 = instructionArray[n2].evaluate(environment, function2, iDebuggerInterceptor, false);
                environment.bindInEstablishedFrame(iBindingArray[n2], object3);
            }
            environment.pushStackFrame(this.getName());
            Debugger.enterContext(iDebuggerInterceptor, this);
            assert (this.m_closureBindings.length == this.m_closureValues.length);
            n2 = this.m_closureBindings.length;
            for (int i = 0; i < n2; ++i) {
                Object object4 = this.m_closureValues[i];
                IBinding iBinding = this.m_closureBindings[i];
                environment.bindInCurrentFrame(iBinding, object4);
            }
            object2 = this.m_expression.evaluate(environment, this.m_function, iDebuggerInterceptor, false);
            Debugger.leaveContext(iDebuggerInterceptor, this, object2);
            environment.popStackFrame(this.getName());
            environment.popForkScope(object2);
        }
        catch (Throwable throwable) {
            environment.popForkScope(object2);
            throw throwable;
        }
        return object2;
    }

    @Override
    public void release() {
        if (this.m_requiresRelease && this.m_mustForkAndRelease) {
            for (int i = this.m_closureValues.length - 1; i >= 0; --i) {
                Object object2 = this.m_closureValues[i];
                if (!(object2 instanceof Releasable)) continue;
                ((Releasable)object2).release();
            }
        }
    }

    @Override
    public boolean requiresRelease() {
        return this.m_requiresRelease;
    }

    @Override
    public Object evaluateInstanceFork() {
        if (this.m_mustForkAndRelease) {
            Object[] objectArray = (Object[])this.m_closureValues.clone();
            for (int i = objectArray.length - 1; i >= 0; --i) {
                Object object2 = objectArray[i];
                if (object2 instanceof IForkReleaseManaged) {
                    objectArray[i] = ((IForkReleaseManaged)object2).evaluateInstanceFork();
                    continue;
                }
                if (!(object2 instanceof Cursor)) continue;
                Cursor cursor2 = (Cursor)object2;
                objectArray[i] = cursor2.fork(false, XCIConstruction.FEATURES_FOR_PROTOTYPE, XCIConstruction.FEATURES_LIMIT_FOR_PROTOTYPE);
            }
            return new Closure(this.m_closureBindings, objectArray, this.m_function, this.m_expression, this.m_params, this.m_definitionURL, this.m_definitionLineNumber, this.m_stackFrameSize);
        }
        return this;
    }

    @Override
    public boolean mustForkAndRelease() {
        return this.m_mustForkAndRelease;
    }

    public IBinding[] getParams() {
        return this.m_params;
    }

    public void setParams(IBinding[] iBindingArray) {
        this.m_params = iBindingArray;
    }

    public int getStackFrameSize() {
        return this.m_stackFrameSize;
    }

    public void setStackFrameSize(int n2) {
        this.m_stackFrameSize = n2;
    }
}

