/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.interpreter;

import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.StringStream;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.IForkReleaseManaged;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.Releasable;
import java.util.Iterator;

public class AbstractDataObject
implements IForkReleaseManaged {
    protected Object[] m_values;
    protected AbstractDataType.Constructor m_constructor;
    protected boolean m_mustForkAndRelease = false;
    private boolean m_containsCursors = false;
    private boolean m_requiresRelease = false;

    AbstractDataObject() {
    }

    public AbstractDataObject(AbstractDataType.Constructor constructor, Object[] objectArray, boolean bl) {
        this.init(constructor, objectArray, bl);
    }

    public AbstractDataObject(AbstractDataType.Constructor constructor, Object[] objectArray) {
        this(constructor, objectArray, false);
    }

    protected void init(AbstractDataType.Constructor constructor, Object[] objectArray) {
        this.init(constructor, objectArray, false);
    }

    protected void init(AbstractDataType.Constructor constructor, Object[] objectArray, boolean bl) {
        this.m_constructor = constructor;
        this.m_values = objectArray;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = objectArray.length - 1; i >= 0; --i) {
            Releasable releasable;
            Object object2 = objectArray[i];
            if (object2 instanceof Cursor) {
                bl3 = true;
                if (!bl) continue;
                releasable = ((Cursor)object2).fork(false);
                bl2 = true;
                if (!this.m_requiresRelease) {
                    this.m_requiresRelease = releasable.requiresRelease();
                }
                objectArray[i] = releasable;
                continue;
            }
            if (!(object2 instanceof IForkReleaseManaged)) continue;
            bl3 = true;
            if (!bl) continue;
            releasable = (IForkReleaseManaged)((IForkReleaseManaged)object2).evaluateInstanceFork();
            bl2 = true;
            if (!this.m_requiresRelease) {
                this.m_requiresRelease = releasable.requiresRelease();
            }
            objectArray[i] = releasable;
        }
        this.m_containsCursors = bl3;
        this.m_mustForkAndRelease = bl2;
    }

    public AbstractDataType.Constructor getConstructor() {
        return this.m_constructor;
    }

    public Object[] getValues() {
        return this.m_values;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append('(');
        stringBuffer.append(this.m_constructor.getName());
        for (int i = 0; i < this.m_values.length; ++i) {
            stringBuffer.append(' ');
            String string2 = this.m_constructor.m_parameters[i].getName().toString();
            Object object2 = this.m_values[i];
            if (object2 instanceof String || object2 instanceof StringStream) {
                object2 = "\"" + object2 + "\"";
            } else if (object2 instanceof IStream) {
                IStream iStream = (IStream)object2;
                StringBuffer stringBuffer2 = new StringBuffer("(stream");
                Iterator<Object> iterator = iStream.iterator();
                while (iterator.hasNext()) {
                    stringBuffer2.append(' ');
                    stringBuffer2.append(iterator.next());
                }
                stringBuffer2.append(')');
                object2 = stringBuffer2.toString();
            }
            if (string2.startsWith("attribute:")) {
                stringBuffer.append(object2);
                continue;
            }
            stringBuffer.append(object2);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public boolean equals(Object object2) {
        if (object2 == null || !(object2 instanceof AbstractDataObject)) {
            return false;
        }
        AbstractDataObject abstractDataObject = (AbstractDataObject)object2;
        if (abstractDataObject.m_constructor != this.m_constructor || abstractDataObject.m_values.length != this.m_values.length) {
            return false;
        }
        for (int i = 0; i < this.m_values.length; ++i) {
            if (this.m_values[i] == null && abstractDataObject.m_values[i] == null) {
                return true;
            }
            if (this.m_values[i].equals(abstractDataObject.m_values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void release() {
        if (this.m_requiresRelease && this.m_mustForkAndRelease) {
            this.m_mustForkAndRelease = false;
            for (int i = this.m_values.length - 1; i >= 0; --i) {
                Object object2 = this.m_values[i];
                if (object2 instanceof Releasable) {
                    ((Releasable)object2).release();
                }
                assert (this.nullValue(this.m_values, i));
            }
        }
    }

    @Override
    public boolean requiresRelease() {
        return this.m_requiresRelease;
    }

    private final boolean nullValue(Object[] objectArray, int n2) {
        objectArray[n2] = null;
        return true;
    }

    @Override
    public Object evaluateInstanceFork() {
        if (this.m_containsCursors) {
            Object[] objectArray = (Object[])this.m_values.clone();
            return new AbstractDataObject(this.m_constructor, objectArray, true);
        }
        return this;
    }

    @Override
    public boolean mustForkAndRelease() {
        return this.m_mustForkAndRelease;
    }
}

