/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.GenFork;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.TagType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import java.io.IOException;
import java.util.LinkedList;

public class UntagInstruction
extends UnaryPrimopInstruction {
    protected String m_tag;
    protected Type m_elementType;

    public UntagInstruction(String string2, Instruction instruction2) {
        super(instruction2);
        this.m_tag = string2;
    }

    public UntagInstruction() {
    }

    public Type getElementType(TypeEnvironment typeEnvironment) {
        return ((TagType)this.getCachedType()).getElementType();
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, String string2, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        return this.m_operand.generateCode(fcgCodeGenHelper, codeGenerationTracker, string2, bl, fcgInstructionList, genFork);
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        this.m_elementType = new TypeVariable();
        TagType tagType = new TagType(this.m_tag, this.m_elementType);
        typeEnvironment.unify(this.m_operand.typeCheck(typeEnvironment, bindingEnvironment, linkedList), tagType, this);
        return this.setCachedType(this.m_elementType);
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_elementType;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature moduleSignature) {
        return this.m_elementType;
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        super.generateReducedForm(reductionHelper, instructionArray, bindingEnvironment);
        this.setupType(reductionHelper.m_typeEnvironment, bindingEnvironment);
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        super.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
        this.setupType(typeEnvironment, bindingEnvironment);
    }

    protected void setupType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type type2 = this.m_operand.getType(typeEnvironment, bindingEnvironment);
        if (type2 instanceof TagType) {
            this.m_elementType = ((TagType)type2).getElementType();
        } else if (this.m_elementType == null) {
            this.m_elementType = new TypeVariable();
        }
        try {
            typeEnvironment.unify(new TagType(this.m_tag, this.m_elementType), this.m_operand.getType(typeEnvironment, bindingEnvironment), this);
        }
        catch (TypeCheckException typeCheckException) {
            typeCheckException.printStackTrace();
            throw new RuntimeException(typeCheckException);
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        UntagInstruction untagInstruction = new UntagInstruction(this.m_tag, this.m_operand.cloneWithoutTypeInformation());
        UntagInstruction.propagateInfo(this, untagInstruction);
        return untagInstruction;
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction2) {
        UntagInstruction untagInstruction = new UntagInstruction(this.m_tag, instruction2);
        UntagInstruction.propagateInfo(this, untagInstruction);
        return untagInstruction;
    }

    @Override
    public String innerToString() {
        return "untag " + this.m_tag;
    }

    @Override
    public boolean equals(Object object2) {
        return super.equals(object2) && ((UntagInstruction)object2).m_tag.equals(this.m_tag);
    }

    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function2);
        }
        Object object2 = this.m_operand.evaluate(environment, function2, iDebuggerInterceptor, false);
        return Debugger.leave(iDebuggerInterceptor, this, environment, function2, object2);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_tag = readObjectFileHelper.readString();
        this.m_elementType = readObjectFileHelper.readType();
        if (this.m_elementType == null) {
            throw new RuntimeException();
        }
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeString(this.m_tag);
        writeObjectFileHelper.writeType(this.m_elementType);
    }

    @Override
    public boolean isStatic(BindingEnvironment bindingEnvironment) {
        return this.m_operand.isStatic(bindingEnvironment);
    }

    @Override
    public Type getTypeParameter(int n2) {
        if (n2 == 0) {
            return this.m_elementType;
        }
        return null;
    }

    @Override
    public void setTypeParameter(int n2, Type type2) {
        if (n2 == 0) {
            this.m_elementType = type2;
        }
    }

    @Override
    public int getTypeParameterCount() {
        return this.m_elementType == null ? 0 : 1;
    }
}

