/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.GenFork;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.Tuple;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.TupleType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xltxe.rnm1.xylem.xci.prototype.XCIConstruction;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TupleMatchInstruction
extends Instruction
implements ISpecialForm {
    private static final Logger s_logger = LoggerUtil.getLogger(TupleMatchInstruction.class);
    private static final String s_className = TupleMatchInstruction.class.getName();
    protected Instruction m_toMatch;
    protected Instruction m_body;
    protected Binding[] m_bindings;

    public TupleMatchInstruction() {
    }

    public TupleMatchInstruction(Instruction instruction2, Object[] objectArray, Instruction instruction3) {
        this.m_toMatch = instruction2;
        this.m_bindings = Binding.getBindings(objectArray);
        this.m_body = instruction3;
    }

    public TupleMatchInstruction(Instruction instruction2, int n2, int n3) {
        this.m_bindings = new Binding[n2];
        String string2 = OptimizerUtilities.generateIntermediateIdentifier() + "_";
        for (int i = 0; i < n2; ++i) {
            this.m_bindings[i] = new Binding(string2 + i);
        }
        this.m_body = new IdentifierInstruction(this.m_bindings[n3].getName());
        this.m_toMatch = instruction2;
    }

    public Instruction getToMatch() {
        return this.m_toMatch;
    }

    public Object[] getVariableNames() {
        return Binding.getNames(this.m_bindings);
    }

    public Instruction getBody() {
        return this.m_body;
    }

    public Binding[] getBindings() {
        return this.m_bindings;
    }

    @Override
    public int getChildInstructionCount() {
        return 2;
    }

    @Override
    public Instruction getChildInstruction(int n2) {
        switch (n2) {
            case 0: {
                return this.m_toMatch;
            }
            case 1: {
                return this.m_body;
            }
        }
        return null;
    }

    @Override
    public void setChildInstruction(int n2, Instruction instruction2) {
        switch (n2) {
            case 0: {
                this.m_toMatch = instruction2;
                break;
            }
            case 1: {
                this.m_body = instruction2;
            }
        }
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, String string2, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        throw new UnsupportedOperationException("tuple-match is syntactic sugar and must be removed prior to codegen");
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        TupleMatchInstruction tupleMatchInstruction = new TupleMatchInstruction(this.m_toMatch.cloneWithoutTypeInformation(), Binding.getNames(this.m_bindings), this.m_body.cloneWithoutTypeInformation());
        TupleMatchInstruction.propagateInfo(this, tupleMatchInstruction);
        return tupleMatchInstruction;
    }

    @Override
    public Instruction cloneShallow() {
        TupleMatchInstruction tupleMatchInstruction = new TupleMatchInstruction(this.m_toMatch, Binding.getNames(this.m_bindings), this.m_body);
        TupleMatchInstruction.propagateInfo(this, tupleMatchInstruction);
        return tupleMatchInstruction;
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        this.m_toMatch = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_toMatch, bindingEnvironment);
        ReductionHelper reductionHelper2 = (ReductionHelper)reductionHelper.clone();
        for (int i = 0; i < this.m_bindings.length; ++i) {
            reductionHelper2.upgradeBinding(this.m_bindings[i]);
            bindingEnvironment.setVariableBinding(this.m_bindings[i]);
        }
        this.m_body = reductionHelper2.reduce(this.m_body, bindingEnvironment);
        this.m_bindingEnvironment = null;
        instructionArray[0] = this;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type[] typeArray = new Type[this.m_bindings.length];
        BindingEnvironment bindingEnvironment2 = new BindingEnvironment(bindingEnvironment);
        for (int i = 0; i < typeArray.length; ++i) {
            this.m_bindings[i].setTypeEnvironment(typeEnvironment);
            typeArray[i] = this.m_bindings[i].getBindingType();
            bindingEnvironment2.setVariableBinding(this.m_bindings[i]);
        }
        typeEnvironment.unify(new TupleType(typeArray), this.m_toMatch.typeCheck(typeEnvironment, bindingEnvironment, linkedList), this);
        return this.setCachedType(this.m_body.typeCheck(typeEnvironment, bindingEnvironment2, linkedList));
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        Type type2 = null;
        try {
            this.m_toMatch.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
            type2 = this.m_toMatch.getType(typeEnvironment, bindingEnvironment);
            Type[] typeArray = new Type[this.m_bindings.length];
            for (int i = 0; i < typeArray.length; ++i) {
                typeArray[i] = this.m_bindings[i].getBindingType();
                this.m_bindings[i].setType(typeArray[i]);
                bindingEnvironment.setVariableBinding(this.m_bindings[i]);
            }
            typeEnvironment.unify(new TupleType(typeArray), type2, this);
            this.m_body.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
        }
        catch (TypeCheckException typeCheckException) {
            FFDCUtil.log(typeCheckException, this);
            String string2 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"type check exception in tuple-match"});
            s_logger.logp(Level.SEVERE, s_className, "typeCheckReduced", string2, typeCheckException);
            throw new XylemError(string2);
        }
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_body.getType(typeEnvironment, bindingEnvironment);
    }

    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function2);
        }
        environment.pushForkScope();
        Object object2 = null;
        try {
            Tuple tuple = (Tuple)this.m_toMatch.evaluate(environment, function2, iDebuggerInterceptor, false);
            Object[] objectArray = tuple.getValues();
            int n2 = this.m_bindings.length;
            for (int i = 0; i < n2; ++i) {
                Object object3 = objectArray[i];
                object3 = XCIConstruction.evalForkIfNeeded(object3, environment);
                environment.bindInCurrentFrame(this.m_bindings[i], object3);
            }
            object2 = this.m_body.evaluate(environment, function2, iDebuggerInterceptor, bl);
        }
        catch (FunctionCallInstruction.TailCallEvent tailCallEvent) {
            try {
                throw tailCallEvent;
            }
            catch (Throwable throwable) {
                environment.popForkScope(object2);
                throw throwable;
            }
        }
        environment.popForkScope(object2);
        return Debugger.leave(iDebuggerInterceptor, this, environment, function2, object2);
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n2) {
        prettyPrinter.newline();
        prettyPrinter.printFormOpen("tuple-match", n2);
        if (this.m_toMatch == null) {
            prettyPrinter.print(" !null!");
        } else {
            this.m_toMatch.toString(prettyPrinter, n2 + 1);
        }
        prettyPrinter.print("(");
        for (int i = 0; i < this.m_bindings.length; ++i) {
            prettyPrinter.printIdentifier(this.m_bindings[i], n2 + 2);
        }
        prettyPrinter.printFormClose(n2);
        this.m_body.toString(prettyPrinter, n2 + 1);
        prettyPrinter.print(")");
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set2, BindingEnvironment bindingEnvironment) {
        super.accumulateNonLiteralFreeBindings(set2, bindingEnvironment);
        for (int i = 0; i < this.m_bindings.length; ++i) {
            set2.remove(this.m_bindings[i]);
        }
    }

    @Override
    public void accumulateFreeBindings(Set set2, BindingEnvironment bindingEnvironment) {
        super.accumulateFreeBindings(set2, bindingEnvironment);
        for (int i = 0; i < this.m_bindings.length; ++i) {
            set2.remove(this.m_bindings[i]);
        }
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeInstruction(this.m_toMatch);
        writeObjectFileHelper.writeTypeSpecificBindingSet(this.m_bindings);
        writeObjectFileHelper.writeInstruction(this.m_body);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        this.m_toMatch = readObjectFileHelper.readInstruction(bindingEnvironment);
        this.m_bindings = readObjectFileHelper.readTypeSpecificBindingSet();
        this.m_body = readObjectFileHelper.readInstruction(bindingEnvironment);
    }

    @Override
    public boolean isChildInstructionBody(int n2) {
        return n2 == 1;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int n2) {
        if (n2 != 1) {
            return null;
        }
        return this.m_bindings;
    }

    @Override
    public boolean isChildInstructionInTailPosition(int n2) {
        return false;
    }

    @Override
    public Instruction assignNewNames(Map map2, INewNameGenerator iNewNameGenerator) {
        Object[] objectArray = new Object[this.m_bindings.length];
        for (int i = 0; i < this.m_bindings.length; ++i) {
            Object object2 = objectArray[i] = iNewNameGenerator.getNewName();
            map2.put(this.m_bindings[i].getName(), new IdentifierInstruction(object2));
        }
        return new TupleMatchInstruction(this.m_toMatch.assignNewNames(map2, iNewNameGenerator), objectArray, this.m_body.assignNewNames(map2, iNewNameGenerator));
    }

    @Override
    public int getTypeParameterCount() {
        return this.m_bindings.length;
    }

    @Override
    public Type getTypeParameter(int n2) {
        return this.m_bindings[n2].getBindingType();
    }

    @Override
    public void setTypeParameter(int n2, Type type2) {
        this.m_bindings[n2].setType(type2);
    }
}

