/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.ClassType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import java.io.IOException;
import java.util.LinkedList;

public class SuperMethodInvocationInstruction
extends NaryPrimopInstruction {
    protected Type m_classType;
    protected String m_function;

    public SuperMethodInvocationInstruction() {
    }

    public SuperMethodInvocationInstruction(Type type2, String string2, Instruction[] instructionArray) {
        super(instructionArray);
        this.m_classType = type2;
        this.m_function = string2;
    }

    public String getFunction() {
        return this.m_function;
    }

    public void setFunction(String string2) {
        this.m_function = string2;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type type2 = this.m_classType;
        type2 = type2.resolveType(typeEnvironment);
        if (type2 == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Invalid type: " + this.m_classType), this);
        }
        if (!(type2 instanceof NamedType)) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_classType + " is not a class type"), this);
        }
        ClassType classType = (ClassType)((NamedType)type2).resolveName(typeEnvironment);
        ClassType.Method method = classType.resolveMethod(this.m_function, typeEnvironment);
        if (method == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Class " + classType.getName() + " has no method named " + this.m_function), this);
        }
        Binding[] bindingArray = method.m_parameters;
        if (bindingArray.length != this.m_parameters.length) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Method " + this.m_function + " of class " + classType.getName() + " takes " + method.m_parameters.length + " parameters"), this);
        }
        for (int i = 0; i < bindingArray.length; ++i) {
            typeEnvironment.unify(bindingArray[i].getBindingType(), this.m_parameters[i].typeCheck(typeEnvironment, bindingEnvironment, linkedList), this);
        }
        return this.setCachedType(method.getReturnType());
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type type2 = this.m_classType;
        type2 = type2.resolveType(typeEnvironment);
        ClassType classType = (ClassType)((NamedType)type2).resolveName(typeEnvironment);
        ClassType.Method method = classType.resolveMethod(this.m_function, typeEnvironment);
        return typeEnvironment.getModule().getFunction(method.getFunction()).getReturnType();
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] instructionArray = new Instruction[this.m_parameters.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        SuperMethodInvocationInstruction superMethodInvocationInstruction = new SuperMethodInvocationInstruction(this.m_classType, this.m_function, instructionArray);
        SuperMethodInvocationInstruction.propagateInfo(this, superMethodInvocationInstruction);
        return superMethodInvocationInstruction;
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] instructionArray = (Instruction[])this.m_parameters.clone();
        SuperMethodInvocationInstruction superMethodInvocationInstruction = new SuperMethodInvocationInstruction(this.m_classType, this.m_function, instructionArray);
        SuperMethodInvocationInstruction.propagateInfo(this, superMethodInvocationInstruction);
        return superMethodInvocationInstruction;
    }

    @Override
    public String innerToString() {
        return "super-method-invoke";
    }

    @Override
    public boolean equals(Object object2) {
        if (!super.equals(object2)) {
            return false;
        }
        SuperMethodInvocationInstruction superMethodInvocationInstruction = (SuperMethodInvocationInstruction)object2;
        return superMethodInvocationInstruction.m_function.equals(this.m_function);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.m_function.hashCode();
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_classType = readObjectFileHelper.readType();
        this.m_function = readObjectFileHelper.readString();
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeType(this.m_classType);
        writeObjectFileHelper.writeString(this.m_function);
    }

    @Override
    public int getTypeParameterCount() {
        return 1;
    }

    @Override
    public Type getTypeParameter(int n2) {
        return n2 == 0 ? this.m_classType : null;
    }

    @Override
    public void setTypeParameter(int n2, Type type2) {
        if (n2 == 0) {
            this.m_classType = type2;
        }
    }
}

