/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgUnaryOp;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.GenFork;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.ListStream;
import com.ibm.xltxe.rnm1.xylem.types.IConstructableAsStreamType;
import com.ibm.xltxe.rnm1.xylem.types.IForkReleaseManaged;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class SubstreamInstruction
extends Instruction
implements IStreamOptimizationInstruction {
    protected Instruction m_source;
    protected Instruction m_start;
    protected Instruction m_length;
    protected boolean m_zeroBased;

    public SubstreamInstruction() {
    }

    public SubstreamInstruction(Instruction instruction2, Instruction instruction3, Instruction instruction4, boolean bl) {
        this.m_source = instruction2;
        this.m_start = instruction3;
        this.m_length = instruction4;
        this.m_zeroBased = bl;
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_length == null ? 2 : 3;
    }

    @Override
    public Instruction getChildInstruction(int n2) {
        if (this.m_length != null) {
            if (n2 == 0) {
                return this.m_length;
            }
            --n2;
        }
        switch (n2) {
            case 0: {
                return this.m_source;
            }
            case 1: {
                return this.m_start;
            }
        }
        return null;
    }

    @Override
    public void setChildInstruction(int n2, Instruction instruction2) {
        if (this.m_length != null) {
            if (n2 == 0) {
                this.m_length = instruction2;
                return;
            }
            --n2;
        }
        switch (n2) {
            case 0: {
                this.m_source = instruction2;
                break;
            }
            case 1: {
                this.m_start = instruction2;
            }
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        SubstreamInstruction substreamInstruction = new SubstreamInstruction(this.m_source.cloneWithoutTypeInformation(), this.m_start.cloneWithoutTypeInformation(), this.m_length == null ? null : this.m_length.cloneWithoutTypeInformation(), this.m_zeroBased);
        SubstreamInstruction.propagateInfo(this, substreamInstruction);
        return substreamInstruction;
    }

    @Override
    public Instruction cloneShallow() {
        SubstreamInstruction substreamInstruction = new SubstreamInstruction(this.m_source, this.m_start, this.m_length == null ? null : this.m_length, this.m_zeroBased);
        SubstreamInstruction.propagateInfo(this, substreamInstruction);
        return substreamInstruction;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        if (this.m_length != null) {
            typeEnvironment.unify(this.m_length.typeCheck(typeEnvironment, bindingEnvironment, linkedList), IntType.s_intType, this);
        }
        TypeVariable typeVariable = new TypeVariable();
        Type type2 = this.setCachedType(this.m_source.typeCheck(typeEnvironment, bindingEnvironment, linkedList));
        typeEnvironment.unify(type2, typeVariable.getStreamType(), this);
        typeEnvironment.unify(this.m_start.typeCheck(typeEnvironment, bindingEnvironment, linkedList), IntType.s_intType, this);
        return type2;
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_source.getType(typeEnvironment, bindingEnvironment);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, String string2, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        Object object2;
        FcgVariable fcgVariable;
        StreamType streamType = (StreamType)codeGenerationTracker.resolveType(this.m_source);
        FcgType fcgType = codeGenerationTracker.generateConventionally(this.m_source, fcgCodeGenHelper, fcgInstructionList);
        FcgVariable fcgVariable2 = fcgInstructionList.defineConstVar(fcgType, fcgCodeGenHelper.generateNewLocalVariableName());
        FcgType fcgType2 = codeGenerationTracker.generateConventionally(this.m_start, fcgCodeGenHelper, fcgInstructionList);
        if (!this.m_zeroBased) {
            fcgInstructionList.loadLiteral(1);
            fcgInstructionList.binaryOperationExpr(FcgBinOp.SUBTRACT);
        }
        FcgVariable fcgVariable3 = fcgInstructionList.defineVar(fcgType2, fcgCodeGenHelper.generateNewLocalVariableName(), true);
        String string3 = fcgCodeGenHelper.generateNewLocalVariableName();
        if (this.m_length == null) {
            fcgInstructionList.loadVar(fcgVariable2);
            fcgInstructionList.unaryOperationExpr(FcgUnaryOp.LENGTH);
            fcgInstructionList.loadVar(fcgVariable3);
            fcgInstructionList.binaryOperationExpr(FcgBinOp.SUBTRACT);
            fcgVariable = fcgInstructionList.defineVar(FcgType.INT, string3, true);
        } else {
            object2 = codeGenerationTracker.generateConventionally(this.m_length, fcgCodeGenHelper, fcgInstructionList);
            fcgVariable = fcgInstructionList.defineVar((FcgType)object2, string3, true);
        }
        object2 = streamType.generateCopyStream(fcgVariable2, fcgVariable3, fcgVariable, null, null, fcgCodeGenHelper, fcgInstructionList, codeGenerationTracker);
        return fcgInstructionList.loadVar((FcgVariable)object2);
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        this.m_source = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_source, bindingEnvironment);
        this.m_start = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_start, bindingEnvironment);
        if (this.m_length != null) {
            this.m_length = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_length, bindingEnvironment);
        }
        instructionArray[0] = this;
        this.m_bindingEnvironment = null;
    }

    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function2);
        }
        IForkReleaseManaged iForkReleaseManaged = null;
        IStream iStream = (IStream)this.m_source.evaluate(environment, function2, iDebuggerInterceptor, false);
        int n2 = (Integer)this.m_start.evaluate(environment, function2, iDebuggerInterceptor, false);
        int n3 = (Integer)this.m_length.evaluate(environment, function2, iDebuggerInterceptor, false);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator<Object> iterator = iStream.iterator();
        int n4 = 0;
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            if (n4 < n2 - (this.m_zeroBased ? 0 : 1)) {
                ++n4;
                continue;
            }
            if (n4 < n2 + n3) {
                arrayList.add(object2);
            }
            ++n4;
        }
        iForkReleaseManaged = environment.pushIForkReleaseManagedForRelease(new ListStream(arrayList));
        return Debugger.leave(iDebuggerInterceptor, this, environment, function2, (Object)iForkReleaseManaged);
    }

    @Override
    public String innerToString() {
        return this.m_zeroBased ? "substream" : "substream-1";
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle codeGenerationOptimizationStyle, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        if (codeGenerationOptimizationStyle instanceof StreamOptimizationStyle) {
            return true;
        }
        return super.supportsCodeGenerationOptimizationInternal(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
    }

    @Override
    public void generateCodeWithStreamOptimization(FcgCodeGenHelper fcgCodeGenHelper, FcgInstructionList fcgInstructionList, String string2, IConstructableAsStreamType iConstructableAsStreamType, CodeGenerationTracker codeGenerationTracker, boolean bl) {
        codeGenerationTracker.generateConventionally(this.m_source, fcgCodeGenHelper, fcgInstructionList);
        codeGenerationTracker.generateConventionally(this.m_start, fcgCodeGenHelper, fcgInstructionList);
        if (!this.m_zeroBased) {
            fcgInstructionList.loadLiteral(1);
            fcgInstructionList.binaryOperationExpr(FcgBinOp.SUBTRACT);
        }
        if (this.m_length != null) {
            codeGenerationTracker.generateConventionally(this.m_length, fcgCodeGenHelper, fcgInstructionList);
        } else {
            FcgVariable fcgVariable = fcgInstructionList.defineVar(FcgType.INT, string2 + "_tempStart", true);
            FcgVariable fcgVariable2 = fcgInstructionList.defineVar(iConstructableAsStreamType.getFCGType(fcgCodeGenHelper), string2 + "_temp", true);
            fcgInstructionList.loadVar(fcgVariable2);
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.loadVar(fcgVariable2);
            fcgInstructionList.unaryOperationExpr(FcgUnaryOp.LENGTH);
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.binaryOperationExpr(FcgBinOp.SUBTRACT);
        }
        iConstructableAsStreamType.generateAddMultipleElementsToStream(fcgCodeGenHelper, codeGenerationTracker, fcgInstructionList, string2, iConstructableAsStreamType.getElementType(), false);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        this.m_source = readObjectFileHelper.readInstruction(bindingEnvironment);
        this.m_start = readObjectFileHelper.readInstruction(bindingEnvironment);
        if (readObjectFileHelper.readBoolean()) {
            this.m_length = readObjectFileHelper.readInstruction(bindingEnvironment);
        }
        this.m_zeroBased = readObjectFileHelper.readBoolean();
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeInstruction(this.m_source);
        writeObjectFileHelper.writeInstruction(this.m_start);
        writeObjectFileHelper.writeBoolean(this.m_length != null);
        if (this.m_length != null) {
            writeObjectFileHelper.writeInstruction(this.m_length);
        }
        writeObjectFileHelper.writeBoolean(this.m_zeroBased);
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n2) {
        prettyPrinter.printFormOpen(this.innerToString(), n2);
        this.m_source.toString(prettyPrinter, n2 + 1);
        this.m_start.toString(prettyPrinter, n2 + 1);
        if (this.m_length != null) {
            this.m_length.toString(prettyPrinter, n2 + 1);
        }
        prettyPrinter.printFormClose(n2);
    }
}

