/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.IMatchDestructable;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.GenFork;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.DeepEqualityInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.CharArrayWriterStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IAppendableStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.ListStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.StringStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.TagStream;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.IConstructableAsStreamType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.types.TagType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class StreamInstruction
extends Instruction
implements IStreamOptimizationInstruction,
IMatchDestructable {
    protected Type m_elementType;
    protected Instruction[] m_elements;
    protected String m_string;
    public static final int s_runs = 2;
    private StreamType s_charStreamType = CharType.s_charType.getStreamType();

    public StreamInstruction() {
    }

    public StreamInstruction(Type type2, Instruction[] instructionArray) {
        if (type2 instanceof StreamType) {
            throw new XylemError("ERR_SYSTEM", "can't stream a stream type");
        }
        this.m_elementType = type2;
        this.setElements(instructionArray);
        this.getStringContent();
    }

    public StreamInstruction(Type type2, List list) {
        if (type2 instanceof StreamType) {
            throw new XylemError("ERR_SYSTEM", "can't stream a stream type");
        }
        this.m_elementType = type2;
        this.setElements(new Instruction[list.size()]);
        list.toArray(this.m_elements);
        this.getStringContent();
    }

    public StreamInstruction(Type type2, Instruction instruction2) {
        this(type2, new Instruction[]{instruction2});
    }

    public StreamInstruction(Type type2) {
        this(type2, new Instruction[0]);
    }

    public StreamInstruction(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        this.m_string = string2;
        this.m_elementType = CharType.s_charType;
    }

    public Instruction[] getElements() {
        return this.m_elements;
    }

    public Type getElementType() {
        return this.m_elementType;
    }

    public boolean isStoredAsString() {
        return this.m_elements == null;
    }

    public boolean isString() {
        this.getStringContent();
        return this.m_elements == null;
    }

    public void setElementType(Type type2) {
        this.m_elementType = type2;
    }

    @Override
    public void accumulateFunctionsCalled(Set set2) {
        if (this.m_string != null) {
            return;
        }
        super.accumulateFunctionsCalled(set2);
    }

    @Override
    public void accumulateFreeBindings(Set set2, BindingEnvironment bindingEnvironment) {
        if (this.m_string != null) {
            return;
        }
        super.accumulateFreeBindings(set2, bindingEnvironment);
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set2, BindingEnvironment bindingEnvironment) {
        if (this.m_string != null) {
            return;
        }
        super.accumulateNonLiteralFreeBindings(set2, bindingEnvironment);
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        if (this.m_elements != null) {
            Type type2 = this.m_elementType.resolveTypeAsMuchAsPossible(typeEnvironment, new HashSet());
            boolean bl = type2 instanceof TypeVariable;
            for (int i = 0; i < this.m_elements.length; ++i) {
                Type type3;
                Type type4 = this.m_elements[i].typeCheck(typeEnvironment, bindingEnvironment, linkedList);
                if (!bl || (type3 = type4.resolveTypeAsMuchAsPossible(typeEnvironment, new HashSet())) instanceof TypeVariable) continue;
                if (type3 instanceof StreamType) {
                    typeEnvironment.unify(type2, ((StreamType)type3).getElementType(), this);
                    continue;
                }
                typeEnvironment.unify(type2, type3, this);
            }
        }
        return this.setCachedType(this.m_elementType.getStreamType());
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_elementType.getStreamType();
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature moduleSignature) {
        return null != this.m_elementType ? this.m_elementType.getStreamType() : super.getPreTypecheckType(moduleSignature);
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_elements == null ? this.m_string.length() : this.m_elements.length;
    }

    @Override
    public Instruction getChildInstruction(int n2) {
        if (this.m_elements == null) {
            LiteralInstruction literalInstruction = LiteralInstruction.charLiteral(this.m_string.charAt(n2));
            return literalInstruction;
        }
        return this.m_elements[n2];
    }

    @Override
    public void setChildInstruction(int n2, Instruction instruction2) {
        if (this.m_elements == null) {
            this.convertStringToArray();
        }
        this.m_elements[n2] = instruction2;
    }

    @Override
    public int getTypeParameterCount() {
        return 1;
    }

    @Override
    public Type getTypeParameter(int n2) {
        return n2 == 0 ? this.m_elementType : null;
    }

    @Override
    public void setTypeParameter(int n2, Type type2) {
        if (n2 == 0) {
            this.m_elementType = type2;
        }
    }

    protected void convertStringToArray() {
        if (this.m_elements == null) {
            this.m_elements = new Instruction[this.m_string.length()];
            for (int i = 0; i < this.m_string.length(); ++i) {
                LiteralInstruction literalInstruction = LiteralInstruction.charLiteral(this.m_string.charAt(i));
                try {
                    literalInstruction.typeCheck(null, this.m_bindingEnvironment, new LinkedList());
                }
                catch (TypeCheckException typeCheckException) {
                    typeCheckException.printStackTrace();
                }
                this.m_elements[i] = literalInstruction;
            }
            this.m_string = null;
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        if (this.m_string != null) {
            return new StreamInstruction(this.m_string);
        }
        Instruction[] instructionArray = new Instruction[this.m_elements.length];
        for (int i = 0; i < this.m_elements.length; ++i) {
            instructionArray[i] = this.m_elements[i].cloneWithoutTypeInformation();
        }
        StreamInstruction streamInstruction = new StreamInstruction(this.m_elementType, instructionArray);
        StreamInstruction.propagateInfo(this, streamInstruction);
        return streamInstruction;
    }

    @Override
    public Instruction cloneShallow() {
        if (this.m_string != null) {
            StreamInstruction streamInstruction = new StreamInstruction(this.m_string);
            StreamInstruction.propagateInfo(this, streamInstruction);
            return streamInstruction;
        }
        Instruction[] instructionArray = (Instruction[])this.m_elements.clone();
        StreamInstruction streamInstruction = new StreamInstruction(this.m_elementType, instructionArray);
        StreamInstruction.propagateInfo(this, streamInstruction);
        return streamInstruction;
    }

    public String generateEscapedStringValue() {
        return LiteralInstruction.escape(this.getStringContent());
    }

    protected FcgType makeConstant(FcgCodeGenHelper fcgCodeGenHelper, FcgInstructionList fcgInstructionList, CodeGenerationTracker codeGenerationTracker, String string2) {
        FcgType fcgType;
        Type type2 = this.m_elementType.resolveType(codeGenerationTracker.m_typeEnvironment);
        Instruction[] instructionArray = this.m_elements;
        int n2 = instructionArray.length;
        boolean bl = true;
        for (int i = 0; i < n2; ++i) {
            if (instructionArray[0 + i] instanceof LiteralInstruction) continue;
            bl = false;
            break;
        }
        if (bl && type2.equals(CharType.s_charType)) {
            FcgInstructionList fcgInstructionList2 = fcgCodeGenHelper.startConstantGeneration();
            FcgClassReferenceType fcgClassReferenceType = (FcgClassReferenceType)fcgInstructionList2.loadLiteral(this.getStringContent());
            fcgInstructionList2.invokeInstanceMethod(fcgClassReferenceType, "toCharArray", (FcgType)FcgType.CHAR_ARRAY, 0);
            fcgCodeGenHelper.finishConstantGeneration(string2, FcgType.CHAR_ARRAY, fcgInstructionList);
            fcgType = FcgType.CHAR_ARRAY;
        } else {
            FcgType fcgType2 = type2.getFCGType(fcgCodeGenHelper);
            FcgInstructionList fcgInstructionList3 = fcgCodeGenHelper.startConstantGeneration();
            for (int i = 0; i < n2; ++i) {
                instructionArray[0 + i].generateCode(fcgCodeGenHelper, codeGenerationTracker, string2 + "_" + i, false, fcgInstructionList3, GenFork.ONLY);
            }
            fcgInstructionList3.loadLiteral(n2);
            fcgType = fcgInstructionList3.createArrayExpr(fcgType2, true);
            fcgCodeGenHelper.finishConstantGeneration(string2, fcgType, fcgInstructionList);
        }
        return fcgType;
    }

    public static StreamInstruction charStreamLiteral(String string2) {
        return new StreamInstruction(string2);
    }

    @Override
    public boolean isStatic(BindingEnvironment bindingEnvironment) {
        if (this.m_elements == null) {
            return true;
        }
        for (int i = 0; i < this.m_elements.length; ++i) {
            if (this.m_elements[i] instanceof LiteralInstruction) continue;
            return false;
        }
        return true;
    }

    public static final FcgType insertCharStreamConstant(String string2, FcgCodeGenHelper fcgCodeGenHelper, FcgInstructionList fcgInstructionList) {
        String string3 = "char[]/" + string2;
        if (!fcgCodeGenHelper.insertConstant(string3, FcgType.CHAR_ARRAY, fcgInstructionList)) {
            FcgInstructionList fcgInstructionList2 = fcgCodeGenHelper.startConstantGeneration();
            fcgInstructionList2.loadLiteral(string2);
            fcgInstructionList2.convertExpr(FcgType.STRING, FcgType.CHAR_ARRAY);
            fcgCodeGenHelper.finishConstantGeneration(string3, FcgType.CHAR_ARRAY, fcgInstructionList);
        }
        return FcgType.CHAR_ARRAY;
    }

    public static final void insertStreamConstant(Instruction[] instructionArray, Type type2, FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, FcgInstructionList fcgInstructionList) {
        StreamInstruction.insertStreamConstant(instructionArray, type2, fcgCodeGenHelper, codeGenerationTracker, fcgInstructionList, 0, instructionArray.length);
    }

    public static final void insertStreamConstant(Instruction[] instructionArray, Type type2, FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, FcgInstructionList fcgInstructionList, int n2, int n3) {
        if (type2.equals(CharType.s_charType)) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n3; ++i) {
                stringBuffer.append(((Character)((LiteralInstruction)instructionArray[n2 + i]).getValue()).charValue());
            }
            StreamInstruction.insertCharStreamConstant(stringBuffer.toString(), fcgCodeGenHelper, fcgInstructionList);
        } else {
            FcgType fcgType;
            FcgType fcgType2;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(type2.prettyPrint());
            for (int i = 0; i < n3; ++i) {
                stringBuffer.append("\n");
                stringBuffer.append(instructionArray[n2 + i].toString());
            }
            String string2 = stringBuffer.toString();
            if (!fcgCodeGenHelper.insertConstant(string2, fcgType2 = fcgCodeGenHelper.getArrayType(fcgType = type2.getFCGType(fcgCodeGenHelper)), fcgInstructionList)) {
                FcgInstructionList fcgInstructionList2 = fcgCodeGenHelper.startConstantGeneration();
                for (int i = 0; i < n3; ++i) {
                    Instruction instruction2 = instructionArray[n2 + i];
                    codeGenerationTracker.generateConventionally(instruction2, fcgCodeGenHelper, fcgInstructionList2);
                }
                fcgInstructionList2.loadLiteral(n3);
                fcgInstructionList2.createArrayExpr(fcgType, true);
                fcgCodeGenHelper.finishConstantGeneration(string2, fcgType2, fcgInstructionList);
            }
        }
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, String string2, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        if (this.isString()) {
            FcgType fcgType = StreamInstruction.insertCharStreamConstant(this.m_string, fcgCodeGenHelper, fcgInstructionList);
            return fcgType;
        }
        this.convertStringToArray();
        Type type2 = this.m_elementType.resolveType(codeGenerationTracker.m_typeEnvironment);
        StreamType streamType = (StreamType)codeGenerationTracker.resolveType(this);
        int[] nArray = new int[this.m_elements.length];
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.m_elements.length; ++i) {
            if (!(this.m_elements[i] instanceof LiteralInstruction)) {
                bl2 = true;
                n2 = i + 1;
            } else {
                int n4 = n2;
                nArray[n4] = nArray[n4] + 1;
            }
            if (!type2.equals(codeGenerationTracker.resolveType(this.m_elements[i]))) continue;
            ++n3;
        }
        if (!bl2) {
            FcgType fcgType = this.makeConstant(fcgCodeGenHelper, fcgInstructionList, codeGenerationTracker, string2 + "_const");
            return fcgType;
        }
        FcgType fcgType = type2.getFCGType(fcgCodeGenHelper);
        FcgType fcgType2 = streamType.getFCGType(fcgCodeGenHelper);
        String string3 = fcgCodeGenHelper.generateNewLocalVariableName(string2);
        FcgVariable fcgVariable = null;
        if (n3 == this.m_elements.length && n3 < 5) {
            for (int i = 0; i < this.m_elements.length; ++i) {
                codeGenerationTracker.generateConventionally(this.m_elements[i], fcgCodeGenHelper, fcgInstructionList);
                if (!this.m_elementType.isForkReleaseManaged(codeGenerationTracker)) continue;
                this.m_elementType.generateObjectFork(fcgCodeGenHelper, fcgInstructionList, codeGenerationTracker, GenFork.ONLY);
            }
            fcgInstructionList.loadLiteral(this.m_elements.length);
            fcgInstructionList.createArrayExpr(fcgType, true);
            fcgVariable = fcgInstructionList.defineVar(fcgType2, string3, true);
        } else {
            fcgVariable = fcgInstructionList.defineVar(fcgType2, string3, false);
            streamType.generateCreateStream(string3, n3 == this.m_elements.length ? n3 : this.m_elements.length * 32, fcgCodeGenHelper, fcgInstructionList);
            for (int i = 0; i < this.m_elements.length; ++i) {
                Instruction instruction2 = this.m_elements[i];
                Type type3 = instruction2.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment).resolveType(codeGenerationTracker.m_typeEnvironment);
                if (!type3.equals(type2)) {
                    if (type3 instanceof StreamType && ((StreamType)type3).getElementType().equals(type2)) {
                        codeGenerationTracker.generateAddToStream(this.m_elements[i], string3, streamType, fcgCodeGenHelper, fcgInstructionList, false);
                        continue;
                    }
                    throw new XylemError("ERR_SYSTEM", "type error StreamType=" + type3 + " eltType=" + type2 + " at " + this);
                }
                if (nArray[i] > 2) {
                    StreamInstruction.insertStreamConstant(this.m_elements, type2, fcgCodeGenHelper, codeGenerationTracker, fcgInstructionList, i, nArray[i]);
                    streamType.generateAddMultipleElementsToStream(fcgCodeGenHelper, codeGenerationTracker, fcgInstructionList, string3, type2);
                    i += nArray[i] - 1;
                    continue;
                }
                FcgType fcgType3 = codeGenerationTracker.generateConventionally(this.m_elements[i], fcgCodeGenHelper, fcgInstructionList);
                Type type4 = this.getType(codeGenerationTracker.m_typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
                streamType.generateAddElementToStream(fcgCodeGenHelper, fcgInstructionList, string3, type4, fcgType3, codeGenerationTracker);
            }
            streamType.generateCompactStream(string3, fcgCodeGenHelper, fcgInstructionList);
        }
        fcgInstructionList.loadVar(fcgVariable);
        return fcgType2;
    }

    @Override
    public void generateCodeWithStreamOptimization(FcgCodeGenHelper fcgCodeGenHelper, FcgInstructionList fcgInstructionList, String string2, IConstructableAsStreamType iConstructableAsStreamType, CodeGenerationTracker codeGenerationTracker, boolean bl) {
        int n2;
        if (this.isString()) {
            int n3 = this.m_string.length();
            if (0 < n3) {
                StreamInstruction.insertCharStreamConstant(this.m_string, fcgCodeGenHelper, fcgInstructionList);
                iConstructableAsStreamType.generateAddMultipleElementsToStream(fcgCodeGenHelper, codeGenerationTracker, fcgInstructionList, string2, iConstructableAsStreamType.getElementType());
            }
            return;
        }
        this.convertStringToArray();
        Type type2 = this.m_elementType.resolveType(codeGenerationTracker.m_typeEnvironment);
        int[] nArray = new int[this.m_elements.length];
        int n4 = 0;
        for (n2 = 0; n2 < this.m_elements.length; ++n2) {
            if (!(this.m_elements[n2] instanceof LiteralInstruction)) {
                n4 = n2 + 1;
                continue;
            }
            int n5 = n4;
            nArray[n5] = nArray[n5] + 1;
        }
        for (n2 = 0; n2 < this.m_elements.length; ++n2) {
            Instruction instruction2 = this.m_elements[n2];
            Type type3 = codeGenerationTracker.resolveType(instruction2);
            if (!type3.equals(type2)) {
                if (type3 instanceof StreamType && ((StreamType)type3).getElementType().equals(type2)) {
                    codeGenerationTracker.generateAddToStream(instruction2, string2, iConstructableAsStreamType, fcgCodeGenHelper, fcgInstructionList, bl && n2 == this.m_elements.length - 1);
                    continue;
                }
                throw new RuntimeException("codegen type error at " + instruction2 + " in " + this);
            }
            if (nArray[n2] > 2) {
                if (nArray[n2] > 0) {
                    StreamInstruction.insertStreamConstant(this.m_elements, type2, fcgCodeGenHelper, codeGenerationTracker, fcgInstructionList, n2, nArray[n2]);
                    iConstructableAsStreamType.generateAddMultipleElementsToStream(fcgCodeGenHelper, codeGenerationTracker, fcgInstructionList, string2, type2);
                }
                n2 += nArray[n2] - 1;
                continue;
            }
            FcgType fcgType = codeGenerationTracker.generateConventionally(instruction2, fcgCodeGenHelper, fcgInstructionList);
            Type type4 = this.getType(codeGenerationTracker.m_typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
            iConstructableAsStreamType.generateAddElementToStream(fcgCodeGenHelper, fcgInstructionList, string2, type4, fcgType, codeGenerationTracker);
        }
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        if (this.m_elements != null) {
            int n2 = this.m_elements.length;
            Instruction[] instructionArray2 = this.m_elements;
            for (int i = 0; i < n2; ++i) {
                Instruction instruction2 = this.m_elements[i];
                instructionArray2[i] = reductionHelper.reduceToBasicInstruction(instructionArray, instruction2, bindingEnvironment);
            }
            this.m_elements = instructionArray2;
        }
        instructionArray[0] = this;
        this.m_bindingEnvironment = null;
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle codeGenerationOptimizationStyle, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        if (codeGenerationOptimizationStyle instanceof StreamOptimizationStyle) {
            return true;
        }
        return super.supportsCodeGenerationOptimizationInternal(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n2) {
        if (this.isString()) {
            prettyPrinter.printToken("\"" + LiteralInstruction.escape(this.m_string) + "\"", n2);
            return;
        }
        prettyPrinter.newline();
        prettyPrinter.printFormOpen("stream", n2);
        prettyPrinter.printToken(this.getElementType().prettyPrint(), n2 + 1);
        for (int i = 0; i < this.m_elements.length; ++i) {
            this.m_elements[i].toString(prettyPrinter, n2 + 1);
        }
        prettyPrinter.print(")");
    }

    public String getStringContent() {
        if (this.m_string != null) {
            return this.m_string;
        }
        if (this.isStatic(null) && this.getElementType().equals(CharType.s_charType)) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.m_elements.length; ++i) {
                if (!(this.m_elements[i] instanceof LiteralInstruction) || !(((LiteralInstruction)this.m_elements[i]).getValue() instanceof Character)) {
                    return null;
                }
                stringBuffer.append(((Character)((LiteralInstruction)this.m_elements[i]).getValue()).charValue());
            }
            this.m_string = stringBuffer.toString();
            this.m_elements = null;
            return this.m_string;
        }
        return null;
    }

    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        IAppendableStream iAppendableStream;
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function2);
        }
        IStream iStream = null;
        if (this.m_elements == null) {
            iStream = new StringStream(this.m_string);
            return Debugger.leave(iDebuggerInterceptor, this, environment, function2, (Object)iStream);
        }
        if (this.m_elementType.equals(CharType.s_charType)) {
            iAppendableStream = new CharArrayWriterStream();
        } else if (this.m_elementType instanceof TagType) {
            iAppendableStream = new TagStream();
        } else {
            ListStream listStream = new ListStream();
            environment.pushIForkReleaseManagedForRelease(listStream);
            iAppendableStream = listStream;
        }
        for (int i = 0; i < this.m_elements.length; ++i) {
            this.m_elements[i].evaluate(iAppendableStream, environment, function2, iDebuggerInterceptor);
        }
        iStream = iAppendableStream;
        return Debugger.leave(iDebuggerInterceptor, this, environment, function2, (Object)iStream);
    }

    @Override
    public void evaluate(IAppendableStream iAppendableStream, Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function2);
        }
        if (this.m_elements == null) {
            iAppendableStream.append(new StringStream(this.m_string), CharType.s_charStreamType);
            Debugger.leave(iDebuggerInterceptor, this, environment, function2, null);
            return;
        }
        if (this.m_elementType.equals(CharType.s_charType)) {
            for (int i = 0; i < this.m_elements.length; ++i) {
                this.m_elements[i].evaluate(iAppendableStream, environment, function2, iDebuggerInterceptor);
            }
        } else {
            for (int i = 0; i < this.m_elements.length; ++i) {
                this.m_elements[i].evaluate(iAppendableStream, environment, function2, iDebuggerInterceptor);
            }
        }
        Debugger.leave(iDebuggerInterceptor, this, environment, function2, null);
    }

    @Override
    public boolean equals(Object object2) {
        if (object2 == null || !(object2 instanceof StreamInstruction)) {
            return false;
        }
        StreamInstruction streamInstruction = (StreamInstruction)object2;
        if (streamInstruction.m_string != null && this.m_string != null) {
            return this.m_string.equals(streamInstruction.m_string);
        }
        if (streamInstruction.m_elements != null && this.m_elements != null) {
            int n2;
            if (streamInstruction.m_elements.length != this.m_elements.length) {
                return false;
            }
            if (this.m_elementType != null && streamInstruction.m_elementType != null && this.m_elementType != streamInstruction.m_elementType) {
                return false;
            }
            for (n2 = 0; n2 < this.m_elements.length; ++n2) {
                if (this.m_elements[n2].hashCode() == streamInstruction.m_elements[n2].hashCode()) continue;
                return false;
            }
            for (n2 = 0; n2 < this.m_elements.length; ++n2) {
                if (this.m_elements[n2].equals(streamInstruction.m_elements[n2])) continue;
                return false;
            }
            return true;
        }
        if (!super.equals(object2)) {
            return false;
        }
        return this.m_elementType.equals(streamInstruction.m_elementType);
    }

    @Override
    public void determineDataDependencies(Binding[] bindingArray, HashMap hashMap, Instruction instruction2, int n2, BindingEnvironment bindingEnvironment) {
        if (this.m_string != null) {
            return;
        }
        super.determineDataDependencies(bindingArray, hashMap, instruction2, n2, bindingEnvironment);
    }

    @Override
    public void determineDataDependencies(Set set2) {
        if (this.m_string != null) {
            return;
        }
        super.determineDataDependencies(set2);
    }

    public void setElements(Instruction[] instructionArray) {
        this.m_elements = instructionArray;
        this.m_string = null;
    }

    @Override
    public void replaceTypeVariables(Map map2) {
        super.replaceTypeVariables(map2);
        this.m_elementType = this.m_elementType.replaceType(map2);
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
    }

    @Override
    public Instruction replaceBindings(Map map2) {
        if (this.m_string != null) {
            return this;
        }
        return super.replaceBindings(map2);
    }

    @Override
    public Instruction assignNewNames(Map map2, INewNameGenerator iNewNameGenerator) {
        if (this.m_string != null) {
            return new StreamInstruction(this.m_string);
        }
        return super.assignNewNames(map2, iNewNameGenerator);
    }

    @Override
    public Instruction cloneReduced() {
        if (this.m_string != null) {
            return new StreamInstruction(this.m_string);
        }
        return super.cloneReduced();
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        if (readObjectFileHelper.readByte() == 1) {
            this.m_string = readObjectFileHelper.readString();
            this.m_elementType = CharType.s_charType;
        } else {
            this.m_elementType = readObjectFileHelper.readType();
            this.m_elements = new Instruction[readObjectFileHelper.readInt()];
            for (int i = 0; i < this.m_elements.length; ++i) {
                this.m_elements[i] = readObjectFileHelper.readInstruction(bindingEnvironment);
            }
        }
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        if (this.m_string != null) {
            writeObjectFileHelper.writeByte(1);
            writeObjectFileHelper.writeString(this.m_string);
        } else {
            writeObjectFileHelper.writeByte(0);
            writeObjectFileHelper.writeType(this.m_elementType);
            super.write(writeObjectFileHelper);
        }
    }

    @Override
    public int byteCodeSize() {
        if (this.m_string != null) {
            return 4;
        }
        return 2 + 2 * this.getChildInstructionCount();
    }

    @Override
    public int accumulateByteCodeSize() {
        if (this.m_string == null) {
            return super.accumulateByteCodeSize();
        }
        return 4;
    }

    @Override
    public void clearTypeInformation() {
        if (this.m_string == null) {
            super.clearTypeInformation();
        } else {
            this.m_hasBeenTypechecked = false;
            this.m_bindingEnvironment = null;
        }
    }

    @Override
    public void standardizeTypes(Set set2, TypeEnvironment typeEnvironment) {
        if (this.m_string != null) {
            this.m_elementType = this.m_elementType.resolveTypeAsMuchAsPossible(typeEnvironment, set2);
            Type type2 = this.getCachedType();
            if (type2 != null) {
                this.setCachedType(type2.resolveTypeAsMuchAsPossible(typeEnvironment, set2));
            }
        } else {
            super.standardizeTypes(set2, typeEnvironment);
        }
    }

    @Override
    public Instruction removeAliases(HashMap hashMap) {
        if (this.m_string != null) {
            return this;
        }
        return super.removeAliases(hashMap);
    }

    public void split(int n2) {
        if (this.m_string != null) {
            throw new XylemError("ERR_SYSTEM", "can't split String stream!");
        }
        if (n2 <= 0) {
            throw new XylemError("ERR_SYSTEM", "can't split with zero grain!");
        }
        LinkedList<StreamInstruction> linkedList = new LinkedList<StreamInstruction>();
        LinkedList<Instruction> linkedList2 = new LinkedList<Instruction>();
        for (int i = 0; i < this.m_elements.length; ++i) {
            if (i > 0 && i % n2 == 0) {
                StreamInstruction streamInstruction = new StreamInstruction(this.getElementType(), linkedList2);
                linkedList.add(streamInstruction);
                linkedList2 = new LinkedList();
            }
            linkedList2.add(this.m_elements[i].cloneWithoutTypeInformation());
        }
        if (linkedList2.size() > 0) {
            StreamInstruction streamInstruction = new StreamInstruction(this.getElementType(), linkedList2);
            linkedList.add(streamInstruction);
        }
        Object[] objectArray = linkedList.toArray();
        this.m_elements = new Instruction[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            this.m_elements[i] = (Instruction)objectArray[i];
        }
    }

    public void split() {
        if (this.m_elements == null) {
            throw new XylemError("ERR_SYSTEM", "StreamInstruction.m_elements: NULL");
        }
        this.split(this.m_elements.length / 2);
    }

    @Override
    protected int doesDescendentCountExceedThresholdHelper(int n2) {
        if (this.isStoredAsString()) {
            return n2;
        }
        return super.doesDescendentCountExceedThresholdHelper(n2);
    }

    @Override
    public Type typeCheckDestruction(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) throws TypeCheckException {
        if (!this.isString()) {
            for (int i = 0; i < this.m_elements.length; ++i) {
                Instruction instruction2 = this.m_elements[i];
                if (!(instruction2 instanceof IMatchDestructable)) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", instruction2 + " not supported in match2 pattern"), this);
                }
                ((IMatchDestructable)((Object)instruction2)).typeCheckDestruction(typeEnvironment, bindingEnvironment);
            }
        }
        return this.m_elementType.getStreamType();
    }

    @Override
    public Instruction desugarDestruction(Instruction instruction2, ReductionHelper reductionHelper, IMatchDestructable.Generator generator, IMatchDestructable.Generator generator2, BindingEnvironment bindingEnvironment) {
        if (this.isString()) {
            Object object2 = reductionHelper.generateReducedIdentifier("");
            Object object3 = reductionHelper.generateReducedIdentifier("");
            LetInstruction letInstruction = new LetInstruction(object3, new DeepEqualityInstruction(instruction2, new IdentifierInstruction(object2)), new ChooseInstruction(new IdentifierInstruction(object3), generator.generate(), generator2.generate()));
            LetInstruction letInstruction2 = new LetInstruction(object2, this, letInstruction);
            return letInstruction2;
        }
        return null;
    }
}

