/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgTypeUtils;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.IImperativeInstruction;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.JavaClassImporter;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.GenFork;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ObjectFactory;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IConvertible;
import com.ibm.xltxe.rnm1.xylem.interpreter.InterpreterUtilities;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.JavaClassInformation;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.types.UnitType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xltxe.rnm1.xylem.xci.prototype.XCIConstruction;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.BasicDynamicContext;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StaticMethodInvocationInstruction
extends NaryPrimopInstruction
implements IImperativeInstruction {
    private static final Logger s_logger = LoggerUtil.getLogger(StaticMethodInvocationInstruction.class);
    private static final String s_className = StaticMethodInvocationInstruction.class.getName();
    protected String m_function;
    protected String m_class;
    protected Type m_type;

    public StaticMethodInvocationInstruction() {
    }

    public StaticMethodInvocationInstruction(String string2, Instruction[] instructionArray, Type type2) {
        super(instructionArray);
        this.m_function = string2;
        if (type2 == null) {
            type2 = new TypeVariable();
        }
        this.setCachedType(type2);
        this.m_type = type2;
        this.m_class = null;
    }

    @Override
    public Type getTypeParameter(int n2) {
        if (n2 == 0) {
            return this.m_type;
        }
        return null;
    }

    @Override
    public void setTypeParameter(int n2, Type type2) {
        if (n2 == 0) {
            this.m_type = type2;
        }
    }

    @Override
    public int getTypeParameterCount() {
        return 1;
    }

    public StaticMethodInvocationInstruction(String string2, String string3, Instruction[] instructionArray, Type type2) {
        super(instructionArray);
        this.m_function = string3;
        if (type2 == null) {
            type2 = new TypeVariable();
        }
        this.setCachedType(type2);
        this.m_type = type2;
        this.m_class = string2;
        if ("com.ibm.xltxe.rnm1.xylem.commandline.SparseStreamPopulator".equals(this.m_class)) {
            this.m_type = new JavaObjectType("Object").getStreamType();
        }
    }

    public String getFunction() {
        return this.m_function;
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_type;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature moduleSignature) {
        return this.m_type;
    }

    public void setFunction(String string2) {
        this.m_function = string2;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] instructionArray = new Instruction[this.m_parameters.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        StaticMethodInvocationInstruction staticMethodInvocationInstruction = new StaticMethodInvocationInstruction(this.m_class, this.m_function, instructionArray, this.m_type);
        StaticMethodInvocationInstruction.propagateInfo(this, staticMethodInvocationInstruction);
        return staticMethodInvocationInstruction;
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] instructionArray = (Instruction[])this.m_parameters.clone();
        StaticMethodInvocationInstruction staticMethodInvocationInstruction = new StaticMethodInvocationInstruction(this.m_class, this.m_function, instructionArray, this.m_type);
        StaticMethodInvocationInstruction.propagateInfo(this, staticMethodInvocationInstruction);
        return staticMethodInvocationInstruction;
    }

    @Override
    public String innerToString() {
        return "static-method-invoke@" + (this.m_type != null ? this.m_type.prettyPrint() : "null") + " " + (this.m_class == null || this.m_class.length() == 0 ? "" : this.m_class + ".") + this.m_function;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, String string2, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        Type type2 = this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
        FcgType fcgType = type2.equals(UnitType.s_unitType) ? FcgType.VOID : type2.getFCGType(fcgCodeGenHelper);
        SessionContext sessionContext = codeGenerationTracker.getSessionContext();
        BasicDynamicContext basicDynamicContext = new BasicDynamicContext(sessionContext);
        Environment environment = new Environment(basicDynamicContext);
        CodeGenerationSettings codeGenerationSettings = fcgCodeGenHelper.getSettings();
        environment.setArbitraryPrecision(codeGenerationSettings.getArbitraryPrecision());
        environment.setOverflowDetection(codeGenerationSettings.getOverflowDetection());
        Method method = this.resolveMethod(environment, fcgCodeGenHelper.getCurrentFunctionAsFunction(), null, false);
        environment.release(null);
        Class<?>[] classArray = method.getParameterTypes();
        FcgType[] fcgTypeArray = new FcgType[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            codeGenerationTracker.generateConventionally(this.m_parameters[i], fcgCodeGenHelper, fcgInstructionList, GenFork.NOTNEEDED);
            fcgTypeArray[i] = FcgTypeUtils.getFcgType(fcgCodeGenHelper, classArray[i]);
        }
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGenHelper.getClassReferenceType(method.getDeclaringClass().getName());
        fcgInstructionList.invokeClassMethod(fcgClassReferenceType, method.getName(), fcgType, fcgTypeArray);
        return fcgType;
    }

    public String getClassName() {
        if (this.m_class == null) {
            int n2 = this.m_function.lastIndexOf(46);
            if (n2 == -1 || n2 + 1 >= this.m_function.length()) {
                throw new RuntimeException();
            }
            return this.m_function.substring(0, n2);
        }
        return this.m_class;
    }

    public String getMethodName() {
        if (this.m_class == null) {
            int n2 = this.m_function.lastIndexOf(46);
            if (n2 == -1 || n2 + 1 >= this.m_function.length()) {
                throw new RuntimeException();
            }
            return this.m_function.substring(n2 + 1, this.m_function.length());
        }
        return this.m_function;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function2);
        }
        environment.pushForkScope();
        Object object2 = null;
        try {
            String string2 = this.getClassName();
            Object object3 = environment == null ? null : environment.m_statics.get(string2);
            Object[] objectArray = new Object[this.m_parameters.length];
            Type[] typeArray = new Type[this.m_parameters.length];
            int n2 = 0;
            while (true) {
                Object object4;
                Type type2;
                Object object5;
                if (n2 >= this.m_parameters.length) {
                    Method method = this.resolveMethod(environment, function2, iDebuggerInterceptor, bl, typeArray);
                    object5 = method.invoke(object3, objectArray);
                    type2 = this.evaluateType(function2);
                    object2 = type2.wrapForInterpreter(object5, environment);
                    object4 = Debugger.leave(iDebuggerInterceptor, this, environment, function2, object2);
                    environment.popForkScope(object2);
                    return object4;
                }
                object5 = this.m_parameters[n2];
                type2 = ((Instruction)object5).evaluateType(function2);
                object4 = ((Instruction)object5).evaluate(environment, function2, iDebuggerInterceptor, false);
                if (object4 instanceof IConvertible) {
                    object4 = ((IConvertible)object4).convert(environment, type2);
                }
                objectArray[n2] = XCIConstruction.evalForkIfNeeded(object4, environment);
                typeArray[n2] = type2;
                ++n2;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            try {
                RuntimeException runtimeException;
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RuntimeException) {
                    runtimeException = (RuntimeException)throwable;
                    throw runtimeException;
                }
                runtimeException = new RuntimeException(throwable);
                throw runtimeException;
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            catch (Throwable throwable) {
                environment.popForkScope(object2);
                throw throwable;
            }
        }
    }

    private Type[] getArgTypes(Environment environment, Function function2) {
        Type[] typeArray = new Type[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            typeArray[i] = this.m_parameters[i].evaluateType(function2);
        }
        return typeArray;
    }

    private Class[] getJavaArgTypes(Environment environment, Type[] typeArray) {
        Class[] classArray = new Class[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            classArray[i] = typeArray[i].getJavaType(environment);
        }
        return classArray;
    }

    private Method resolveMethod(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl, Type[] typeArray) {
        String string2 = this.getClassName();
        String string3 = this.getMethodName();
        Object object2 = environment == null ? null : environment.m_statics.get(string2);
        Class clazz = null;
        if (object2 == null) {
            while (clazz == null) {
                try {
                    clazz = ObjectFactory.findProviderClass(string2, ObjectFactory.findClassLoader(), true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    int n2 = string2.lastIndexOf(46);
                    if (n2 != -1) {
                        string2 = string2.substring(0, n2) + "$" + string2.substring(n2 + 1, string2.length());
                        continue;
                    }
                    throw new XylemError("ERR_SYSTEM", "Could not find class for " + this.getClassName());
                }
            }
        } else {
            clazz = object2.getClass();
        }
        try {
            Method method = InterpreterUtilities.getMethod(clazz, this.getMethodName(), this.getJavaArgTypes(environment, typeArray));
            return method;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Method resolveMethod(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        return this.resolveMethod(environment, function2, iDebuggerInterceptor, bl, this.getArgTypes(environment, function2));
    }

    @Override
    public boolean equals(Object object2) {
        if (!super.equals(object2)) {
            return false;
        }
        StaticMethodInvocationInstruction staticMethodInvocationInstruction = (StaticMethodInvocationInstruction)object2;
        return staticMethodInvocationInstruction.m_function.equals(this.m_function);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.m_function.hashCode();
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        this.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        this.typeCheckChildren(typeEnvironment, bindingEnvironment, linkedList);
        try {
            JavaClassInformation javaClassInformation = JavaClassImporter.retrieveJavaClassInformation(this.getClassName(), typeEnvironment.getModule());
            String string2 = this.m_function.startsWith(this.getClassName()) ? this.m_function.substring(this.getClassName().length() + 1) : this.m_function;
            Collection collection2 = javaClassInformation.getStaticMethods(string2);
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                int n2;
                String string3 = null;
                JavaClassInformation.Method method = (JavaClassInformation.Method)iterator.next();
                Type[] typeArray = method.getParameterTypes();
                if (typeArray.length != this.m_parameters.length) continue;
                TypeEnvironment typeEnvironment2 = typeEnvironment.copy();
                for (n2 = 0; string3 == null && n2 < typeArray.length; ++n2) {
                    string3 = typeEnvironment2.unifyQuietly(typeArray[n2], this.m_parameters[n2].getCachedType(), this);
                }
                for (n2 = 0; string3 == null && n2 < typeArray.length; ++n2) {
                    typeEnvironment.unify(typeArray[n2], this.m_parameters[n2].getCachedType(), this);
                }
                typeEnvironment.unifyQuietly(method.getReturnType(), this.m_type, this);
                if (string3 != null) {
                    if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINEST)) continue;
                    s_logger.logp(Level.FINEST, s_className, "typeCheck", "Method did not match.  reason: " + string3);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            String string4 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Cannot retrieve information for class " + this.getClassName() + " and method " + this.m_function});
            s_logger.logp(Level.WARNING, s_className, "typeCheck", string4, exception);
        }
        return this.setCachedType(this.m_type);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_type = readObjectFileHelper.readType();
        this.setCachedType(this.m_type);
        this.m_function = readObjectFileHelper.readString();
        boolean bl = readObjectFileHelper.readBoolean();
        if (bl) {
            this.m_class = readObjectFileHelper.readString();
        }
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeType(this.m_type);
        writeObjectFileHelper.writeString(this.m_function);
        writeObjectFileHelper.writeBoolean(this.m_class != null);
        if (this.m_class != null) {
            writeObjectFileHelper.writeString(this.m_class);
        }
    }
}

