/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.GenFork;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.ObjectFactory;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.JavaClassInformation;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.IOException;
import java.util.LinkedList;

public class StaticMemberInstruction
extends Instruction {
    protected String m_className;
    protected String m_fieldName;

    public StaticMemberInstruction() {
    }

    public StaticMemberInstruction(String string2, String string3) {
        this(string2, string3, null);
    }

    public StaticMemberInstruction(String string2, String string3, Type type2) {
        this.m_className = string2;
        this.m_fieldName = string3;
        this.setCachedType(type2);
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        return this.setCachedType(this.computeType(typeEnvironment.getModule()));
    }

    Type computeType(Module module) {
        JavaObjectType javaObjectType = new JavaObjectType(this.m_className);
        JavaClassInformation javaClassInformation = javaObjectType.getInformation(module);
        JavaClassInformation.Field field = javaClassInformation.getField(this.m_fieldName);
        return field.getType();
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        super.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
        if (this.getCachedType() == null) {
            this.setCachedType(this.computeType(typeEnvironment.getModule()));
        }
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.getCachedType();
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, String string2, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        JavaObjectType javaObjectType = new JavaObjectType(this.m_className);
        FcgClassReferenceType fcgClassReferenceType = (FcgClassReferenceType)javaObjectType.getFCGType(fcgCodeGenHelper);
        Type type2 = this.getCachedType();
        FcgType fcgType = codeGenerationTracker.getResolvedType(fcgCodeGenHelper, type2);
        fcgInstructionList.loadClassField(fcgClassReferenceType, this.m_fieldName, fcgType);
        return fcgType;
    }

    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        try {
            return ObjectFactory.findProviderClass(this.m_className, ObjectFactory.findClassLoader(), true).getDeclaredField(this.m_fieldName).get(null);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        StaticMemberInstruction staticMemberInstruction = new StaticMemberInstruction(this.m_className, this.m_fieldName);
        StaticMemberInstruction.propagateInfo(this, staticMemberInstruction);
        return staticMemberInstruction;
    }

    @Override
    public Instruction cloneShallow() {
        StaticMemberInstruction staticMemberInstruction = new StaticMemberInstruction(this.m_className, this.m_fieldName, this.getCachedType());
        StaticMemberInstruction.propagateInfo(this, staticMemberInstruction);
        return staticMemberInstruction;
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        instructionArray[0] = this;
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n2) {
        prettyPrinter.printFormOpen("java-static-field-ref " + this.m_className + " " + this.m_fieldName, n2);
        prettyPrinter.print(")");
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_className = readObjectFileHelper.readString();
        this.m_fieldName = readObjectFileHelper.readString();
        Type type2 = readObjectFileHelper.readType();
        if (type2 == null) {
            throw new XylemError("ERR_SYSTEM", "null type");
        }
        this.setCachedType(type2);
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeString(this.m_className);
        writeObjectFileHelper.writeString(this.m_fieldName);
        if (this.getCachedType() == null) {
            throw new XylemError("ERR_SYSTEM", "null type");
        }
        writeObjectFileHelper.writeType(this.getCachedType());
    }
}

