/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.IImperativeInstruction;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.JavaClassInformation;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.LinkedList;

public class SetJavaFieldInstruction
extends BinaryPrimopInstruction
implements IImperativeInstruction {
    protected String m_fieldName;

    public SetJavaFieldInstruction() {
    }

    public SetJavaFieldInstruction(Instruction instruction2, String string2, Instruction instruction3) {
        super(instruction2, instruction3);
        this.m_fieldName = string2;
    }

    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function2);
        }
        Object object2 = this.m_operand1.evaluate(environment, function2, iDebuggerInterceptor, false);
        Object object3 = this.m_operand2.evaluate(environment, function2, iDebuggerInterceptor, false);
        try {
            Field field = object2.getClass().getField(this.m_fieldName);
            field.set(object2, object3);
            return Debugger.leave(iDebuggerInterceptor, this, environment, function2, object3);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            throw new RuntimeException(securityException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            throw new RuntimeException(illegalArgumentException.getMessage());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
            throw new RuntimeException(noSuchFieldException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            throw new RuntimeException(illegalAccessException.getMessage());
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        SetJavaFieldInstruction setJavaFieldInstruction = new SetJavaFieldInstruction(this.m_operand1.cloneWithoutTypeInformation(), this.m_fieldName, this.m_operand2.cloneWithoutTypeInformation());
        SetJavaFieldInstruction.propagateInfo(this, setJavaFieldInstruction);
        return setJavaFieldInstruction;
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction2, Instruction instruction3) {
        return new SetJavaFieldInstruction(instruction2, this.m_fieldName, instruction3);
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type type2 = this.m_operand1.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        type2 = type2.resolveType(typeEnvironment);
        if (type2 == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not infer the type of " + this.m_operand1), this);
        }
        if (!(type2 instanceof JavaObjectType)) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_operand1 + " is not an object"), this);
        }
        JavaObjectType javaObjectType = (JavaObjectType)type2;
        JavaClassInformation.Field field = javaObjectType.getInformation(typeEnvironment.getModule()).getField(this.m_fieldName);
        if (field == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Class " + javaObjectType + " does not contain field " + this.m_fieldName), this);
        }
        typeEnvironment.unify(field.getType(), this.m_operand2.typeCheck(typeEnvironment, bindingEnvironment, linkedList), this);
        return this.setCachedType(field.getType());
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_operand2.getType(typeEnvironment, bindingEnvironment);
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature moduleSignature) {
        return this.m_operand2.getPreTypecheckType(moduleSignature);
    }

    @Override
    public String innerToString() {
        return "set-java-field! " + this.m_fieldName;
    }

    @Override
    public boolean equals(Object object2) {
        return this == object2;
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeString(this.m_fieldName);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_fieldName = readObjectFileHelper.readString();
    }
}

