/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgUnaryOp;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.GenFork;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.BigIntegerType;
import com.ibm.xltxe.rnm1.xylem.types.DecimalType;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.FloatType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.LongType;
import java.math.BigDecimal;
import java.util.LinkedList;

public class RoundInstruction
extends UnaryPrimopInstruction {
    public RoundInstruction(Instruction instruction2) {
        super(instruction2);
    }

    public RoundInstruction() {
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        RoundInstruction roundInstruction = new RoundInstruction(this.m_operand.cloneWithoutTypeInformation());
        RoundInstruction.propagateInfo(this, roundInstruction);
        return roundInstruction;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        return this.setCachedType(this.m_operand.typeCheck(typeEnvironment, bindingEnvironment, linkedList));
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_operand.getType(typeEnvironment, bindingEnvironment);
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature moduleSignature) {
        return this.m_operand.getPreTypecheckType(moduleSignature);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, String string2, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        FcgType fcgType;
        FcgType fcgType2 = codeGenerationTracker.generateConventionally(this.m_operand, fcgCodeGenHelper, fcgInstructionList);
        Type type2 = codeGenerationTracker.resolveType(this);
        if (type2.equals(IntType.s_intType) || type2.equals(LongType.s_longType) || type2.equals(BigIntegerType.s_bigIntegerType)) {
            fcgType = fcgType2;
        } else if (type2.equals(FloatType.s_floatType) || type2.equals(DoubleType.s_doubleType) || type2.equals(DecimalType.s_decimalType)) {
            fcgType = fcgInstructionList.unaryOperationExpr(FcgUnaryOp.ROUND);
            fcgType = fcgInstructionList.convertExpr(fcgType, type2.getFCGType(fcgCodeGenHelper));
        } else {
            throw new UnsupportedOperationException("Absolute value not supported for type " + type2);
        }
        return fcgType;
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n2) {
        prettyPrinter.newline();
        prettyPrinter.printFormOpen("round", n2);
        this.m_operand.toString(prettyPrinter, n2 + 1);
        prettyPrinter.print(")");
    }

    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function2);
        }
        Type type2 = this.m_operand.evaluateType(function2);
        Object object2 = this.m_operand.evaluate(environment, function2, iDebuggerInterceptor, false);
        Object object3 = null;
        if (type2.equals(IntType.s_intType) || type2.equals(LongType.s_longType)) {
            object3 = object2;
        } else if (type2.equals(FloatType.s_floatType)) {
            object3 = new Float(Math.round(((Number)object2).floatValue()));
        } else if (type2.equals(DoubleType.s_doubleType)) {
            object3 = new Double(Math.round(((Number)object2).doubleValue()));
        } else if (type2.equals(BigIntegerType.s_bigIntegerType) || type2.equals(DecimalType.s_decimalType)) {
            object3 = new BigDecimal(Math.round(((Number)object2).doubleValue()));
        } else {
            throw new UnsupportedOperationException("Absolute value not supported for type " + type2);
        }
        return Debugger.leave(iDebuggerInterceptor, this, environment, function2, object3);
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction2) {
        RoundInstruction roundInstruction = new RoundInstruction(instruction2);
        RoundInstruction.propagateInfo(this, roundInstruction);
        return roundInstruction;
    }
}

