/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.ByteType;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.FloatType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.LongType;
import com.ibm.xltxe.rnm1.xylem.types.MemoryType;
import com.ibm.xltxe.rnm1.xylem.types.ShortType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.IOException;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Map;

public class ReadMemoryInstruction
extends BinaryPrimopInstruction {
    protected Type m_type;
    private static Object s_unsafe;
    private static Method sm_unsafeGetUnsafeInt;
    private static Method sm_unsafeGetUnsafeShort;
    private static Method sm_unsafeGetUnsafeLong;
    private static Method sm_unsafeGetUnsafeFloat;
    private static Method sm_unsafeGetUnsafeDouble;
    private static Method sm_unsafeGetUnsafeByte;
    private static Method sm_unsafeGetUnsafeChar;

    public ReadMemoryInstruction() {
    }

    public void setType(Type type2) {
        this.m_type = type2;
    }

    public ReadMemoryInstruction(Instruction instruction2, Instruction instruction3, Type type2) {
        super(instruction2, instruction3);
        this.setCachedType(type2);
        this.m_type = type2;
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_type;
    }

    public Type getType() {
        return this.m_type;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature moduleSignature) {
        return this.m_type;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        ReadMemoryInstruction readMemoryInstruction = new ReadMemoryInstruction(this.m_operand1.cloneWithoutTypeInformation(), this.m_operand2.cloneWithoutTypeInformation(), this.m_type);
        ReadMemoryInstruction.propagateInfo(this, readMemoryInstruction);
        return readMemoryInstruction;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        typeEnvironment.unify(this.m_operand1.typeCheck(typeEnvironment, bindingEnvironment, linkedList), MemoryType.s_memoryType, this);
        typeEnvironment.unify(this.m_operand2.typeCheck(typeEnvironment, bindingEnvironment, linkedList), IntType.s_intType, this);
        return this.m_type;
    }

    @Override
    public int getTypeParameterCount() {
        return 1;
    }

    @Override
    public Type getTypeParameter(int n2) {
        return n2 == 0 ? this.m_type : null;
    }

    @Override
    public void setTypeParameter(int n2, Type type2) {
        if (n2 == 0) {
            this.m_type = type2;
        }
    }

    @Override
    public String innerToString() {
        return "read-memory " + this.m_type.prettyPrint();
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction2, Instruction instruction3) {
        return new ReadMemoryInstruction(instruction2, instruction3, this.m_type);
    }

    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        Constable constable;
        block14: {
            if (null != iDebuggerInterceptor) {
                iDebuggerInterceptor.enter(this, environment, function2);
            }
            Long l = (Long)this.m_operand1.evaluate(environment, function2, iDebuggerInterceptor, false);
            Integer n2 = (Integer)this.m_operand2.evaluate(environment, function2, iDebuggerInterceptor, false);
            constable = null;
            try {
                if (s_unsafe == null) {
                    Class<?> clazz = Class.forName("sun.misc.Unsafe");
                    Method method = clazz.getMethod("getUnsafe", new Class[0]);
                    s_unsafe = method.invoke(null, new Object[0]);
                    Class<?> clazz2 = s_unsafe.getClass();
                    Class[] classArray = new Class[]{Long.class};
                    sm_unsafeGetUnsafeInt = clazz2.getMethod("getInt", classArray);
                    sm_unsafeGetUnsafeShort = clazz2.getMethod("getShort", classArray);
                    sm_unsafeGetUnsafeLong = clazz2.getMethod("getLong", classArray);
                    sm_unsafeGetUnsafeByte = clazz2.getMethod("getByte", classArray);
                    sm_unsafeGetUnsafeChar = clazz2.getMethod("getChar", classArray);
                    sm_unsafeGetUnsafeFloat = clazz2.getMethod("getFloat", classArray);
                    sm_unsafeGetUnsafeDouble = clazz2.getMethod("getDouble", classArray);
                }
                if (this.m_type.equals(IntType.s_intType)) {
                    constable = (Integer)sm_unsafeGetUnsafeInt.invoke(s_unsafe, new Long(l + (long)n2.intValue()));
                    break block14;
                }
                if (this.m_type.equals(LongType.s_longType)) {
                    constable = (Long)sm_unsafeGetUnsafeLong.invoke(s_unsafe, new Long(l + (long)n2.intValue()));
                    break block14;
                }
                if (this.m_type.equals(ShortType.s_shortType)) {
                    constable = (Short)sm_unsafeGetUnsafeShort.invoke(s_unsafe, new Long(l + (long)n2.intValue()));
                    break block14;
                }
                if (this.m_type.equals(CharType.s_charType)) {
                    constable = (Character)sm_unsafeGetUnsafeChar.invoke(s_unsafe, new Long(l + (long)n2.intValue()));
                    break block14;
                }
                if (this.m_type.equals(DoubleType.s_doubleType)) {
                    constable = (Double)sm_unsafeGetUnsafeDouble.invoke(s_unsafe, new Long(l + (long)n2.intValue()));
                    break block14;
                }
                if (this.m_type.equals(FloatType.s_floatType)) {
                    constable = (Float)sm_unsafeGetUnsafeFloat.invoke(s_unsafe, new Long(l + (long)n2.intValue()));
                    break block14;
                }
                if (this.m_type.equals(ByteType.s_byteType)) {
                    constable = (Byte)sm_unsafeGetUnsafeByte.invoke(s_unsafe, new Long(l + (long)n2.intValue()));
                    break block14;
                }
                throw new UnsupportedOperationException();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new XylemError("ERR_SYSTEM", "ReadMemoryInstruction evaluation failed, requires JVM 1.4, " + classNotFoundException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new XylemError("ERR_SYSTEM", "ReadMemoryInstruction evaluation failed, requires JVM 1.4, " + noSuchMethodException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new XylemError("ERR_SYSTEM", "ReadMemoryInstruction evaluation failed, requires JVM 1.4, " + invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XylemError("ERR_SYSTEM", "ReadMemoryInstruction evaluation failed, requires JVM 1.4, " + illegalAccessException);
            }
        }
        return Debugger.leave(iDebuggerInterceptor, this, environment, function2, (Object)constable);
    }

    @Override
    public void replaceTypeVariables(Map map2) {
        super.replaceTypeVariables(map2);
        this.m_type = this.m_type.replaceType(map2);
        this.setCachedType(this.m_type);
    }

    @Override
    public boolean equals(Object object2) {
        return super.equals(object2) && ((ReadMemoryInstruction)object2).m_type.equals(this.m_type);
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        super.generateReducedForm(reductionHelper, instructionArray, bindingEnvironment);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_type = readObjectFileHelper.readType();
        this.setCachedType(this.m_type);
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeType(this.m_type);
    }
}

