/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.IImperativeInstruction;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.GenFork;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.JavaClassInformation;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.LinkedList;

public class ReadJavaFieldInstruction
extends UnaryPrimopInstruction
implements IImperativeInstruction {
    protected String m_fieldName;

    public ReadJavaFieldInstruction() {
    }

    public ReadJavaFieldInstruction(Instruction instruction2, String string2) {
        super(instruction2);
        this.m_fieldName = string2;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, String string2, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        Type type2 = this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
        FcgType fcgType = codeGenerationTracker.getResolvedType(fcgCodeGenHelper, type2);
        FcgClassReferenceType fcgClassReferenceType = (FcgClassReferenceType)codeGenerationTracker.generateConventionally(this.m_operand, fcgCodeGenHelper, fcgInstructionList);
        fcgInstructionList.loadInstanceField(fcgClassReferenceType, this.m_fieldName, fcgType);
        return fcgType;
    }

    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function2);
        }
        Object object2 = this.m_operand.evaluate(environment, function2, iDebuggerInterceptor, false);
        try {
            Field field = object2.getClass().getField(this.m_fieldName);
            Object object3 = field.get(object2);
            return Debugger.leave(iDebuggerInterceptor, this, environment, function2, object3);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            throw new RuntimeException(securityException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            throw new RuntimeException(illegalArgumentException.getMessage());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
            throw new RuntimeException(noSuchFieldException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            throw new RuntimeException(illegalAccessException.getMessage());
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        ReadJavaFieldInstruction readJavaFieldInstruction = new ReadJavaFieldInstruction(this.m_operand.cloneWithoutTypeInformation(), this.m_fieldName);
        ReadJavaFieldInstruction.propagateInfo(this, readJavaFieldInstruction);
        return readJavaFieldInstruction;
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction2) {
        ReadJavaFieldInstruction readJavaFieldInstruction = new ReadJavaFieldInstruction(instruction2, this.m_fieldName);
        ReadJavaFieldInstruction.propagateInfo(this, readJavaFieldInstruction);
        return readJavaFieldInstruction;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type type2 = this.m_operand.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        type2 = type2.resolveType(typeEnvironment);
        if (type2 == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not infer the type of " + this.m_operand), this);
        }
        if (!(type2 instanceof JavaObjectType)) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_operand + " is not an object"), this);
        }
        JavaObjectType javaObjectType = (JavaObjectType)type2;
        JavaClassInformation.Field field = javaObjectType.getInformation(typeEnvironment.getModule()).getField(this.m_fieldName);
        if (field == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Class " + javaObjectType + " does not contain field " + this.m_fieldName), this);
        }
        return this.setCachedType(field.getType());
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type type2 = this.m_operand.getType(typeEnvironment, bindingEnvironment);
        type2 = type2.resolveType(typeEnvironment);
        JavaObjectType javaObjectType = (JavaObjectType)type2;
        JavaClassInformation.Field field = javaObjectType.getInformation(typeEnvironment.getModule()).getField(this.m_fieldName);
        return field.getType();
    }

    @Override
    public String innerToString() {
        return "read-java-field! " + this.m_fieldName;
    }

    @Override
    public boolean equals(Object object2) {
        return this == object2;
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeString(this.m_fieldName);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_fieldName = readObjectFileHelper.readString();
    }
}

