/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.GenFork;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.ClassType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import java.io.IOException;
import java.util.LinkedList;

public class ReadFieldInstruction
extends UnaryPrimopInstruction {
    protected String m_fieldName;

    public ReadFieldInstruction() {
    }

    public ReadFieldInstruction(Instruction instruction2, String string2) {
        super(instruction2);
        this.m_fieldName = string2;
    }

    public String getFieldName() {
        return this.m_fieldName;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, String string2, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        Type type2 = this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
        FcgType fcgType = codeGenerationTracker.getResolvedType(fcgCodeGenHelper, type2);
        FcgClassReferenceType fcgClassReferenceType = (FcgClassReferenceType)codeGenerationTracker.generateConventionally(this.m_operand, fcgCodeGenHelper, fcgInstructionList);
        fcgInstructionList.loadInstanceField(fcgClassReferenceType, this.m_fieldName, fcgType);
        return fcgType;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        ReadFieldInstruction readFieldInstruction = new ReadFieldInstruction(this.m_operand.cloneWithoutTypeInformation(), this.m_fieldName);
        ReadFieldInstruction.propagateInfo(this, readFieldInstruction);
        return readFieldInstruction;
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction2) {
        ReadFieldInstruction readFieldInstruction = new ReadFieldInstruction(instruction2, this.m_fieldName);
        ReadFieldInstruction.propagateInfo(this, readFieldInstruction);
        return readFieldInstruction;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type type2 = this.m_operand.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        type2 = type2.resolveType(typeEnvironment);
        if (type2 == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not infer the type of " + this.m_operand), this);
        }
        if (!(type2 instanceof NamedType)) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_operand + " is not an object"), this);
        }
        ClassType classType = (ClassType)((NamedType)type2).resolveName(typeEnvironment);
        ClassType.Field field = classType.resolveField(this.m_fieldName, typeEnvironment);
        if (field == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Class " + classType.getName() + " does not contain field " + this.m_fieldName), this);
        }
        return this.setCachedType(field.getType());
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type type2 = this.m_operand.getType(typeEnvironment, bindingEnvironment);
        type2 = type2.resolveType(typeEnvironment);
        ClassType classType = (ClassType)((NamedType)type2).resolveName(typeEnvironment);
        ClassType.Field field = classType.resolveField(this.m_fieldName, typeEnvironment);
        return field.getType();
    }

    @Override
    public String innerToString() {
        return "get-field! " + this.m_fieldName;
    }

    @Override
    public boolean equals(Object object2) {
        return this == object2;
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_fieldName = readObjectFileHelper.readString();
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeString(this.m_fieldName);
    }
}

