/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.GenFork;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.ListStream;
import com.ibm.xltxe.rnm1.xylem.types.BigIntegerType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.IntegerType;
import com.ibm.xltxe.rnm1.xylem.types.LongType;
import java.io.IOException;
import java.math.BigInteger;
import java.util.LinkedList;

public class RangeInstruction
extends BinaryPrimopInstruction {
    private Type m_type;

    public RangeInstruction(Instruction instruction2, Instruction instruction3) {
        super(instruction2, instruction3);
    }

    public RangeInstruction() {
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction2, Instruction instruction3) {
        RangeInstruction rangeInstruction = new RangeInstruction(instruction2, instruction3);
        return rangeInstruction;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, String string2, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        FcgType fcgType;
        FcgType fcgType2;
        if (this.m_type == IntegerType.s_integerType) {
            Type type2 = this.m_type = fcgCodeGenHelper.getSettings().getArbitraryPrecision() ? BigIntegerType.s_bigIntegerType : LongType.s_longType;
        }
        if (this.m_type == LongType.s_longType) {
            fcgType2 = FcgType.LONG;
            fcgType = FcgType.LONG_ARRAY;
        } else if (this.m_type == BigIntegerType.s_bigIntegerType) {
            fcgType2 = FcgType.BIG_INTEGER;
            fcgType = fcgCodeGenHelper.getArrayType(FcgType.BIG_INTEGER);
        } else {
            fcgType2 = FcgType.INT;
            fcgType = FcgType.INT_ARRAY;
        }
        String string3 = fcgCodeGenHelper.generateNewLocalVariableName();
        String string4 = fcgCodeGenHelper.generateNewLocalVariableName();
        String string5 = fcgCodeGenHelper.generateNewLocalVariableName();
        fcgInstructionList.comment(" code generated from RangeInstruction, stored into " + string3);
        fcgInstructionList.comment(" range start value, stored into " + string4);
        codeGenerationTracker.generateConventionally(this.m_operand1, fcgCodeGenHelper, fcgInstructionList);
        FcgVariable fcgVariable = fcgInstructionList.defineVar(fcgType2, string4, true);
        fcgInstructionList.comment(" range start value, stored into " + string5);
        codeGenerationTracker.generateConventionally(this.m_operand2, fcgCodeGenHelper, fcgInstructionList);
        FcgVariable fcgVariable2 = fcgInstructionList.defineVar(fcgType2, string5, true);
        FcgVariable fcgVariable3 = fcgInstructionList.defineVar(fcgType, string3, false);
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.loadVar(fcgVariable2);
        fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_GT);
        fcgInstructionList.beginIf();
        fcgInstructionList.loadLiteral(0);
        fcgInstructionList.createArrayExpr(fcgType2, false);
        fcgInstructionList.storeVar(fcgVariable3);
        fcgInstructionList.beginElse();
        fcgInstructionList.loadVar(fcgVariable2);
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.binaryOperationExpr(FcgBinOp.SUBTRACT);
        fcgInstructionList.loadLiteral(1);
        if (this.m_type == BigIntegerType.s_bigIntegerType) {
            fcgInstructionList.convertExpr(FcgType.INT, FcgType.BIG_INTEGER);
        }
        fcgInstructionList.binaryOperationExpr(FcgBinOp.PLUS);
        fcgInstructionList.convertExpr(fcgType2, FcgType.INT);
        fcgInstructionList.createArrayExpr(fcgType2, false);
        fcgInstructionList.storeVar(fcgVariable3);
        String string6 = string3 + "_index";
        fcgInstructionList.loadVar(fcgVariable);
        FcgVariable fcgVariable4 = fcgInstructionList.defineVar(fcgType2, string6, true);
        fcgInstructionList.loadVar(fcgVariable4);
        fcgInstructionList.loadVar(fcgVariable2);
        fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_LTE);
        fcgInstructionList.preIncrementAndLoadLocalVariable(fcgVariable4);
        fcgInstructionList.beginConditionalLoop(null, 2);
        fcgInstructionList.loadVar(fcgVariable3);
        fcgInstructionList.loadVar(fcgVariable4);
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.binaryOperationExpr(FcgBinOp.SUBTRACT);
        fcgInstructionList.convertExpr(fcgType2, FcgType.INT);
        fcgInstructionList.loadVar(fcgVariable4);
        fcgInstructionList.storeArrayElemStmt();
        fcgInstructionList.endConditionalLoop();
        fcgInstructionList.endIf();
        fcgInstructionList.loadVar(fcgVariable3);
        return fcgType;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        RangeInstruction rangeInstruction = new RangeInstruction(this.m_operand1.cloneWithoutTypeInformation(), this.m_operand2.cloneWithoutTypeInformation());
        RangeInstruction.propagateInfo(this, rangeInstruction);
        return rangeInstruction;
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_operand1.getType(typeEnvironment, bindingEnvironment).getStreamType();
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type type2 = this.m_operand1.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        typeEnvironment.unify(type2, this.m_operand2.typeCheck(typeEnvironment, bindingEnvironment, linkedList), this);
        try {
            typeEnvironment.unify(type2, IntegerType.s_integerType, this);
        }
        catch (TypeCheckException typeCheckException) {
            try {
                typeEnvironment.unify(type2, LongType.s_longType, this);
            }
            catch (TypeCheckException typeCheckException2) {
                try {
                    typeEnvironment.unify(type2, BigIntegerType.s_bigIntegerType, this);
                }
                catch (TypeCheckException typeCheckException3) {
                    typeEnvironment.unify(type2, IntType.s_intType, this);
                }
            }
        }
        this.m_type = type2;
        return this.setCachedType(type2.getStreamType());
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        this.m_type = this.m_operand1.getType(typeEnvironment, bindingEnvironment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function2);
        }
        environment.pushForkScope();
        ListStream listStream = null;
        try {
            Number number2 = (Number)this.m_operand1.evaluate(environment, function2, iDebuggerInterceptor, false);
            Number number3 = (Number)this.m_operand2.evaluate(environment, function2, iDebuggerInterceptor, false);
            ListStream listStream2 = new ListStream();
            environment.pushIForkReleaseManagedForRelease(listStream2);
            if (this.m_type == IntegerType.s_integerType) {
                Type type2 = this.m_type = environment.getArbitraryPrecision() ? BigIntegerType.s_bigIntegerType : LongType.s_longType;
            }
            if (this.m_type == LongType.s_longType) {
                for (long i = number2.longValue(); i <= number3.longValue(); ++i) {
                    listStream2.append(new Long(i), this.m_type);
                }
            } else if (this.m_type == BigIntegerType.s_bigIntegerType) {
                BigInteger bigInteger = (BigInteger)number2;
                BigInteger bigInteger2 = (BigInteger)number3;
                BigInteger bigInteger3 = BigInteger.ONE;
                while (bigInteger.compareTo(bigInteger2) <= 0) {
                    listStream2.append(bigInteger, this.m_type);
                    bigInteger = bigInteger.add(bigInteger3);
                }
            } else {
                for (int i = number2.intValue(); i <= number3.intValue(); ++i) {
                    listStream2.append(new Integer(i), this.m_type);
                }
            }
            listStream = listStream2;
            environment.popForkScope((Object)listStream);
        }
        catch (Throwable throwable) {
            environment.popForkScope((Object)listStream);
            throw throwable;
        }
        return Debugger.leave(iDebuggerInterceptor, this, environment, function2, (Object)listStream);
    }

    @Override
    public String innerToString() {
        return "range";
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_type = readObjectFileHelper.readType();
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeType(this.m_type);
    }
}

