/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.GenFork;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.BooleanType;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.types.PrimitiveNumericalType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.IOException;
import java.util.LinkedList;

public class NumericalComparisonInstruction
extends BinaryPrimopInstruction {
    protected int m_operator;

    public NumericalComparisonInstruction() {
    }

    public NumericalComparisonInstruction(Instruction instruction2, Instruction instruction3, int n2) {
        super(instruction2, instruction3);
        this.m_operator = n2;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type type2 = this.m_operand1.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type type3 = this.m_operand2.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        typeEnvironment.unify(type2, type3, this);
        return this.setCachedType(BooleanType.s_booleanType);
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return BooleanType.s_booleanType;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature moduleSignature) {
        return BooleanType.s_booleanType;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        NumericalComparisonInstruction numericalComparisonInstruction = new NumericalComparisonInstruction(this.m_operand1.cloneWithoutTypeInformation(), this.m_operand2.cloneWithoutTypeInformation(), this.m_operator);
        NumericalComparisonInstruction.propagateInfo(this, numericalComparisonInstruction);
        return numericalComparisonInstruction;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, String string2, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        codeGenerationTracker.generateConventionally(this.m_operand1, fcgCodeGenHelper, fcgInstructionList);
        codeGenerationTracker.generateConventionally(this.m_operand2, fcgCodeGenHelper, fcgInstructionList);
        Type type2 = codeGenerationTracker.resolveType(this.m_operand1);
        if (!(type2 instanceof INumericalType)) {
            throw new XylemError("ERR_SYSTEM", "Primitive comparison operations only supported on numerical types and char");
        }
        INumericalType iNumericalType = (INumericalType)((Object)type2);
        FcgBinOp fcgBinOp = (FcgBinOp)FcgCodeGenHelper.getFcgOperation(this.m_operator);
        FcgType fcgType = iNumericalType.generateCodeForOperation(fcgCodeGenHelper, fcgInstructionList, fcgBinOp);
        return fcgType;
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n2) {
        prettyPrinter.printFormOpen(PrimitiveNumericalType.getOperatorString(this.m_operator), n2);
        this.m_operand1.toString(prettyPrinter, n2 + 1);
        this.m_operand2.toString(prettyPrinter, n2 + 1);
        prettyPrinter.printFormClose(n2);
    }

    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function2);
        }
        Type type2 = this.m_operand1.evaluateType(function2);
        Object object2 = this.m_operand1.evaluate(environment, function2, iDebuggerInterceptor, false);
        Object object3 = this.m_operand2.evaluate(environment, function2, iDebuggerInterceptor, false);
        if (!(type2 instanceof INumericalType)) {
            throw new XylemError("ERR_SYSTEM", "Primitive comparison operations only supported on numerical types");
        }
        INumericalType iNumericalType = (INumericalType)((Object)type2);
        Object object4 = iNumericalType.evaluateOperation(environment, object2, object3, this.m_operator);
        return Debugger.leave(iDebuggerInterceptor, this, environment, function2, object4);
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction2, Instruction instruction3) {
        return new NumericalComparisonInstruction(instruction2, instruction3, this.m_operator);
    }

    public int getOperation() {
        return this.m_operator;
    }

    @Override
    public boolean equals(Object object2) {
        if (!super.equals(object2)) {
            return false;
        }
        return ((NumericalComparisonInstruction)object2).m_operator == this.m_operator;
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeInt(this.m_operator);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_operator = readObjectFileHelper.readInt();
    }
}

