/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public abstract class NaryPrimopInstruction
extends Instruction {
    public Instruction[] m_parameters;

    protected static final Instruction[] convertParameters(List<Instruction> list) {
        Instruction[] instructionArray = new Instruction[list.size()];
        list.toArray(instructionArray);
        return instructionArray;
    }

    public NaryPrimopInstruction(Instruction[] instructionArray) {
        this.m_parameters = instructionArray;
    }

    public NaryPrimopInstruction(List<Instruction> list) {
        this(NaryPrimopInstruction.convertParameters(list));
    }

    public NaryPrimopInstruction() {
        this((Instruction[])null);
    }

    public Instruction[] getOperands() {
        return this.m_parameters;
    }

    public int getOperandCount() {
        return this.m_parameters.length;
    }

    protected void typeCheckChildren(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        for (int i = 0; i < this.m_parameters.length; ++i) {
            this.m_parameters[i].typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        }
    }

    @Override
    public Instruction getChildInstruction(int n2) {
        return this.m_parameters[n2];
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_parameters.length;
    }

    @Override
    public void setChildInstruction(int n2, Instruction instruction2) {
        this.m_parameters[n2] = instruction2;
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        for (Instruction instruction2 : this.m_parameters) {
            this.m_parameters[var5_5] = reductionHelper.reduceToBasicInstruction(instructionArray, instruction2, bindingEnvironment);
        }
        instructionArray[0] = this;
        this.m_bindingEnvironment = null;
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        int n2 = readObjectFileHelper.readInt();
        this.m_parameters = new Instruction[n2];
        for (int i = 0; i < n2; ++i) {
            this.m_parameters[i] = readObjectFileHelper.readInstruction(bindingEnvironment);
        }
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        int n2 = this.m_parameters.length;
        writeObjectFileHelper.writeInt(n2);
        for (int i = 0; i < n2; ++i) {
            writeObjectFileHelper.writeInstruction(this.m_parameters[i]);
        }
    }

    @Override
    public Instruction cloneReduced() {
        return this.cloneShallow();
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
    }
}

