/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IAppendableStream;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ModuleFunctionCallInstruction
extends NaryPrimopInstruction {
    private static final Logger s_logger = LoggerUtil.getLogger(ModuleFunctionCallInstruction.class);
    private static final String s_className = ModuleFunctionCallInstruction.class.getName();
    protected String m_function;
    protected String m_module;
    public static boolean LAZYMODULETYPECHECK = false;

    public ModuleFunctionCallInstruction() {
    }

    public ModuleFunctionCallInstruction(String string2, String string3, Instruction[] instructionArray) {
        super(instructionArray);
        this.m_module = string2;
        this.m_function = string3;
    }

    public ModuleFunctionCallInstruction(String string2, String string3, List list) {
        super(list);
        this.m_module = string2;
        this.m_function = string3;
    }

    public String getModule() {
        return this.m_module;
    }

    public String getFunction() {
        return this.m_function;
    }

    public void setFunction(String string2) {
        this.m_function = string2;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        Serializable serializable;
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        FunctionSignature functionSignature = this.resolveFunctionSignature(typeEnvironment);
        if (functionSignature == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Function " + this.m_function + " not found in signature of " + "module " + this.m_module), this);
        }
        if (functionSignature.getParameterTypes().length != this.m_parameters.length) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Incorrect number of parameters to " + this.m_function + " in module " + this.m_module + "\n  expected " + functionSignature.getParameterTypes().length + ", found " + this.m_parameters.length), this);
        }
        if (LAZYMODULETYPECHECK && !((Function)(serializable = this.resolveFunction(typeEnvironment))).hasBeenTypeChecked()) {
            ((Function)serializable).typeCheck(typeEnvironment.getModule().getProgram().getModule(this.m_module), this, linkedList);
        }
        serializable = new TypeEnvironment(typeEnvironment.getModule());
        HashSet hashSet = new HashSet();
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Type type2 = this.m_parameters[i].typeCheck(typeEnvironment, bindingEnvironment, linkedList);
            try {
                ((TypeEnvironment)serializable).unify(type2.resolveTypeAsMuchAsPossible(typeEnvironment, hashSet), functionSignature.getParameterTypes()[i], this.m_parameters[i]);
                continue;
            }
            catch (TypeCheckException typeCheckException) {
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Type error in parameter " + i + " for function " + this.m_function + " of module " + this.m_module + "\n" + typeCheckException.getMessage()), this);
            }
        }
        return this.setCachedType(functionSignature.getReturnType().resolveTypeAsMuchAsPossible((TypeEnvironment)serializable, hashSet));
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        try {
            FunctionSignature functionSignature = this.resolveFunctionSignature(typeEnvironment);
            if (functionSignature == null) {
                String string2 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Function not resolved for " + this});
                XylemError xylemError = new XylemError(string2);
                FFDCUtil.log(xylemError, this);
                s_logger.logp(Level.SEVERE, s_className, "getType", string2);
                throw xylemError;
            }
            return functionSignature.getReturnType();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature moduleSignature) {
        FunctionSignature functionSignature = moduleSignature.getFunctionSignature(this.m_function);
        if (functionSignature != null) {
            return functionSignature.getReturnType();
        }
        ModuleSignature moduleSignature2 = moduleSignature.getModuleSignature(this.m_module);
        if (moduleSignature2 != null && (functionSignature = moduleSignature2.getFunctionSignature(this.m_function)) != null) {
            return functionSignature.getReturnType();
        }
        return super.getPreTypecheckType(moduleSignature);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] instructionArray = new Instruction[this.m_parameters.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        ModuleFunctionCallInstruction moduleFunctionCallInstruction = new ModuleFunctionCallInstruction(this.m_module, this.m_function, instructionArray);
        ModuleFunctionCallInstruction.propagateInfo(this, moduleFunctionCallInstruction);
        return moduleFunctionCallInstruction;
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] instructionArray = (Instruction[])this.m_parameters.clone();
        ModuleFunctionCallInstruction moduleFunctionCallInstruction = new ModuleFunctionCallInstruction(this.m_module, this.m_function, instructionArray);
        ModuleFunctionCallInstruction.propagateInfo(this, moduleFunctionCallInstruction);
        return moduleFunctionCallInstruction;
    }

    @Override
    public boolean equals(Object object2) {
        if (this == object2) {
            return true;
        }
        if (!super.equals(object2)) {
            return false;
        }
        ModuleFunctionCallInstruction moduleFunctionCallInstruction = (ModuleFunctionCallInstruction)object2;
        return moduleFunctionCallInstruction.m_function.equals(this.m_function) && moduleFunctionCallInstruction.m_module.equals(this.m_module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function2);
        }
        Function function3 = this.resolveFunction(function2.getTypeEnvironment());
        environment.pushForkScope();
        Object object2 = null;
        try {
            Binding[] bindingArray = function3.m_parameters;
            environment.establishStackFrame(function3.getStackFrameSize(), function3.getName());
            for (int i = 0; i < bindingArray.length; ++i) {
                Object object3 = this.m_parameters[i].evaluate(environment, function2, iDebuggerInterceptor, false);
                environment.bindInEstablishedFrame(bindingArray[i], object3);
            }
            environment.pushStackFrame(function3.getName());
            Debugger.enterContext(iDebuggerInterceptor, function3);
            Object object4 = function3.getBody().evaluate(environment, function3, iDebuggerInterceptor, false);
            Debugger.leaveContext(iDebuggerInterceptor, function3, object4);
            object2 = object4;
            environment.popStackFrame(function3.getName());
            environment.popForkScope(object2);
        }
        catch (Throwable throwable) {
            environment.popForkScope(object2);
            throw throwable;
        }
        return Debugger.leave(iDebuggerInterceptor, this, environment, function2, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluate(IAppendableStream iAppendableStream, Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function2);
        }
        Function function3 = this.resolveFunction(function2.getTypeEnvironment());
        environment.pushForkScope();
        try {
            environment.establishStackFrame(function3.getStackFrameSize());
            Binding[] bindingArray = function3.m_parameters;
            Object[] objectArray = new Object[bindingArray.length];
            for (int i = 0; i < bindingArray.length; ++i) {
                Object object2 = this.m_parameters[i].evaluate(environment, function2, iDebuggerInterceptor, false);
                environment.bindInEstablishedFrame(bindingArray[i], object2);
            }
            environment.pushStackFrame();
            Debugger.enterContext(iDebuggerInterceptor, function3);
            function3.getBody().evaluate(iAppendableStream, environment, function3, iDebuggerInterceptor);
            Debugger.leaveContext(iDebuggerInterceptor, function3, null);
            environment.popStackFrame();
        }
        finally {
            environment.popForkScope();
        }
        Debugger.leave(iDebuggerInterceptor, this, environment, function2, null);
    }

    private Function resolveFunction(TypeEnvironment typeEnvironment) {
        Module module = typeEnvironment.getModule().getProgram().getModule(this.m_module);
        if (module == null) {
            return null;
        }
        return module.getPublicFunction(this.m_function);
    }

    protected FunctionSignature resolveFunctionSignature(TypeEnvironment typeEnvironment) throws TypeCheckException {
        ModuleSignature moduleSignature = typeEnvironment.getModule().getModuleSignature(this.m_module);
        if (moduleSignature == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Module " + this.m_module + " could not be resolved"), this);
        }
        FunctionSignature functionSignature = moduleSignature.getFunctionSignature(this.m_function);
        if (functionSignature == null) {
            throw new XylemError("ERR_SYSTEM", this + " not found in +" + moduleSignature);
        }
        return functionSignature;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.m_function.hashCode();
    }

    @Override
    public String innerToString() {
        return "call-module-function " + this.m_module + " " + this.m_function;
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_module = readObjectFileHelper.readString();
        this.m_function = readObjectFileHelper.readString();
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeString(this.m_module);
        writeObjectFileHelper.writeString(this.m_function);
    }
}

