/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.ClassType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import java.io.IOException;
import java.util.LinkedList;

public class MethodInvocationInstruction
extends NaryPrimopInstruction {
    protected String m_function;
    public Instruction m_object;

    public MethodInvocationInstruction() {
    }

    public MethodInvocationInstruction(String string2, Instruction instruction2, Instruction[] instructionArray) {
        super(instructionArray);
        this.m_function = string2;
        this.m_object = instruction2;
    }

    public Instruction getObject() {
        return this.m_object;
    }

    public String getFunction() {
        return this.m_function;
    }

    public void setFunction(String string2) {
        this.m_function = string2;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type type2 = this.m_object.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        type2 = type2.resolveType(typeEnvironment);
        if (type2 == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not infer the type of " + this.m_object), this);
        }
        if (!(type2 instanceof NamedType)) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_object + " is not an object"), this);
        }
        ClassType classType = (ClassType)((NamedType)type2).resolveName(typeEnvironment);
        if (classType == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_object + " is not a Xylem object"), this);
        }
        ClassType.Method method = classType.resolveMethod(this.m_function, typeEnvironment);
        if (method == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Class " + classType.getName() + " has no method named " + this.m_function), this);
        }
        Binding[] bindingArray = method.m_parameters;
        if (bindingArray.length != this.m_parameters.length) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Method " + this.m_function + " of class " + classType.getName() + " takes " + method.m_parameters.length + " parameters"), this);
        }
        for (int i = 0; i < bindingArray.length; ++i) {
            typeEnvironment.unify(bindingArray[i].getBindingType(), this.m_parameters[i].typeCheck(typeEnvironment, bindingEnvironment, linkedList), this);
        }
        return this.setCachedType(method.getReturnType());
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type type2 = this.m_object.getType(typeEnvironment, bindingEnvironment);
        type2 = type2.resolveType(typeEnvironment);
        ClassType classType = (ClassType)((NamedType)type2).resolveName(typeEnvironment);
        ClassType.Method method = classType.resolveMethod(this.m_function, typeEnvironment);
        return method.getReturnType();
    }

    @Override
    public Instruction getChildInstruction(int n2) {
        return n2 > 0 ? this.m_parameters[n2 - 1] : this.m_object;
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_parameters.length + 1;
    }

    @Override
    public void setChildInstruction(int n2, Instruction instruction2) {
        if (n2 == 0) {
            this.m_object = instruction2;
        } else {
            this.m_parameters[n2 - 1] = instruction2;
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] instructionArray = new Instruction[this.m_parameters.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        MethodInvocationInstruction methodInvocationInstruction = new MethodInvocationInstruction(this.m_function, this.m_object.cloneWithoutTypeInformation(), instructionArray);
        MethodInvocationInstruction.propagateInfo(this, methodInvocationInstruction);
        return methodInvocationInstruction;
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] instructionArray = (Instruction[])this.m_parameters.clone();
        MethodInvocationInstruction methodInvocationInstruction = new MethodInvocationInstruction(this.m_function, this.m_object, instructionArray);
        MethodInvocationInstruction.propagateInfo(this, methodInvocationInstruction);
        return methodInvocationInstruction;
    }

    @Override
    public String innerToString() {
        return "method-invoke " + this.m_function;
    }

    @Override
    public boolean equals(Object object2) {
        if (!super.equals(object2)) {
            return false;
        }
        MethodInvocationInstruction methodInvocationInstruction = (MethodInvocationInstruction)object2;
        return methodInvocationInstruction.m_function.equals(this.m_function);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.m_function.hashCode();
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        this.m_object = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_object, bindingEnvironment);
        super.generateReducedForm(reductionHelper, instructionArray, bindingEnvironment);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_object = readObjectFileHelper.readInstruction(bindingEnvironment);
        this.m_function = readObjectFileHelper.readString();
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeInstruction(this.m_object);
        writeObjectFileHelper.writeString(this.m_function);
    }
}

