/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.GenFork;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.dataflow.ForkInformation;
import com.ibm.xltxe.rnm1.xylem.instructions.ApplyInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Closure;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.LambdaType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoopInstruction
extends Instruction
implements ISpecialForm,
IBinding {
    private static final Logger s_logger = LoggerUtil.getLogger(LoopInstruction.class);
    private static final String s_className = LoopInstruction.class.getName();
    protected Binding[] m_parameters;
    protected Instruction[] m_initialValues;
    protected Instruction m_body;
    protected Object m_name;
    protected LambdaType m_bindingType;
    protected boolean m_isPure = true;
    private int m_stackFramePos;
    private int m_useCount;
    private ForkInformation _forkInformation;
    protected IBinding[] closureExternalBindings;
    protected IBinding[] closureInternalBindings;
    protected int stackFrameSize;

    public LoopInstruction() {
        assert (this.initBogusStackframePos());
    }

    public LoopInstruction(Object object2, Instruction instruction2, Binding[] bindingArray, Instruction[] instructionArray, boolean bl) {
        this.init(object2, instruction2, bindingArray, instructionArray, new TypeVariable(), bl);
    }

    public LoopInstruction(Object object2, Instruction instruction2, Binding[] bindingArray, Instruction[] instructionArray, Type type2, boolean bl) {
        this.init(object2, instruction2, bindingArray, instructionArray, type2, bl);
    }

    private void init(Object object2, Instruction instruction2, Binding[] bindingArray, Instruction[] instructionArray, Type type2, boolean bl) {
        this.m_name = object2;
        this.m_body = instruction2;
        this.m_initialValues = instructionArray;
        this.m_parameters = bindingArray;
        this.m_isPure = bl;
        if (bindingArray != null) {
            this.m_bindingType = new LambdaType(Binding.getTypeArrayFromBindingArray(bindingArray), type2, bl);
        }
        assert (this.initBogusStackframePos());
    }

    protected boolean initBogusStackframePos() {
        this.m_stackFramePos = -3333333;
        return true;
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_body.getType(typeEnvironment, bindingEnvironment);
    }

    public LambdaType getLambdaType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type[] typeArray = new Type[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            typeArray[i] = this.m_initialValues[i].getType(typeEnvironment, bindingEnvironment);
        }
        return new LambdaType(typeArray, this.m_body.getType(typeEnvironment, bindingEnvironment), this.m_isPure);
    }

    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function2);
        }
        Closure closure = new Closure(this.closureInternalBindings, null, function2, this.m_body, this.m_parameters, this.m_sourceFilename, this.m_sourceLineNumber, this.stackFrameSize);
        environment.bindInCurrentFrame(this, closure);
        int n2 = this.closureExternalBindings.length;
        Object[] objectArray = new Object[n2];
        boolean bl2 = false;
        for (int i = 0; i < n2; ++i) {
            IBinding iBinding = this.closureExternalBindings[i];
            Object object2 = environment.lookupBoundValue(iBinding);
            Type type2 = iBinding.getBindingType();
            if (type2 == null) {
                type2 = this.closureInternalBindings[i].getBindingType();
            }
            objectArray[i] = object2 = type2.evaluateVariableFork(object2);
        }
        closure.setClosureValues(objectArray);
        Object object3 = closure.evaluate(environment, function2, this.m_initialValues, iDebuggerInterceptor);
        return Debugger.leave(iDebuggerInterceptor, this, environment, function2, object3);
    }

    protected boolean markApplies(final Object object2) {
        final boolean[] blArray = new boolean[]{false};
        new Optimizer(){
            Set m_isTailPosition = new HashSet();
            Set m_skip = new HashSet();

            @Override
            protected Instruction optimizeStep(Instruction instruction2, Instruction instruction3, int n2) {
                if (this.m_skip.contains(instruction2)) {
                    return null;
                }
                if (this.m_isTailPosition.contains(instruction3) && instruction3 instanceof ISpecialForm && ((ISpecialForm)((Object)instruction3)).isChildInstructionInTailPosition(n2)) {
                    this.m_isTailPosition.add(instruction2);
                }
                if (instruction2 instanceof ApplyInstruction) {
                    Instruction instruction4 = ((ApplyInstruction)instruction2).m_lambda;
                    if (!(instruction4 instanceof IdentifierInstruction)) {
                        blArray[0] = true;
                        return instruction2;
                    }
                    if (!((IdentifierInstruction)instruction4).getVariable().equals(LoopInstruction.this.m_name)) {
                        return instruction2;
                    }
                    if (this.m_isTailPosition.contains(instruction2)) {
                        ((ApplyInstruction)instruction2).setTailLoopApply(object2, LoopInstruction.this.m_parameters);
                        this.m_skip.add(((ApplyInstruction)instruction2).m_lambda);
                        return instruction2;
                    }
                    ((ApplyInstruction)instruction2).setTailLoopApply(null, null);
                    blArray[0] = true;
                    return null;
                }
                if (instruction2 instanceof IdentifierInstruction && ((IdentifierInstruction)instruction2).getVariable().equals(LoopInstruction.this.m_name)) {
                    blArray[0] = true;
                }
                return instruction2;
            }

            @Override
            public Instruction optimize(Instruction instruction2) {
                this.m_isTailPosition.add(instruction2);
                return super.optimize(instruction2);
            }
        }.optimize(this.m_body);
        return blArray[0];
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, String string2, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        Object object2;
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        codeGenerationTracker.generateFreeBindings(this, fcgCodeGenHelper, fcgInstructionList, null, bl);
        boolean bl2 = this.markApplies(this.m_name);
        if (bl2) {
            object2 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Found problem during code generation for LoopInstruction (" + this + ")"});
            FFDCUtil.log(new XylemError((String)object2), this);
            s_logger.logp(Level.WARNING, s_className, "generateCode", (String)object2);
        }
        object2 = this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
        FcgType fcgType = ((Type)object2).getFCGType(fcgCodeGenHelper);
        if (!bl2) {
            fcgInstructionList.comment("generating LoopInstruction as just loop\n");
            codeGenerationTracker.registerExtantBinding(this, "__should_never_be_used__");
            String[] stringArray = new String[this.m_parameters.length];
            FcgType[] fcgTypeArray = new FcgType[this.m_parameters.length];
            FcgVariable[] fcgVariableArray = new FcgVariable[this.m_parameters.length];
            for (int i = 0; i < this.m_parameters.length; ++i) {
                stringArray[i] = fcgCodeGenHelper.generateNewLocalVariableName();
                fcgTypeArray[i] = this.m_initialValues[i].generateCode(fcgCodeGenHelper, codeGenerationTracker, string2, bl, fcgInstructionList, genFork);
                fcgVariableArray[i] = fcgInstructionList.defineVar(fcgTypeArray[i], stringArray[i], true);
                codeGenerationTracker.registerExtantBinding(this.m_parameters[i], stringArray[i]);
            }
            String string3 = "__tailrecurse_loop_" + this.m_name + "_result__";
            FcgVariable fcgVariable = fcgInstructionList.defineVar(fcgType, string3, false);
            fcgInstructionList.beginConditionalLoop("__tailrecurse_loop_" + this.m_name + "__", 0);
            this.m_body.generateCode(fcgCodeGenHelper, codeGenerationTracker, null, false, fcgInstructionList, genFork);
            fcgInstructionList.storeVar(fcgVariable);
            fcgInstructionList.breakFromLoop();
            fcgInstructionList.comment("don't actually loop, unless explicitly 'continue'");
            fcgInstructionList.endConditionalLoop();
            fcgInstructionList.comment("end the loop's tail recursion loop for __tailrecurse_loop_" + this.m_name + "__");
            fcgInstructionList.loadVar(fcgVariable);
            return fcgType;
        }
        String string4 = fcgCodeGenHelper.generateNewLocalVariableName(string2);
        LambdaType lambdaType = this.getLambdaType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
        FcgType fcgType2 = lambdaType.getFCGType(fcgCodeGenHelper);
        Type type2 = lambdaType.getReturnType().resolveType(typeEnvironment);
        String string5 = lambdaType.getImplementationName(fcgCodeGenHelper);
        StringBuffer stringBuffer = new StringBuffer();
        CodeGenerationTracker codeGenerationTracker2 = codeGenerationTracker.cloneBranch();
        fcgInstructionList.comment("generating LoopInstruction normally as lambda");
        fcgInstructionList.createObjectExpr(fcgType2, 0);
        FcgVariable fcgVariable = fcgInstructionList.defineVar(fcgType2, string4, true);
        codeGenerationTracker.registerExtantBinding(this, string4);
        fcgInstructionList.beginConditionalLoop("__tailrecurse_loop_" + this.m_name + "__", 0);
        this.m_body.generateCode(fcgCodeGenHelper, codeGenerationTracker, null, false, fcgInstructionList, genFork);
        fcgInstructionList.returnInstruction(fcgType);
        fcgInstructionList.endConditionalLoop();
        fcgInstructionList.comment("end the loop's tail recursion loop for __tailrecurse_loop_" + this.m_name + "__");
        for (int i = 0; i < this.m_parameters.length; ++i) {
            codeGenerationTracker.generateConventionally(this.m_initialValues[i], fcgCodeGenHelper, fcgInstructionList);
        }
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGenHelper.getClassReferenceType(string4);
        return fcgInstructionList.invokeClassMethod(fcgClassReferenceType, "invoke", fcgType, this.m_parameters.length);
    }

    @Override
    public Instruction assignNewNames(Map map2, INewNameGenerator iNewNameGenerator) {
        Binding[] bindingArray = new Binding[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Object object2 = iNewNameGenerator.getNewName();
            map2.put(this.m_parameters[i].getName(), new IdentifierInstruction(object2));
            bindingArray[i] = new Binding(object2, this.m_parameters[i].getBindingType(), this);
        }
        Instruction[] instructionArray = new Instruction[this.m_parameters.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_initialValues[i].assignNewNames(map2, iNewNameGenerator);
        }
        Object object3 = iNewNameGenerator.getNewName();
        map2.put(this.m_name, new IdentifierInstruction(object3));
        return new LoopInstruction(object3, this.m_body.assignNewNames(map2, iNewNameGenerator), bindingArray, instructionArray, this.m_bindingType.getReturnType(), this.m_isPure);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] instructionArray = new Instruction[this.m_parameters.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_initialValues[i].cloneWithoutTypeInformation();
        }
        LoopInstruction loopInstruction = new LoopInstruction(this.m_name, this.m_body.cloneWithoutTypeInformation(), null, instructionArray, this.m_bindingType.getReturnType(), this.m_isPure);
        Binding[] bindingArray = new Binding[this.m_parameters.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            bindingArray[i] = new Binding(this.m_parameters[i].getName(), this.m_parameters[i].getBindingType(), loopInstruction);
        }
        loopInstruction.setParameters(bindingArray, this.m_bindingType.getReturnType(), this.m_isPure);
        LoopInstruction.propagateInfo(this, loopInstruction);
        return loopInstruction;
    }

    @Override
    public Instruction cloneShallow() {
        Binding[] bindingArray = new Binding[this.m_parameters.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            bindingArray[i] = new Binding(this.m_parameters[i].getName(), this.m_parameters[i].getBindingType(), this);
        }
        LoopInstruction loopInstruction = new LoopInstruction(this.m_name, this.m_body, bindingArray, (Instruction[])this.m_initialValues.clone(), this.m_bindingType.getReturnType(), this.m_isPure);
        LoopInstruction.propagateInfo(this, loopInstruction);
        return loopInstruction;
    }

    public Instruction getBody() {
        return this.m_body;
    }

    public void setBody(Instruction instruction2) {
        this.m_body = instruction2;
    }

    private void setParameters(Binding[] bindingArray, Type type2, boolean bl) {
        this.m_parameters = bindingArray;
        this.m_bindingType = new LambdaType(Binding.getTypeArrayFromBindingArray(bindingArray), type2, bl);
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n2) {
        prettyPrinter.printFormOpen("loop", n2);
        prettyPrinter.printIdentifier(this.m_name, n2);
        prettyPrinter.print(" (");
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Binding binding = this.m_parameters[i];
            Instruction instruction2 = this.m_initialValues[i];
            prettyPrinter.printFormOpenIdentifier(binding.getName(), n2 + 2);
            instruction2.toString(prettyPrinter, n2 + 3);
            prettyPrinter.printFormClose(n2 + 2);
        }
        prettyPrinter.printFormClose(n2);
        this.m_body.toString(prettyPrinter, n2 + 1);
        prettyPrinter.printFormClose(n2);
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type[] typeArray = new Type[this.m_parameters.length];
        BindingEnvironment bindingEnvironment2 = new BindingEnvironment(bindingEnvironment);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            typeEnvironment.unify(this.m_bindingType.getElementTypes()[i], this.m_initialValues[i].typeCheck(typeEnvironment, bindingEnvironment, linkedList), this);
            bindingEnvironment2.setVariableBinding(this.m_parameters[i]);
        }
        bindingEnvironment2.setVariableBinding(this);
        Type type2 = this.m_body.typeCheck(typeEnvironment, bindingEnvironment2, linkedList);
        typeEnvironment.unify(this.m_bindingType.getReturnType(), type2, this);
        if (this.closureExternalBindings != null) {
            Type[] typeArray2 = new Type[this.closureExternalBindings.length];
            for (int i = 0; i < this.closureExternalBindings.length; ++i) {
                Type type3 = this.closureExternalBindings[i].getBindingType(typeEnvironment, bindingEnvironment2);
                assert (type3 != null);
                assert (this.closureExternalBindings[i].getBindingType() != null);
            }
        }
        return this.setCachedType(type2);
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        int n2;
        ReductionHelper reductionHelper2 = (ReductionHelper)reductionHelper.clone();
        reductionHelper2.upgradeBinding(this);
        bindingEnvironment.setVariableBinding(this);
        this.m_bindingEnvironment = null;
        for (n2 = 0; n2 < this.m_parameters.length; ++n2) {
            reductionHelper2.upgradeBinding(this.m_parameters[n2]);
            bindingEnvironment.setVariableBinding(this.m_parameters[n2]);
        }
        for (n2 = 0; n2 < this.m_initialValues.length; ++n2) {
            this.m_initialValues[n2] = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_initialValues[n2], bindingEnvironment);
        }
        this.m_body = reductionHelper2.reduce(this.m_body, bindingEnvironment);
        instructionArray[0] = this;
    }

    @Override
    public int getChildInstructionCount() {
        return 1 + this.m_initialValues.length;
    }

    @Override
    public Instruction getChildInstruction(int n2) {
        return n2 == 0 ? this.m_body : this.m_initialValues[n2 - 1];
    }

    @Override
    public void setChildInstruction(int n2, Instruction instruction2) {
        if (n2 == 0) {
            this.m_body = instruction2;
        } else {
            this.m_initialValues[n2 - 1] = instruction2;
        }
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set2, BindingEnvironment bindingEnvironment) {
        super.accumulateNonLiteralFreeBindings(set2, bindingEnvironment);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            set2.remove(this.m_parameters[i]);
        }
        set2.remove(this);
    }

    @Override
    public void accumulateFreeBindings(Set set2, BindingEnvironment bindingEnvironment) {
        super.accumulateFreeBindings(set2, bindingEnvironment);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            set2.remove(this.m_parameters[i]);
        }
        set2.remove(this);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        this.m_name = readObjectFileHelper.readBindingName();
        this.m_body = readObjectFileHelper.readInstruction(bindingEnvironment);
        this.m_parameters = readObjectFileHelper.readTypeSpecificBindingSet(this);
        this.m_bindingType = (LambdaType)readObjectFileHelper.readType();
        this.m_isPure = readObjectFileHelper.readBoolean();
        int n2 = this.m_parameters.length;
        this.m_initialValues = new Instruction[n2];
        for (int i = 0; i < n2; ++i) {
            this.m_initialValues[i] = readObjectFileHelper.readInstruction(bindingEnvironment);
        }
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeBindingName(this.m_name);
        writeObjectFileHelper.writeInstruction(this.m_body);
        writeObjectFileHelper.writeTypeSpecificBindingSet(this.m_parameters);
        writeObjectFileHelper.writeType(this.m_bindingType);
        writeObjectFileHelper.writeBoolean(this.m_isPure);
        int n2 = this.m_initialValues.length;
        for (int i = 0; i < n2; ++i) {
            writeObjectFileHelper.writeInstruction(this.m_initialValues[i]);
        }
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        Type[] typeArray = new Type[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            typeArray[i] = this.m_parameters[i].getBindingType();
            bindingEnvironment.setVariableBinding(this.m_parameters[i]);
        }
        bindingEnvironment.setVariableBinding(this);
        super.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
    }

    @Override
    public Type getTypeParameter(int n2) {
        if (0 == n2) {
            return this.m_bindingType.getReturnType();
        }
        return this.m_parameters[--n2].getBindingType();
    }

    @Override
    public int getTypeParameterCount() {
        return this.m_parameters.length + 1;
    }

    @Override
    public void setTypeParameter(int n2, Type type2) {
        if (0 == n2) {
            this.m_bindingType.setReturnType(type2);
            return;
        }
        this.m_parameters[--n2].setType(type2);
    }

    @Override
    public boolean isChildInstructionBody(int n2) {
        return true;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int n2) {
        if (this.m_parameters == null) {
            return null;
        }
        IBinding[] iBindingArray = new IBinding[this.m_parameters.length + 1];
        System.arraycopy(this.m_parameters, 0, iBindingArray, 1, this.m_parameters.length);
        iBindingArray[0] = this;
        return iBindingArray;
    }

    public List getBindings() {
        ArrayList<IBinding> arrayList = new ArrayList<IBinding>();
        arrayList.addAll(Arrays.asList(this.m_parameters));
        arrayList.add(this);
        return arrayList;
    }

    public Binding[] getParameters() {
        return this.m_parameters;
    }

    @Override
    public boolean equals(Object object2) {
        if (!super.equals(object2)) {
            return false;
        }
        LoopInstruction loopInstruction = (LoopInstruction)object2;
        int n2 = this.m_parameters.length;
        if (loopInstruction.m_parameters.length != n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (loopInstruction.m_parameters[i].getName().equals(this.m_parameters[i].getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isChildInstructionInTailPosition(int n2) {
        return false;
    }

    @Override
    public Type getBindingType() {
        return this.m_bindingType;
    }

    @Override
    public Type getBindingType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_bindingType;
    }

    @Override
    public int compareTo(Object object2) {
        return Binding.compare(this, object2);
    }

    @Override
    public LetInstruction getLet() {
        return null;
    }

    @Override
    public Object getName() {
        return this.m_name;
    }

    @Override
    public ISpecialForm getOrigin() {
        return this;
    }

    @Override
    public void setName(Object object2) {
        this.m_name = object2;
    }

    @Override
    public int getVariableUse() {
        return this.m_useCount;
    }

    @Override
    public void incrementVariableUse() {
        if (this.m_useCount == 0) {
            this.m_useCount = 1;
        } else if (this.m_useCount == 1 || this.m_useCount == 2) {
            this.m_useCount = 3;
        }
    }

    @Override
    public void passingIterator() {
        if (this.m_useCount == 0) {
            this.m_useCount = 2;
        }
    }

    @Override
    public int getStackFramePos() {
        return this.m_stackFramePos;
    }

    @Override
    public void setStackFramePos(int n2) {
        this.m_stackFramePos = n2;
    }

    @Override
    public ForkInformation getForkInformation() {
        return this._forkInformation;
    }

    @Override
    public void setForkInformation(ForkInformation forkInformation) {
        this._forkInformation = forkInformation;
    }

    public IBinding[] getFreeBindings() {
        return this.closureExternalBindings;
    }

    public void setFreeBindings(Set<IBinding> set2, Function function2) {
        this.closureExternalBindings = new IBinding[set2.size()];
        this.closureInternalBindings = new IBinding[set2.size()];
        int n2 = 0;
        Iterator<IBinding> iterator = set2.iterator();
        while (iterator.hasNext()) {
            IBinding iBinding;
            this.closureExternalBindings[n2] = iBinding = iterator.next();
            Type type2 = iBinding.getBindingType();
            if (type2 == null) {
                type2 = this.extractType(iBinding, function2);
            }
            assert (type2 != null);
            Binding binding = new Binding(iBinding.getName(), type2);
            binding.setStackFramePos(n2 + this.m_parameters.length);
            this.closureInternalBindings[n2] = binding;
            ++n2;
        }
    }

    private Type extractType(IBinding iBinding, Function function2) {
        BindingEnvironment bindingEnvironment = this.getBindingEnvironment();
        if (bindingEnvironment == null) {
            bindingEnvironment = function2.getBindingEnvironment();
        }
        assert (bindingEnvironment != null);
        TypeEnvironment typeEnvironment = function2.getTypeEnvironment();
        assert (typeEnvironment != null);
        Type type2 = iBinding.getBindingType(typeEnvironment, bindingEnvironment);
        return type2;
    }

    public IBinding[] getClosureInternalBindings() {
        return this.closureInternalBindings;
    }

    public int getStackFrameSize() {
        return this.stackFrameSize;
    }

    public void setStackFrameSize(int n2) {
        this.stackFrameSize = n2;
    }
}

