/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.GenFork;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.CharStreamToJavaStringInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.StringStream;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.ResourceBundle;

public class LocalizeMessageInstruction
extends NaryPrimopInstruction {
    Instruction m_messageFile;
    Instruction m_messageID;

    public LocalizeMessageInstruction() {
    }

    public LocalizeMessageInstruction(Instruction instruction2, Instruction instruction3, Instruction[] instructionArray) {
        super(instructionArray);
        this.m_messageFile = instruction2;
        this.m_messageID = instruction3;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return CharType.s_charType.getStreamType();
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature moduleSignature) {
        return CharType.s_charType.getStreamType();
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        super.generateReducedForm(reductionHelper, instructionArray, bindingEnvironment);
        this.m_messageFile = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_messageFile, bindingEnvironment);
        this.m_messageID = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_messageID, bindingEnvironment);
        instructionArray[0] = this;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        typeEnvironment.unify(this.m_messageFile.typeCheck(typeEnvironment, bindingEnvironment, linkedList), CharType.s_charType.getStreamType(), this);
        typeEnvironment.unify(this.m_messageID.typeCheck(typeEnvironment, bindingEnvironment, linkedList), CharType.s_charType.getStreamType(), this);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            typeEnvironment.unify(this.m_parameters[i].typeCheck(typeEnvironment, bindingEnvironment, linkedList), CharType.s_charType.getStreamType(), this);
        }
        return this.setCachedType(CharType.s_charType.getStreamType());
    }

    @Override
    public Instruction getChildInstruction(int n2) {
        switch (n2) {
            case 0: {
                return this.m_messageFile;
            }
            case 1: {
                return this.m_messageID;
            }
        }
        return this.m_parameters[n2 - 2];
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_parameters.length + 2;
    }

    @Override
    public void setChildInstruction(int n2, Instruction instruction2) {
        switch (n2) {
            case 0: {
                this.m_messageFile = instruction2;
                break;
            }
            case 1: {
                this.m_messageID = instruction2;
                break;
            }
            default: {
                this.m_parameters[n2 - 2] = instruction2;
            }
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] instructionArray = new Instruction[this.m_parameters.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        LocalizeMessageInstruction localizeMessageInstruction = new LocalizeMessageInstruction(this.m_messageFile.cloneWithoutTypeInformation(), this.m_messageID.cloneWithoutTypeInformation(), instructionArray);
        LocalizeMessageInstruction.propagateInfo(this, localizeMessageInstruction);
        return localizeMessageInstruction;
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] instructionArray = (Instruction[])this.m_parameters.clone();
        LocalizeMessageInstruction localizeMessageInstruction = new LocalizeMessageInstruction(this.m_messageFile, this.m_messageID, instructionArray);
        LocalizeMessageInstruction.propagateInfo(this, localizeMessageInstruction);
        return localizeMessageInstruction;
    }

    @Override
    public String innerToString() {
        return "localize-message";
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, String string2, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGenHelper.getClassReferenceType("java.util.ResourceBundle");
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGenHelper.getClassReferenceType("java.text.MessageFormat");
        CharStreamToJavaStringInstruction.generateJavaString(fcgCodeGenHelper, codeGenerationTracker, this.m_messageFile, null, fcgInstructionList);
        fcgInstructionList.invokeClassMethod(fcgClassReferenceType, "getBundle", (FcgType)fcgClassReferenceType, 1);
        CharStreamToJavaStringInstruction.generateJavaString(fcgCodeGenHelper, codeGenerationTracker, this.m_messageID, null, fcgInstructionList);
        fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType, "getString", (FcgType)FcgType.STRING, 1);
        if (this.m_parameters.length != 0) {
            for (int i = 0; i < this.m_parameters.length; ++i) {
                CharStreamToJavaStringInstruction.generateJavaString(fcgCodeGenHelper, codeGenerationTracker, this.m_parameters[i], string2, fcgInstructionList);
            }
            fcgInstructionList.loadLiteral(this.m_parameters.length);
            fcgInstructionList.createArrayExpr(FcgType.OBJECT, true);
            fcgInstructionList.invokeClassMethod(fcgClassReferenceType2, "format", (FcgType)FcgType.STRING, 2);
        }
        fcgInstructionList.convertExpr(FcgType.STRING, FcgType.CHAR_ARRAY);
        return FcgType.CHAR_ARRAY;
    }

    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        IStream iStream;
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function2);
        }
        IStream iStream2 = (IStream)this.m_messageFile.evaluate(environment, function2, iDebuggerInterceptor, false);
        IStream iStream3 = (IStream)this.m_messageID.evaluate(environment, function2, iDebuggerInterceptor, false);
        String string2 = new String(iStream2.toCharArray());
        String string3 = new String(iStream3.toCharArray());
        String[] stringArray = new String[this.m_parameters.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string4;
            iStream = (IStream)this.m_parameters[i].evaluate(environment, function2, iDebuggerInterceptor, false);
            stringArray[i] = string4 = new String(iStream.toCharArray());
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string2);
        iStream = stringArray.length == 0 ? new StringStream(resourceBundle.getString(string3)) : new StringStream(MessageFormat.format(resourceBundle.getString(string3), stringArray));
        return Debugger.leave(iDebuggerInterceptor, this, environment, function2, (Object)iStream);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_messageFile = readObjectFileHelper.readInstruction(bindingEnvironment);
        this.m_messageID = readObjectFileHelper.readInstruction(bindingEnvironment);
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeInstruction(this.m_messageFile);
        writeObjectFileHelper.writeInstruction(this.m_messageID);
    }
}

