/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.IMatchDestructable;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.GenFork;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PrimitiveEqualityInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.BigIntegerType;
import com.ibm.xltxe.rnm1.xylem.types.BooleanType;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.DecimalType;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.FloatType;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.LongType;
import com.ibm.xltxe.rnm1.xylem.types.NullableType;
import com.ibm.xltxe.rnm1.xylem.types.ShortType;
import com.ibm.xltxe.rnm1.xylem.types.UnitType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedList;

public final class LiteralInstruction
extends Instruction
implements IMatchDestructable {
    protected Object m_value;
    protected Type m_type;

    public LiteralInstruction() {
    }

    @Override
    public int hashCode() {
        return this.m_value == null ? 0 : this.m_value.hashCode();
    }

    public LiteralInstruction(Type type2, Object object2) {
        this.setCachedType(type2);
        this.m_value = object2;
        this.m_type = type2;
    }

    public Object getValue() {
        return this.m_value;
    }

    public Type getType() {
        return this.m_type;
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_type;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature moduleSignature) {
        return this.m_type;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        this.m_bindingEnvironment = null;
        this.m_hasBeenTypechecked = true;
        return this.m_type;
    }

    @Override
    public boolean equals(Object object2) {
        if (!super.equals(object2)) {
            return false;
        }
        LiteralInstruction literalInstruction = (LiteralInstruction)object2;
        if (!literalInstruction.m_type.equals(this.m_type)) {
            return false;
        }
        if (this.m_value == null) {
            return literalInstruction.m_value == null;
        }
        return this.m_value.equals(literalInstruction.m_value);
    }

    @Override
    public Type getTypeParameter(int n2) {
        if (n2 == 0) {
            return this.m_type;
        }
        return null;
    }

    @Override
    public int getTypeParameterCount() {
        return 1;
    }

    @Override
    public void setTypeParameter(int n2, Type type2) {
        if (n2 == 0) {
            this.m_type = type2;
        }
    }

    public static final LiteralInstruction numberLiteral(String string2) {
        if (string2.endsWith("f")) {
            return LiteralInstruction.floatLiteral(Float.parseFloat(string2.substring(0, string2.length() - 1)));
        }
        if (string2.endsWith("d")) {
            return LiteralInstruction.doubleLiteral(Double.parseDouble(string2.substring(0, string2.length() - 1)));
        }
        if (string2.endsWith("l")) {
            return LiteralInstruction.longLiteral(Long.parseLong(string2.substring(0, string2.length() - 1)));
        }
        if (string2.startsWith("f")) {
            if (string2.equals("floatNaN")) {
                return LiteralInstruction.floatLiteral(Float.NaN);
            }
            if (string2.equals("floatPosINF")) {
                return LiteralInstruction.floatLiteral(Float.POSITIVE_INFINITY);
            }
            if (string2.equals("floatNegINF")) {
                return LiteralInstruction.floatLiteral(Float.NEGATIVE_INFINITY);
            }
            return null;
        }
        if (string2.startsWith("d")) {
            if (string2.equals("doubleNaN")) {
                return LiteralInstruction.doubleLiteral(Double.NaN);
            }
            if (string2.equals("doublePosINF")) {
                return LiteralInstruction.doubleLiteral(Double.POSITIVE_INFINITY);
            }
            if (string2.equals("doubleNegINF")) {
                return LiteralInstruction.doubleLiteral(Double.NEGATIVE_INFINITY);
            }
            return null;
        }
        if (string2.indexOf(46) == -1) {
            return LiteralInstruction.integerLiteral(Integer.parseInt(string2));
        }
        return LiteralInstruction.doubleLiteral(Double.parseDouble(string2));
    }

    public static final LiteralInstruction integerLiteral(int n2) {
        return new LiteralInstruction(IntType.s_intType, new Integer(n2));
    }

    public static final LiteralInstruction longLiteral(long l) {
        return new LiteralInstruction(LongType.s_longType, new Long(l));
    }

    public static final LiteralInstruction shortLiteral(long l) {
        return new LiteralInstruction(ShortType.s_shortType, new Long(l));
    }

    public static final LiteralInstruction doubleLiteral(double d) {
        return new LiteralInstruction(DoubleType.s_doubleType, new Double(d));
    }

    public static final LiteralInstruction floatLiteral(float f2) {
        return new LiteralInstruction(FloatType.s_floatType, new Float(f2));
    }

    public static final LiteralInstruction charLiteral(char c) {
        return new LiteralInstruction(CharType.s_charType, new Character(c));
    }

    public static final LiteralInstruction booleanTrueLiteral() {
        return new LiteralInstruction(BooleanType.s_booleanType, Boolean.TRUE);
    }

    public static final LiteralInstruction unitLiteral() {
        return new LiteralInstruction(UnitType.s_unitType, new Integer(0));
    }

    public static final LiteralInstruction booleanLiteral(boolean bl) {
        return bl ? LiteralInstruction.booleanTrueLiteral() : LiteralInstruction.booleanFalseLiteral();
    }

    public static final LiteralInstruction booleanFalseLiteral() {
        return new LiteralInstruction(BooleanType.s_booleanType, Boolean.FALSE);
    }

    public static final LiteralInstruction decimalLiteral(BigDecimal bigDecimal) {
        return new LiteralInstruction(DecimalType.s_decimalType, bigDecimal);
    }

    public static final LiteralInstruction bigIntegerLiteral(BigInteger bigInteger) {
        return new LiteralInstruction(BigIntegerType.s_bigIntegerType, bigInteger);
    }

    public static final LiteralInstruction nullLiteral(Type type2) {
        if (type2 == null || !type2.isFullySpecified()) {
            throw new Error("Dead literal must be fully typed, but got " + type2);
        }
        return new LiteralInstruction(type2, null);
    }

    public static final LiteralInstruction nullableLiteral(Type type2) {
        if (type2 == null || !type2.isFullySpecified()) {
            throw new Error("Dead literal must be fully typed, but got " + type2);
        }
        return new LiteralInstruction(new NullableType(type2), null);
    }

    public void generateBeginSwitchCase(FcgInstructionList fcgInstructionList) {
        Object object2 = this.getValue();
        if (object2 instanceof Number) {
            fcgInstructionList.beginSwitchCaseBlock(((Number)object2).intValue());
        } else if (object2 instanceof Character) {
            fcgInstructionList.beginSwitchCaseBlock(((Character)object2).charValue());
        } else {
            throw new XylemError("ERR_SYSTEM", "Invalid switch type");
        }
    }

    public static final Integer getInteger(Instruction instruction2) {
        if (!(instruction2 instanceof LiteralInstruction)) {
            return null;
        }
        Object object2 = ((LiteralInstruction)instruction2).getValue();
        if (!(object2 instanceof Integer)) {
            return null;
        }
        return (Integer)object2;
    }

    @Override
    public boolean isStatic(BindingEnvironment bindingEnvironment) {
        return true;
    }

    public static String escape(String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        block8: for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block8;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block8;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block8;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block8;
                }
                default: {
                    if (c >= '\u0080') {
                        stringBuffer.append("\\u");
                        String string3 = Integer.toHexString(c);
                        stringBuffer.append("000".substring(string3.length() - 1));
                        stringBuffer.append(string3);
                        continue block8;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return this;
    }

    @Override
    public Instruction cloneShallow() {
        return this;
    }

    public boolean isReducedExpression() {
        return true;
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        instructionArray[0] = this;
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n2) {
        String string2 = this.m_value == null ? (this.m_type instanceof INumericalType ? "((" + this.m_type + ") 0)" : (this.m_type instanceof BooleanType ? "false" : "(java-null " + this.m_type.prettyPrint() + ")")) : (this.m_value.equals(new Double(Double.NaN)) ? "doubleNaN" : (this.m_value.equals(new Float(Float.NaN)) ? "floatNaN" : (this.m_value.equals(new Float(Float.NEGATIVE_INFINITY)) ? "floatNegINF" : (this.m_value.equals(new Float(Float.POSITIVE_INFINITY)) ? "floatPosINF" : (this.m_value.equals(new Double(Double.NEGATIVE_INFINITY)) ? "doubleNegINF" : (this.m_value.equals(new Double(Double.POSITIVE_INFINITY)) ? "doublePosINF" : (this.m_type instanceof UnitType ? "unit" : (this.m_value instanceof Character ? "'" + LiteralInstruction.escape(this.m_value.toString()) + "'" : (this.m_type.equals(DecimalType.s_decimalType) ? "new java.math.BigDecimal(\"" + this.m_value.toString() + "\")" : this.m_value.toString())))))))));
        prettyPrinter.printToken(string2, n2);
    }

    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor && iDebuggerInterceptor.getVerbosityLevel() == 0) {
            iDebuggerInterceptor.quietEnter(this, environment, function2);
        }
        Object object2 = this.m_value;
        if (null != iDebuggerInterceptor && iDebuggerInterceptor.getVerbosityLevel() == 0) {
            return Debugger.quietLeave(iDebuggerInterceptor, this, environment, function2, object2);
        }
        return object2;
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_type = readObjectFileHelper.readType();
        this.m_value = readObjectFileHelper.readObject();
        this.setCachedType(this.m_type);
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeType(this.m_type);
        writeObjectFileHelper.writeObject(this.m_value);
    }

    @Override
    public Type typeCheckDestruction(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) throws TypeCheckException {
        return this.m_type;
    }

    @Override
    public Instruction desugarDestruction(Instruction instruction2, ReductionHelper reductionHelper, IMatchDestructable.Generator generator, IMatchDestructable.Generator generator2, BindingEnvironment bindingEnvironment) {
        Object object2 = reductionHelper.generateReducedIdentifier("");
        LetInstruction letInstruction = new LetInstruction(object2, new PrimitiveEqualityInstruction(instruction2, this), new ChooseInstruction(new IdentifierInstruction(object2), generator.generate(), generator2.generate()));
        return letInstruction;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, String string2, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        FcgType fcgType = this.loadConstant(fcgCodeGenHelper, fcgInstructionList, this.m_value);
        return fcgType;
    }

    public FcgType loadConstant(FcgCodeGenHelper fcgCodeGenHelper, FcgInstructionList fcgInstructionList, Object object2) {
        FcgType fcgType;
        if (object2 == null) {
            fcgType = this.m_type.getFCGType(fcgCodeGenHelper);
            fcgInstructionList.loadNull();
            fcgInstructionList.convertExpr(FcgType.OBJECT, fcgType);
        } else if (object2 instanceof BigDecimal) {
            String string2 = ((BigDecimal)object2).toString();
            fcgInstructionList.loadLiteral(string2);
            fcgType = fcgCodeGenHelper.getClassReferenceType(BigDecimal.class.getName());
            fcgInstructionList.createObjectExpr(fcgType, 1);
        } else if (object2 instanceof Integer) {
            Integer n2 = (Integer)object2;
            fcgType = fcgInstructionList.loadLiteral(n2);
        } else if (object2 instanceof Long) {
            Long l = (Long)object2;
            fcgType = fcgInstructionList.loadLiteral(l);
        } else if (object2 instanceof Double) {
            Double d = (Double)object2;
            fcgType = fcgInstructionList.loadLiteral(d);
        } else if (object2 instanceof Float) {
            Float f2 = (Float)object2;
            fcgType = fcgInstructionList.loadLiteral(f2.floatValue());
        } else if (object2 instanceof String) {
            fcgType = fcgInstructionList.loadLiteral((String)object2);
        } else if (object2 instanceof Character) {
            fcgType = fcgInstructionList.loadLiteral(((Character)object2).charValue());
        } else if (object2 instanceof Boolean) {
            fcgType = fcgInstructionList.loadLiteral((Boolean)object2);
        } else if (object2 instanceof BigInteger) {
            fcgType = fcgInstructionList.loadLiteral((BigInteger)object2);
        } else {
            throw new UnsupportedOperationException();
        }
        return fcgType;
    }

    @Override
    public Instruction cloneReduced() {
        return this;
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
    }

    public static class KnownValue {
        Object m_literalValue = null;
        Object[] m_literalArray = null;

        public KnownValue(Object object2) {
            this.m_literalValue = object2;
        }

        public KnownValue(LiteralInstruction literalInstruction) {
            this.m_literalValue = literalInstruction.getValue();
        }

        public KnownValue(Object[] objectArray) {
            this.m_literalArray = objectArray;
        }

        public KnownValue(LiteralInstruction[] literalInstructionArray) {
            this.m_literalArray = new Object[literalInstructionArray.length];
            for (int i = 0; i < literalInstructionArray.length; ++i) {
                this.m_literalArray[i] = literalInstructionArray[i].getValue();
            }
        }

        public boolean equals(Object object2) {
            if (!(object2 instanceof KnownValue)) {
                return false;
            }
            KnownValue knownValue = (KnownValue)object2;
            if (null == this.m_literalValue) {
                if (null != knownValue.m_literalValue) {
                    return false;
                }
                if (this.m_literalArray.length != knownValue.m_literalArray.length) {
                    return false;
                }
                for (int i = 0; i < this.m_literalArray.length; ++i) {
                    if (this.m_literalArray[i].equals(knownValue.m_literalArray[i])) continue;
                    return false;
                }
                return true;
            }
            if (null == knownValue.m_literalValue) {
                return false;
            }
            return this.m_literalValue.equals(knownValue.m_literalValue);
        }

        public String getStringValue() {
            if (this.m_literalArray != null) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < this.m_literalArray.length; ++i) {
                    Object object2 = this.m_literalArray[i];
                    if (!(object2 instanceof Character)) {
                        return null;
                    }
                    stringBuffer.append(((Character)object2).charValue());
                }
                return stringBuffer.toString();
            }
            return null;
        }
    }
}

