/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgAttrs;
import com.ibm.xltxe.rnm1.fcg.FcgClassGen;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgMethodGen;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.ClosureGenerationUtilities;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.GenFork;
import com.ibm.xltxe.rnm1.xylem.codegen.LambdaFunctionGenerationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.LazyAdditionGenerationState;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Closure;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.LambdaType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LambdaInstruction
extends Instruction
implements ISpecialForm {
    protected Binding[] m_parameters;
    protected Instruction m_body;
    protected boolean m_isPure = true;
    protected IBinding[] closureExternalBindings;
    protected IBinding[] closureInternalBindings;
    protected int stackFrameSize;

    public LambdaInstruction() {
    }

    public LambdaInstruction(Instruction instruction2, Binding[] bindingArray, boolean bl) {
        this.m_body = instruction2;
        this.m_parameters = bindingArray;
        this.m_isPure = bl;
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type[] typeArray = new Type[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            typeArray[i] = this.m_parameters[i].getBindingType();
        }
        return new LambdaType(typeArray, this.m_body.getType(typeEnvironment, bindingEnvironment), this.m_isPure);
    }

    protected LambdaFunctionGenerationStyle computeGenerationStyle(FcgCodeGenHelper fcgCodeGenHelper, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, CodeGenerationTracker codeGenerationTracker, HashSet hashSet, FcgInstructionList fcgInstructionList) {
        this.m_body.accumulateFreeBindings(hashSet, bindingEnvironment);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            hashSet.remove(this.m_parameters[i]);
        }
        FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)this.m_body;
        LambdaType lambdaType = (LambdaType)this.getType(typeEnvironment, bindingEnvironment).resolveType(typeEnvironment);
        Function function2 = typeEnvironment.getModule().getFunction(functionCallInstruction.getFunction());
        IBinding[] iBindingArray = new IBinding[this.m_parameters.length];
        LiteralInstruction[] literalInstructionArray = new LiteralInstruction[functionCallInstruction.m_parameters.length];
        List list = ClosureGenerationUtilities.determineClosureFunctionCallFreeBindings(functionCallInstruction, hashSet, typeEnvironment, bindingEnvironment, codeGenerationTracker, fcgCodeGenHelper, fcgInstructionList);
        LambdaFunctionGenerationStyle lambdaFunctionGenerationStyle = new LambdaFunctionGenerationStyle(function2, list, lambdaType, iBindingArray, literalInstructionArray);
        for (int i = 0; i < functionCallInstruction.m_parameters.length; ++i) {
            Instruction instruction2 = functionCallInstruction.m_parameters[i];
            if (instruction2 instanceof IdentifierInstruction) {
                IBinding iBinding = ((IdentifierInstruction)instruction2).getBinding(bindingEnvironment);
                Binding binding = function2.m_parameters[i];
                for (int j = 0; j < this.m_parameters.length; ++j) {
                    if (iBinding != this.m_parameters[j]) continue;
                    iBindingArray[j] = binding;
                }
                continue;
            }
            literalInstructionArray[i] = (LiteralInstruction)instruction2;
        }
        return lambdaFunctionGenerationStyle;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, String string2, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        FcgType fcgType;
        Object object22;
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        BindingEnvironment bindingEnvironment = codeGenerationTracker.m_bindingEnvironment;
        if (this.m_body instanceof FunctionCallInstruction) {
            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)this.m_body;
            HashSet hashSet = new HashSet();
            for (int i = 0; i < this.m_parameters.length; ++i) {
                codeGenerationTracker.registerExtantBinding(this.m_parameters[i], this.m_parameters[i].getName().toString());
            }
            LambdaFunctionGenerationStyle lambdaFunctionGenerationStyle = this.computeGenerationStyle(fcgCodeGenHelper, typeEnvironment, bindingEnvironment, codeGenerationTracker, hashSet, fcgInstructionList);
            String string3 = fcgCodeGenHelper.getClassName() + "$" + lambdaFunctionGenerationStyle.generateClassName(fcgCodeGenHelper);
            FcgClassReferenceType fcgClassReferenceType = fcgCodeGenHelper.getClassReferenceType(string3);
            FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGenHelper.loadThisVar(fcgInstructionList);
            List list = ClosureGenerationUtilities.generateClosureFunctionCallParameters(functionCallInstruction, hashSet, codeGenerationTracker, fcgCodeGenHelper, fcgInstructionList);
            FcgType[] fcgTypeArray = new FcgType[list.size() + 1];
            fcgTypeArray[0] = fcgClassReferenceType2;
            for (int i = 0; i < list.size(); ++i) {
                fcgTypeArray[i + 1] = ((IBinding)list.get(i)).getBindingType(typeEnvironment, bindingEnvironment).getFCGType(fcgCodeGenHelper);
            }
            fcgInstructionList.createObjectExpr((FcgType)fcgClassReferenceType, fcgTypeArray);
            fcgCodeGenHelper.requestFunctionGeneration(lambdaFunctionGenerationStyle);
            return fcgClassReferenceType;
        }
        CodeGenerationTracker codeGenerationTracker2 = codeGenerationTracker.cloneBranch();
        LambdaType lambdaType = (LambdaType)this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment).resolveType(codeGenerationTracker.m_typeEnvironment);
        String string4 = lambdaType.getImplementationName(fcgCodeGenHelper);
        String string5 = fcgCodeGenHelper.generateNewClassName();
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGenHelper.getClassReferenceType(string5);
        FcgClassGen fcgClassGen = fcgCodeGenHelper.newClassGen(fcgClassReferenceType, fcgCodeGenHelper.getClassReferenceType(string4), FcgAttrs.PUBLIC_FINAL);
        FcgType fcgType2 = lambdaType.getReturnType().getFCGType(fcgCodeGenHelper);
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PUBLIC_FINAL, fcgType2, "invoke");
        FcgInstructionList fcgInstructionList2 = fcgMethodGen.getInstructionList();
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Binding binding = this.m_parameters[i];
            object22 = fcgCodeGenHelper.generateNewLocalVariableName(Binding.generateVariableName(binding, fcgCodeGenHelper));
            fcgType = binding.getBindingType().getFCGType(fcgCodeGenHelper);
            codeGenerationTracker2.registerExtantBinding(binding, (String)object22);
            fcgMethodGen.addParameter(fcgType, (String)object22);
        }
        HashSet hashSet = new HashSet();
        this.m_body.accumulateNonLiteralFreeBindings(hashSet, codeGenerationTracker.m_bindingEnvironment);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            hashSet.remove(this.m_parameters[i]);
        }
        for (Object object22 : hashSet) {
            fcgType = object22.getBindingType(typeEnvironment, bindingEnvironment).getFCGType(fcgCodeGenHelper);
            String string6 = "m_" + fcgCodeGenHelper.getSafeName(object22.getName().toString());
            codeGenerationTracker2.registerBinding((IBinding)object22, new LazyAdditionGenerationState((IBinding)object22, null, string6, fcgType));
        }
        fcgInstructionList2.beginMethod();
        object22 = fcgCodeGenHelper.getClassReferenceType(fcgCodeGenHelper.getClassName());
        fcgInstructionList2.loadThis();
        fcgInstructionList2.loadInstanceField(fcgClassReferenceType, "__this__", (FcgType)object22);
        fcgInstructionList2.defineConstVar((FcgType)object22, "__this__");
        this.m_body.generateCode(fcgCodeGenHelper, codeGenerationTracker2, null, true, fcgInstructionList2, genFork);
        fcgInstructionList2.returnInstruction(fcgType2);
        fcgInstructionList2.endMethod();
        ClosureGenerationUtilities.generateClosureInitSuffix(hashSet, codeGenerationTracker, fcgCodeGenHelper, fcgClassGen, fcgInstructionList);
        fcgCodeGenHelper.completeClassGeneration(fcgClassGen);
        return fcgClassReferenceType;
    }

    @Override
    public Instruction assignNewNames(Map map2, INewNameGenerator iNewNameGenerator) {
        Binding[] bindingArray = new Binding[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Object object2 = iNewNameGenerator.getNewName();
            map2.put(this.m_parameters[i].getName(), new IdentifierInstruction(object2));
            bindingArray[i] = new Binding(object2, this.m_parameters[i].getBindingType(), this);
        }
        return new LambdaInstruction(this.m_body.assignNewNames(map2, iNewNameGenerator), bindingArray, this.m_isPure);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Binding[] bindingArray = new Binding[this.m_parameters.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            bindingArray[i] = new Binding(this.m_parameters[i].getName(), this.m_parameters[i].getBindingType(), this);
        }
        LambdaInstruction lambdaInstruction = new LambdaInstruction(this.m_body.cloneWithoutTypeInformation(), bindingArray, this.m_isPure);
        LambdaInstruction.propagateInfo(this, lambdaInstruction);
        return lambdaInstruction;
    }

    @Override
    public Instruction cloneShallow() {
        Binding[] bindingArray = new Binding[this.m_parameters.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            bindingArray[i] = new Binding(this.m_parameters[i].getName(), this.m_parameters[i].getBindingType(), this);
        }
        LambdaInstruction lambdaInstruction = new LambdaInstruction(this.m_body, bindingArray, this.m_isPure);
        LambdaInstruction.propagateInfo(this, lambdaInstruction);
        return lambdaInstruction;
    }

    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function2);
        }
        int n2 = this.closureExternalBindings.length;
        Object[] objectArray = new Object[n2];
        boolean bl2 = false;
        for (int i = 0; i < n2; ++i) {
            IBinding iBinding = this.closureExternalBindings[i];
            Object object2 = environment.lookupBoundValue(iBinding);
            Type type2 = iBinding.getBindingType();
            if (type2 == null) {
                type2 = this.closureInternalBindings[i].getBindingType();
            }
            objectArray[i] = object2 = type2.evaluateVariableFork(object2);
        }
        Closure closure = new Closure(this.closureInternalBindings, objectArray, function2, this.m_body, this.m_parameters, this.m_sourceFilename, this.m_sourceLineNumber, this.stackFrameSize);
        closure.m_mustForkAndRelease = bl2;
        environment.pushIForkReleaseManagedForRelease(closure);
        return Debugger.leave(iDebuggerInterceptor, this, environment, function2, (Object)closure);
    }

    public Instruction getBody() {
        return this.m_body;
    }

    public void setBody(Instruction instruction2) {
        this.m_body = instruction2;
    }

    @Override
    public String innerToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("lambda (");
        for (int i = 0; i < this.m_parameters.length; ++i) {
            if (i != 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.m_parameters[i].getName());
        }
        return stringBuffer + ")";
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n2) {
        prettyPrinter.printFormOpen("lambda", n2);
        prettyPrinter.print(" (");
        for (int i = 0; i < this.m_parameters.length; ++i) {
            prettyPrinter.printIdentifier(this.m_parameters[i], n2 + 2);
            Type type2 = this.m_parameters[i].getBindingType();
            if (type2 == null) continue;
            prettyPrinter.print("@");
            prettyPrinter.print(type2.prettyPrint());
        }
        prettyPrinter.print(")");
        this.m_body.toString(prettyPrinter, n2 + 1);
        prettyPrinter.print(")");
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type[] typeArray = new Type[this.m_parameters.length];
        BindingEnvironment bindingEnvironment2 = new BindingEnvironment(bindingEnvironment);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            typeArray[i] = this.m_parameters[i].getBindingType();
            bindingEnvironment2.setVariableBinding(this.m_parameters[i]);
        }
        if (this.closureExternalBindings != null) {
            Type[] typeArray2 = new Type[this.closureExternalBindings.length];
            for (int i = 0; i < this.closureExternalBindings.length; ++i) {
                Type type2 = this.closureExternalBindings[i].getBindingType(typeEnvironment, bindingEnvironment2);
                assert (type2 != null);
                assert (this.closureExternalBindings[i].getBindingType() != null);
            }
        }
        return this.setCachedType(new LambdaType(typeArray, this.m_body.typeCheck(typeEnvironment, bindingEnvironment2, linkedList), this.m_isPure));
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        LambdaInstruction lambdaInstruction = this;
        ReductionHelper reductionHelper2 = (ReductionHelper)reductionHelper.clone();
        this.m_bindingEnvironment = null;
        for (int i = 0; i < this.m_parameters.length; ++i) {
            reductionHelper2.upgradeBinding(this.m_parameters[i]);
            bindingEnvironment.setVariableBinding(this.m_parameters[i]);
        }
        lambdaInstruction.m_body = reductionHelper2.reduce(this.m_body, bindingEnvironment);
        instructionArray[0] = lambdaInstruction;
    }

    @Override
    public int getChildInstructionCount() {
        return 1;
    }

    @Override
    public Instruction getChildInstruction(int n2) {
        return n2 == 0 ? this.m_body : null;
    }

    @Override
    public void setChildInstruction(int n2, Instruction instruction2) {
        if (n2 == 0) {
            this.m_body = instruction2;
        }
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set2, BindingEnvironment bindingEnvironment) {
        super.accumulateNonLiteralFreeBindings(set2, bindingEnvironment);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            set2.remove(this.m_parameters[i]);
        }
        if (set2.contains(this)) {
            throw new XylemError("ERR_SYSTEM", "Lambda has binding to itself!");
        }
    }

    @Override
    public void accumulateFreeBindings(Set set2, BindingEnvironment bindingEnvironment) {
        super.accumulateFreeBindings(set2, bindingEnvironment);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            set2.remove(this.m_parameters[i]);
        }
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        this.m_body = readObjectFileHelper.readInstruction(bindingEnvironment);
        this.m_isPure = readObjectFileHelper.readBoolean();
        this.m_parameters = readObjectFileHelper.readTypeSpecificBindingSet(this);
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeInstruction(this.m_body);
        writeObjectFileHelper.writeBoolean(this.m_isPure);
        writeObjectFileHelper.writeTypeSpecificBindingSet(this.m_parameters);
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        Type[] typeArray = new Type[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            typeArray[i] = this.m_parameters[i].getBindingType();
            bindingEnvironment.setVariableBinding(this.m_parameters[i]);
        }
        super.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
    }

    @Override
    public Type getTypeParameter(int n2) {
        return this.m_parameters[n2].getBindingType();
    }

    @Override
    public int getTypeParameterCount() {
        return this.m_parameters.length;
    }

    @Override
    public void setTypeParameter(int n2, Type type2) {
        this.m_parameters[n2].setType(type2);
    }

    @Override
    public boolean isChildInstructionBody(int n2) {
        return true;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int n2) {
        return this.m_parameters;
    }

    public List getBindings() {
        ArrayList<Binding> arrayList = new ArrayList<Binding>();
        arrayList.addAll(Arrays.asList(this.m_parameters));
        return arrayList;
    }

    public Binding[] getParameters() {
        return this.m_parameters;
    }

    @Override
    public boolean equals(Object object2) {
        if (!super.equals(object2)) {
            return false;
        }
        LambdaInstruction lambdaInstruction = (LambdaInstruction)object2;
        int n2 = this.m_parameters.length;
        if (lambdaInstruction.m_parameters.length != n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (lambdaInstruction.m_parameters[i].getName().equals(this.m_parameters[i].getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isChildInstructionInTailPosition(int n2) {
        return false;
    }

    public IBinding[] getFreeBindings() {
        return this.closureExternalBindings;
    }

    public void setFreeBindings(Set<IBinding> set2, Function function2) {
        this.closureExternalBindings = new IBinding[set2.size()];
        this.closureInternalBindings = new IBinding[set2.size()];
        int n2 = 0;
        Iterator<IBinding> iterator = set2.iterator();
        while (iterator.hasNext()) {
            IBinding iBinding;
            this.closureExternalBindings[n2] = iBinding = iterator.next();
            Type type2 = iBinding.getBindingType();
            if (type2 == null) {
                type2 = this.extractType(iBinding, function2);
            }
            assert (type2 != null);
            Binding binding = new Binding(iBinding.getName(), type2);
            binding.setStackFramePos(n2 + this.m_parameters.length);
            this.closureInternalBindings[n2] = binding;
            ++n2;
        }
    }

    private Type extractType(IBinding iBinding, Function function2) {
        BindingEnvironment bindingEnvironment = this.getBindingEnvironment();
        if (bindingEnvironment == null) {
            bindingEnvironment = function2.getBindingEnvironment();
        }
        assert (bindingEnvironment != null);
        TypeEnvironment typeEnvironment = function2.getTypeEnvironment();
        assert (typeEnvironment != null);
        Type type2 = iBinding.getBindingType(typeEnvironment, bindingEnvironment);
        return type2;
    }

    public IBinding[] getClosureInternalBindings() {
        return this.closureInternalBindings;
    }

    public int getStackFrameSize() {
        return this.stackFrameSize;
    }

    public void setStackFrameSize(int n2) {
        this.stackFrameSize = n2;
    }
}

