/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgInterfaceType;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgTypeUtils;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.IImperativeInstruction;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.JavaClassImporter;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.GenFork;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ObjectFactory;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IConvertible;
import com.ibm.xltxe.rnm1.xylem.interpreter.InterpreterUtilities;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.JavaClassInformation;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.types.UnitType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.BasicDynamicContext;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaMethodInvocationInstruction
extends NaryPrimopInstruction
implements IImperativeInstruction {
    private static final Logger s_logger = LoggerUtil.getLogger(JavaMethodInvocationInstruction.class);
    private static final String s_className = JavaMethodInvocationInstruction.class.getName();
    protected String m_function;
    public Instruction m_object;
    protected String m_classname;
    protected Type m_type;

    public JavaMethodInvocationInstruction() {
    }

    public JavaMethodInvocationInstruction(String string2, Instruction instruction2, Instruction[] instructionArray, Type type2) {
        super(instructionArray);
        this.m_function = string2;
        this.m_object = instruction2;
        this.setCachedType(type2);
        this.m_type = type2;
    }

    public JavaMethodInvocationInstruction(String string2, String string3, Instruction[] instructionArray, Type type2) {
        super(instructionArray);
        this.m_function = string2;
        this.m_classname = string3;
        this.setCachedType(type2);
    }

    public String getFunction() {
        return this.m_function;
    }

    public String getClassName() {
        return this.m_classname;
    }

    public void setFunction(String string2) {
        this.m_function = string2;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    public Instruction getObject() {
        return this.m_object;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        if (this.m_object != null) {
            this.m_object.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "typeCheck", "Checking " + this);
        }
        if (this.m_type == null) {
            Object object2;
            int n2;
            int n3;
            Object object3;
            JavaObjectType javaObjectType;
            if (this.m_object == null) {
                javaObjectType = new JavaObjectType(this.m_classname);
            } else {
                object3 = this.m_object.getCachedType();
                if (object3 == null) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not find the type of " + this.m_object), this);
                }
                if ((object3 = ((Type)object3).resolveType(typeEnvironment)) == null) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not infer the type of " + this.m_object), this);
                }
                if (!(object3 instanceof JavaObjectType)) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_object + " is not a Java object"), this);
                }
                javaObjectType = (JavaObjectType)object3;
            }
            object3 = javaObjectType.getInformation(typeEnvironment.getModule());
            if (this.m_object == null) {
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Java instance method invocation without an object."), this);
            }
            Collection collection2 = this.getMethods((JavaClassInformation)object3, this.m_function, typeEnvironment.getModule());
            if (collection2 == null || collection2.size() == 0) {
                if (javaObjectType.getInformation(typeEnvironment.getModule()).getBaseClassNames().size() == 0 && LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                    s_logger.logp(Level.FINEST, s_className, "typeCheck", "Could not find any base classes for " + javaObjectType.getClassName() + ".  Maybe I can't find the class either.");
                }
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Class " + javaObjectType + " does not contain a method named " + this.m_function), this);
            }
            for (n3 = 0; n3 < this.m_parameters.length; ++n3) {
                this.m_parameters[n3].typeCheck(typeEnvironment, bindingEnvironment, linkedList);
            }
            n3 = 1;
            for (n2 = 0; n2 < this.m_parameters.length; ++n2) {
                if (this.m_parameters[n2].getCachedType().isFullySpecified()) continue;
                n3 = 0;
                break;
            }
            if (n3 == 0) {
                n2 = 0;
                for (Type[] typeArray : collection2) {
                    object2 = typeArray.getParameterTypes();
                    if (((Type[])object2).length != this.m_parameters.length) continue;
                    ++n2;
                }
                if (n2 > 1) {
                    this.m_type = this.setCachedType(new TypeVariable());
                    return this.m_type;
                }
            }
            for (Object object4 : collection2) {
                Type[] typeArray;
                typeArray = ((JavaClassInformation.Method)object4).getParameterTypes();
                if (typeArray.length != this.m_parameters.length) continue;
                object2 = typeEnvironment.copy();
                try {
                    int n4;
                    for (n4 = 0; n4 < typeArray.length; ++n4) {
                        ((TypeEnvironment)object2).unify(typeArray[n4], this.m_parameters[n4].getCachedType(), this);
                    }
                    for (n4 = 0; n4 < typeArray.length; ++n4) {
                        typeEnvironment.unify(typeArray[n4], this.m_parameters[n4].getCachedType(), this);
                    }
                    this.m_type = this.setCachedType(((JavaClassInformation.Method)object4).getReturnType());
                    return this.m_type;
                }
                catch (TypeCheckException typeCheckException) {
                    if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINEST)) continue;
                    s_logger.logp(Level.FINEST, s_className, "typeCheck", "Method did not match.  reason: " + typeCheckException.getMessage());
                }
            }
            if (this.m_type == null) {
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not find a suitable method named " + this.m_function + " for " + this.m_object), this);
            }
        } else {
            for (int i = 0; i < this.m_parameters.length; ++i) {
                this.m_parameters[i].typeCheck(typeEnvironment, bindingEnvironment, linkedList);
            }
        }
        return this.setCachedType(this.m_type);
    }

    private Collection getMethods(JavaClassInformation javaClassInformation, String string2, Module module) {
        Set set2;
        Collection collection2 = javaClassInformation.getMethods(string2);
        return collection2 != null && collection2.size() > 0 ? collection2 : ((set2 = javaClassInformation.getBaseClassNames()).size() < 1 ? null : this.getMethods(set2, string2, module));
    }

    private Collection getMethods(Set set2, String string2, Module module) {
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            try {
                JavaClassInformation javaClassInformation = JavaClassImporter.retrieveJavaClassInformation((String)iterator.next(), module);
                Collection collection2 = this.getMethods(javaClassInformation, string2, module);
                if (collection2 == null || collection2.size() <= 0) continue;
                return collection2;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_type;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature moduleSignature) {
        return this.m_type;
    }

    @Override
    public Instruction getChildInstruction(int n2) {
        return n2 > 0 ? this.m_parameters[n2 - 1] : this.m_object;
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_parameters.length + 1;
    }

    @Override
    public void setChildInstruction(int n2, Instruction instruction2) {
        if (n2 == 0) {
            this.m_object = instruction2;
        } else {
            this.m_parameters[n2 - 1] = instruction2;
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] instructionArray = new Instruction[this.m_parameters.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        if (this.m_classname == null) {
            JavaMethodInvocationInstruction javaMethodInvocationInstruction = new JavaMethodInvocationInstruction(this.m_function, this.m_object.cloneWithoutTypeInformation(), instructionArray, this.m_type);
            JavaMethodInvocationInstruction.propagateInfo(this, javaMethodInvocationInstruction);
            return javaMethodInvocationInstruction;
        }
        JavaMethodInvocationInstruction javaMethodInvocationInstruction = new JavaMethodInvocationInstruction(this.m_function, this.m_classname, instructionArray, this.m_type);
        JavaMethodInvocationInstruction.propagateInfo(this, javaMethodInvocationInstruction);
        return javaMethodInvocationInstruction;
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] instructionArray = (Instruction[])this.m_parameters.clone();
        if (this.m_classname == null) {
            JavaMethodInvocationInstruction javaMethodInvocationInstruction = new JavaMethodInvocationInstruction(this.m_function, this.m_object, instructionArray, this.m_type);
            JavaMethodInvocationInstruction.propagateInfo(this, javaMethodInvocationInstruction);
            return javaMethodInvocationInstruction;
        }
        JavaMethodInvocationInstruction javaMethodInvocationInstruction = new JavaMethodInvocationInstruction(this.m_function, this.m_classname, instructionArray, this.m_type);
        JavaMethodInvocationInstruction.propagateInfo(this, javaMethodInvocationInstruction);
        return javaMethodInvocationInstruction;
    }

    @Override
    public String innerToString() {
        return "java-method-invoke" + (this.m_type == null ? "" : "@" + this.m_type.prettyPrint());
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n2) {
        prettyPrinter.printFormOpen(this.innerToString(), n2);
        if (this.m_classname != null) {
            prettyPrinter.print(" \"" + this.m_classname + "\" ");
        } else {
            this.m_object.toString(prettyPrinter, n2 + 1);
        }
        prettyPrinter.printToken(this.m_function, n2 + 1);
        if (this.getChildInstructionCount() > 0) {
            for (int i = 1; i < this.getChildInstructionCount(); ++i) {
                Instruction instruction2 = this.getChildInstruction(i);
                if (instruction2 != null) {
                    instruction2.toString(prettyPrinter, n2 + 1);
                    continue;
                }
                prettyPrinter.printToken("null", n2 + 1);
            }
        }
        prettyPrinter.printFormClose(n2);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, String string2, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        SessionContext sessionContext = codeGenerationTracker.getSessionContext();
        BasicDynamicContext basicDynamicContext = new BasicDynamicContext(sessionContext);
        Environment environment = new Environment(basicDynamicContext);
        CodeGenerationSettings codeGenerationSettings = fcgCodeGenHelper.getSettings();
        environment.setArbitraryPrecision(codeGenerationSettings.getArbitraryPrecision());
        environment.setOverflowDetection(codeGenerationSettings.getOverflowDetection());
        Method method = this.resolveMethod(environment, fcgCodeGenHelper.getCurrentFunctionAsFunction(), null, false);
        environment.release(null);
        boolean bl2 = Modifier.isStatic(method.getModifiers());
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        Type type2 = this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
        FcgType fcgType = type2 == UnitType.s_unitType ? FcgType.VOID : type2.getFCGType(fcgCodeGenHelper);
        if (!bl2) {
            codeGenerationTracker.generateConventionally(this.m_object, fcgCodeGenHelper, fcgInstructionList);
        }
        Class<?>[] classArray = method.getParameterTypes();
        FcgType[] fcgTypeArray = new FcgType[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            codeGenerationTracker.generateConventionally(this.m_parameters[i], fcgCodeGenHelper, fcgInstructionList, GenFork.NOTNEEDED);
            fcgTypeArray[i] = FcgTypeUtils.getFcgType(fcgCodeGenHelper, classArray[i]);
        }
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGenHelper.getClassReferenceType(method.getDeclaringClass().getName());
        if (!bl2) {
            if (method.getDeclaringClass().isInterface()) {
                FcgInterfaceType fcgInterfaceType = fcgCodeGenHelper.getInterfaceType(method.getDeclaringClass().getName());
                fcgInstructionList.invokeInterfaceMethod(fcgInterfaceType, this.m_function, fcgType, fcgTypeArray);
            } else {
                fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType, this.m_function, fcgType, fcgTypeArray);
            }
        } else {
            fcgInstructionList.invokeClassMethod(fcgClassReferenceType, this.m_function, fcgType, fcgTypeArray);
        }
        return fcgType;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function2);
        }
        Object object2 = null;
        environment.pushForkScope();
        Object object3 = null;
        try {
            Object[] objectArray;
            if (this.m_object != null) {
                objectArray = this.m_object.evaluateType(function2);
                object2 = this.m_object.evaluate(environment, function2, iDebuggerInterceptor, false);
                if (object2 instanceof IConvertible) {
                    object2 = ((IConvertible)object2).convert(environment, (Type)objectArray);
                }
            }
            objectArray = new Object[this.m_parameters.length];
            Type[] typeArray = new Type[this.m_parameters.length];
            int n2 = 0;
            while (true) {
                Object object4;
                if (n2 >= this.m_parameters.length) {
                    Method method = this.resolveMethod(environment, function2, iDebuggerInterceptor, bl, typeArray);
                    object4 = method.invoke(object2, objectArray);
                    Type type2 = this.evaluateType(function2);
                    object3 = type2.wrapForInterpreter(object4, environment);
                    Object object5 = Debugger.leave(iDebuggerInterceptor, this, environment, function2, object3);
                    environment.popForkScope(object3);
                    return object5;
                }
                typeArray[n2] = this.m_parameters[n2].evaluateType(function2);
                object4 = this.m_parameters[n2].evaluate(environment, function2, iDebuggerInterceptor, false);
                if (object4 instanceof IConvertible) {
                    object4 = ((IConvertible)object4).convert(environment, typeArray[n2]);
                }
                objectArray[n2] = object4;
                ++n2;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            try {
                RuntimeException runtimeException;
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RuntimeException) {
                    runtimeException = (RuntimeException)throwable;
                    throw runtimeException;
                }
                runtimeException = new RuntimeException(throwable);
                throw runtimeException;
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            catch (Throwable throwable) {
                environment.popForkScope(object3);
                throw throwable;
            }
        }
    }

    private Type[] getArgTypes(Environment environment, Function function2) {
        Type[] typeArray = new Type[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            typeArray[i] = this.m_parameters[i].evaluateType(function2);
        }
        return typeArray;
    }

    private Class[] getJavaArgTypes(Environment environment, Type[] typeArray) {
        Class[] classArray = new Class[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            classArray[i] = typeArray[i].getJavaType(environment);
        }
        return classArray;
    }

    private Method resolveMethod(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl, Type[] typeArray) {
        Object object2;
        Object var6_6 = null;
        Class clazz = null;
        if (this.m_object != null) {
            object2 = this.m_object.evaluateType(function2);
            clazz = ((Type)object2).getJavaType(environment);
        } else {
            object2 = this.m_classname;
            while (clazz == null) {
                try {
                    clazz = ObjectFactory.findProviderClass((String)object2, ObjectFactory.findClassLoader(), true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    int n2 = this.m_classname.lastIndexOf(46);
                    if (n2 != -1) {
                        object2 = ((String)object2).substring(0, n2) + "$" + ((String)object2).substring(n2 + 1, ((String)object2).length());
                        continue;
                    }
                    throw new XylemError("ERR_SYSTEM", "Could not find class for " + this.m_classname);
                }
            }
        }
        try {
            object2 = InterpreterUtilities.getMethod(clazz, this.m_function, this.getJavaArgTypes(environment, typeArray));
            return object2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Method resolveMethod(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        return this.resolveMethod(environment, function2, iDebuggerInterceptor, bl, this.getArgTypes(environment, function2));
    }

    @Override
    public boolean equals(Object object2) {
        if (!super.equals(object2)) {
            return false;
        }
        JavaMethodInvocationInstruction javaMethodInvocationInstruction = (JavaMethodInvocationInstruction)object2;
        return javaMethodInvocationInstruction.m_function.equals(this.m_function);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.m_function.hashCode();
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        this.m_object = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_object, bindingEnvironment);
        super.generateReducedForm(reductionHelper, instructionArray, bindingEnvironment);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_object = readObjectFileHelper.readInstruction(bindingEnvironment);
        if (readObjectFileHelper.readBoolean()) {
            this.m_classname = readObjectFileHelper.readString();
        }
        this.m_function = readObjectFileHelper.readString();
        this.m_type = readObjectFileHelper.readType();
        this.setCachedType(this.m_type);
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeInstruction(this.m_object);
        writeObjectFileHelper.writeBoolean(this.m_classname != null);
        if (this.m_classname != null) {
            writeObjectFileHelper.writeString(this.m_classname);
        }
        writeObjectFileHelper.writeString(this.m_function);
        writeObjectFileHelper.writeType(this.m_type);
    }
}

