/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.GenFork;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.StringStream;
import com.ibm.xltxe.rnm1.xylem.types.ByteType;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.types.IPrimitiveType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.LinkedList;

public class HexEscapeInstruction
extends UnaryPrimopInstruction {
    public HexEscapeInstruction() {
    }

    public HexEscapeInstruction(Instruction instruction2) {
        super(instruction2);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        HexEscapeInstruction hexEscapeInstruction = new HexEscapeInstruction(this.m_operand.cloneWithoutTypeInformation());
        HexEscapeInstruction.propagateInfo(this, hexEscapeInstruction);
        return hexEscapeInstruction;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type type2 = this.m_operand.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        if (type2.equals(IntType.s_intType, typeEnvironment)) {
            typeEnvironment.unify(type2, IntType.s_intType, this);
        } else if (type2.equals(ByteType.s_byteType, typeEnvironment)) {
            typeEnvironment.unify(type2, ByteType.s_byteType, this);
        } else {
            typeEnvironment.unify(type2, CharType.s_charType, this);
        }
        return this.setCachedType(CharType.s_charType.getStreamType());
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        this.m_operand.getType(typeEnvironment, bindingEnvironment);
        return CharType.s_charType.getStreamType();
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature moduleSignature) {
        return CharType.s_charType.getStreamType();
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, String string2, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        codeGenerationTracker.generateConventionally(this.m_operand, fcgCodeGenHelper, fcgInstructionList);
        Type type2 = codeGenerationTracker.resolveType(this.m_operand);
        if (type2 instanceof INumericalType) {
            if (type2 instanceof ByteType) {
                fcgInstructionList.loadLiteral(255);
                fcgInstructionList.binaryOperationExpr(FcgBinOp.BITWISE_AND);
            } else if (!(type2 instanceof IPrimitiveType)) {
                throw new XylemError("ERR_SYSTEM", "Hex-Escape not supported for type " + type2);
            }
        } else {
            throw new XylemError("ERR_SYSTEM", "Hex-Escape not supported for type " + type2);
        }
        fcgInstructionList.loadLiteral(16);
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGenHelper.getClassReferenceType("java.lang.Integer");
        fcgInstructionList.invokeClassMethod(fcgClassReferenceType, "toString", (FcgType)FcgType.STRING, 2);
        fcgClassReferenceType = fcgCodeGenHelper.getClassReferenceType("java.lang.String");
        fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType, "toUpperCase", (FcgType)FcgType.STRING, 0);
        fcgClassReferenceType = fcgCodeGenHelper.getClassReferenceType("java.lang.String");
        fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType, "toCharArray", (FcgType)FcgType.CHAR_ARRAY, 0);
        return FcgType.CHAR_ARRAY;
    }

    @Override
    public String innerToString() {
        return "hex-escape";
    }

    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        Object object2;
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function2);
        }
        if ((object2 = this.m_operand.evaluate(environment, function2, iDebuggerInterceptor, false)) instanceof Byte) {
            byte by2 = (Byte)object2;
            StringStream stringStream = new StringStream(Integer.toString(by2 & 0xFF, 16).toUpperCase());
            return Debugger.leave(iDebuggerInterceptor, this, environment, function2, (Object)stringStream);
        }
        if (object2 instanceof Number) {
            StringStream stringStream = new StringStream(Integer.toString(((Number)object2).intValue(), 16).toUpperCase());
            return Debugger.leave(iDebuggerInterceptor, this, environment, function2, (Object)stringStream);
        }
        if (object2 instanceof Character) {
            StringStream stringStream = new StringStream(Integer.toString(((Character)object2).charValue(), 16).toUpperCase());
            return Debugger.leave(iDebuggerInterceptor, this, environment, function2, (Object)stringStream);
        }
        throw new UnsupportedOperationException("Hex-Escape is not supported on type " + object2.getClass() + " with value:" + object2);
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction2) {
        HexEscapeInstruction hexEscapeInstruction = new HexEscapeInstruction(instruction2);
        HexEscapeInstruction.propagateInfo(this, hexEscapeInstruction);
        return hexEscapeInstruction;
    }
}

