/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import java.io.IOException;
import java.util.LinkedList;

public abstract class BinaryPrimopInstruction
extends Instruction {
    protected Instruction m_operand1;
    protected Instruction m_operand2;

    protected BinaryPrimopInstruction(Instruction instruction2, Instruction instruction3) {
        this.m_operand1 = instruction2;
        this.m_operand2 = instruction3;
    }

    public BinaryPrimopInstruction() {
    }

    public final Instruction getOperand1() {
        return this.m_operand1;
    }

    public final Instruction getOperand2() {
        return this.m_operand2;
    }

    @Override
    public final int getChildInstructionCount() {
        return 2;
    }

    @Override
    public final Instruction getChildInstruction(int n2) {
        switch (n2) {
            case 0: {
                return this.m_operand1;
            }
            case 1: {
                return this.m_operand2;
            }
        }
        return null;
    }

    @Override
    public final void setChildInstruction(int n2, Instruction instruction2) {
        switch (n2) {
            case 0: {
                this.m_operand1 = instruction2;
                break;
            }
            case 1: {
                this.m_operand2 = instruction2;
            }
        }
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        Instruction instruction2 = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_operand1, bindingEnvironment);
        Instruction instruction3 = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_operand2, bindingEnvironment);
        instructionArray[0] = this;
        this.m_bindingEnvironment = null;
        this.m_operand1 = instruction2;
        this.m_operand2 = instruction3;
    }

    public abstract Instruction cloneWithoutTypeInformation(Instruction var1, Instruction var2);

    @Override
    public Instruction cloneShallow() {
        Instruction instruction2 = this.cloneWithoutTypeInformation(this.m_operand1, this.m_operand2);
        BinaryPrimopInstruction.propagateInfo(this, instruction2);
        return instruction2;
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        this.m_operand1 = readObjectFileHelper.readInstruction(bindingEnvironment);
        this.m_operand2 = readObjectFileHelper.readInstruction(bindingEnvironment);
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeInstruction(this.m_operand1);
        writeObjectFileHelper.writeInstruction(this.m_operand2);
    }

    @Override
    public Instruction cloneReduced() {
        return this.cloneShallow();
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
    }
}

