/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.GenFork;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Closure;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.LambdaType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ApplyInstruction
extends NaryPrimopInstruction {
    protected Instruction m_lambda;
    private Object m_tailLoopApply = null;
    private IBinding[] m_tailLoopParams = null;
    private boolean m_isPure = true;
    protected LambdaType m_lambdaType;

    public ApplyInstruction() {
    }

    public ApplyInstruction(Instruction instruction2, Instruction[] instructionArray, boolean bl) {
        super(instructionArray);
        this.m_lambda = instruction2;
        this.m_isPure = bl;
    }

    public ApplyInstruction(Instruction instruction2, List list, boolean bl) {
        super(list);
        this.m_lambda = instruction2;
        this.m_isPure = bl;
    }

    @Override
    public boolean isPure() {
        return this.m_isPure;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    public Instruction getLambda() {
        return this.m_lambda;
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type type2 = this.m_lambdaType.getReturnType();
        Type type3 = type2.resolveType(typeEnvironment);
        return null != type3 ? type3 : type2;
    }

    protected void setupType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type type2 = this.m_lambda.getType(typeEnvironment, bindingEnvironment);
        if (type2 instanceof LambdaType) {
            this.m_lambdaType = (LambdaType)type2;
        } else if (this.m_lambdaType == null) {
            Type[] typeArray = new Type[this.m_parameters.length];
            for (int i = 0; i < this.m_parameters.length; ++i) {
                typeArray[i] = new TypeVariable();
            }
            this.m_lambdaType = new LambdaType(typeArray, new TypeVariable(), this.m_isPure);
            try {
                typeEnvironment.unify(this.m_lambdaType, this.m_lambda.getType(typeEnvironment, bindingEnvironment), this);
            }
            catch (TypeCheckException typeCheckException) {
                typeCheckException.printStackTrace();
            }
        }
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        super.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
        this.setupType(typeEnvironment, bindingEnvironment);
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        this.m_lambda = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_lambda, bindingEnvironment);
        super.generateReducedForm(reductionHelper, instructionArray, bindingEnvironment);
        this.setupType(reductionHelper.m_typeEnvironment, bindingEnvironment);
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type[] typeArray = new Type[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            typeArray[i] = new TypeVariable();
            typeEnvironment.unify(this.m_parameters[i].typeCheck(typeEnvironment, bindingEnvironment, linkedList), typeArray[i], this);
        }
        Type type2 = this.setCachedType(new TypeVariable());
        LambdaType lambdaType = new LambdaType(typeArray, type2, this.m_isPure);
        typeEnvironment.unify(this.m_lambda.typeCheck(typeEnvironment, bindingEnvironment, linkedList), lambdaType, this);
        return type2;
    }

    @Override
    public Instruction getChildInstruction(int n2) {
        switch (n2) {
            case 0: {
                return this.m_lambda;
            }
        }
        return this.m_parameters[n2 - 1];
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_parameters.length + 1;
    }

    @Override
    public void setChildInstruction(int n2, Instruction instruction2) {
        switch (n2) {
            case 0: {
                this.m_lambda = instruction2;
                break;
            }
            default: {
                this.m_parameters[n2 - 1] = instruction2;
            }
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] instructionArray = new Instruction[this.m_parameters.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        ApplyInstruction applyInstruction = new ApplyInstruction(this.m_lambda.cloneWithoutTypeInformation(), instructionArray, this.m_isPure);
        ApplyInstruction.propagateInfo(this, applyInstruction);
        return applyInstruction;
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] instructionArray = (Instruction[])this.m_parameters.clone();
        ApplyInstruction applyInstruction = new ApplyInstruction(this.m_lambda, instructionArray, this.m_isPure);
        ApplyInstruction.propagateInfo(this, applyInstruction);
        return applyInstruction;
    }

    @Override
    public String innerToString() {
        return "apply";
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, String string2, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        Object object2;
        Object object3;
        Object object4;
        if (this.isTailLoopApply()) {
            int n2;
            fcgInstructionList.comment("calling self loop '" + this.m_tailLoopApply + "' via tail recursion");
            int n3 = this.m_parameters.length;
            String[] stringArray = new String[n3];
            FcgType[] fcgTypeArray = new FcgType[n3];
            FcgVariable[] fcgVariableArray = new FcgVariable[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                if (this.m_parameters[n2] instanceof IdentifierInstruction && ((IdentifierInstruction)this.m_parameters[n2]).getVariable().equals(this.m_tailLoopParams[n2].getName())) continue;
                stringArray[n2] = fcgCodeGenHelper.generateNewLocalVariableName();
                fcgTypeArray[n2] = codeGenerationTracker.generateConventionally(this.m_parameters[n2], fcgCodeGenHelper, fcgInstructionList);
                fcgVariableArray[n2] = fcgInstructionList.defineVar(fcgTypeArray[n2], stringArray[n2], true);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                if (this.m_parameters[n2] instanceof IdentifierInstruction && ((IdentifierInstruction)this.m_parameters[n2]).getVariable().equals(this.m_tailLoopParams[n2].getName())) continue;
                codeGenerationTracker.generateConventionally(this.m_tailLoopParams[n2], fcgCodeGenHelper, bl, fcgInstructionList, false);
                fcgInstructionList.loadVar(fcgVariableArray[n2]);
                fcgInstructionList.storeAtStmt();
            }
            fcgInstructionList.nextIterationOfLoop();
            return fcgInstructionList.loadLiteral("___unreachableTailRecursionReturnValue_doNotAssign___");
        }
        FcgClassReferenceType fcgClassReferenceType = (FcgClassReferenceType)codeGenerationTracker.generateConventionally(this.m_lambda, fcgCodeGenHelper, bl, fcgInstructionList, genFork);
        FcgType[] fcgTypeArray = new FcgType[this.m_parameters.length];
        LambdaType lambdaType = (LambdaType)codeGenerationTracker.resolveType(this.m_lambda);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.m_parameters.length; ++i) {
            object4 = codeGenerationTracker.generateConventionally(this.m_parameters[i], fcgCodeGenHelper, fcgInstructionList);
            object3 = this.m_parameters[i].evaluateType(codeGenerationTracker.m_function);
            if (((Type)object3).isForkReleaseManaged(codeGenerationTracker)) {
                ((Type)object3).generateObjectFork(fcgCodeGenHelper, fcgInstructionList, codeGenerationTracker, GenFork.ONLY);
                String string3 = fcgCodeGenHelper.generateNewLocalVariableName(string2);
                object2 = fcgInstructionList.defineVar((FcgType)object4, string3, true);
                fcgInstructionList.loadVar((FcgVariable)object2);
                arrayList.add(object2);
            } else {
                arrayList.add(null);
            }
            fcgTypeArray[i] = lambdaType.getElementTypes()[i].getFCGType(fcgCodeGenHelper);
        }
        FcgType fcgType = lambdaType.getReturnType().getFCGType(fcgCodeGenHelper);
        fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType, "invoke", fcgType, this.m_parameters.length);
        object4 = fcgCodeGenHelper.generateNewLocalVariableName();
        object3 = fcgInstructionList.defineVar(fcgType, (String)object4, true);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            object2 = this.m_parameters[i].evaluateType(codeGenerationTracker.m_function);
            if (!((Type)object2).isForkReleaseManaged(codeGenerationTracker)) continue;
            fcgInstructionList.beginScopeBlock();
            FcgType fcgType2 = fcgInstructionList.loadVar((FcgVariable)arrayList.get(i));
            if (fcgType2.equals(fcgType)) {
                fcgInstructionList.loadVar((FcgVariable)object3);
                fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_NE);
                fcgInstructionList.beginIf();
                fcgInstructionList.beginScopeBlock();
                fcgInstructionList.loadVar((FcgVariable)arrayList.get(i));
                ((Type)object2).generateObjectRelease(fcgCodeGenHelper, fcgInstructionList, codeGenerationTracker);
                fcgInstructionList.endScopeBlock();
                fcgInstructionList.endIf();
            } else {
                ((Type)object2).generateObjectRelease(fcgCodeGenHelper, fcgInstructionList, codeGenerationTracker);
            }
            fcgInstructionList.endScopeBlock();
        }
        fcgInstructionList.loadVar((FcgVariable)object3);
        return fcgType;
    }

    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function2);
        }
        Closure closure = (Closure)this.m_lambda.evaluate(environment, function2, iDebuggerInterceptor, false);
        Object object2 = closure.evaluate(environment, function2, this.m_parameters, iDebuggerInterceptor);
        return Debugger.leave(iDebuggerInterceptor, this, environment, function2, object2);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_isPure = readObjectFileHelper.readBoolean();
        this.m_lambda = readObjectFileHelper.readInstruction(bindingEnvironment);
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeBoolean(this.m_isPure);
        writeObjectFileHelper.writeInstruction(this.m_lambda);
    }

    public void setTailLoopApply(Object object2, IBinding[] iBindingArray) {
        this.m_tailLoopApply = object2;
        this.m_tailLoopParams = iBindingArray;
    }

    public boolean isTailLoopApply() {
        return null != this.m_tailLoopApply;
    }
}

