/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgUnaryOp;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.GenFork;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.BigIntegerType;
import com.ibm.xltxe.rnm1.xylem.types.DecimalType;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.FloatType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.IntegerType;
import com.ibm.xltxe.rnm1.xylem.types.LongType;
import com.ibm.xltxe.rnm1.xylem.utils.OverflowException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedList;

public class AbsoluteValueInstruction
extends UnaryPrimopInstruction {
    public AbsoluteValueInstruction(Instruction instruction2) {
        super(instruction2);
    }

    public AbsoluteValueInstruction() {
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        AbsoluteValueInstruction absoluteValueInstruction = new AbsoluteValueInstruction(this.m_operand.cloneWithoutTypeInformation());
        AbsoluteValueInstruction.propagateInfo(this, absoluteValueInstruction);
        return absoluteValueInstruction;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        return this.setCachedType(this.m_operand.typeCheck(typeEnvironment, bindingEnvironment, linkedList));
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_operand.getType(typeEnvironment, bindingEnvironment);
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature moduleSignature) {
        return this.m_operand.getPreTypecheckType(moduleSignature);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper fcgCodeGenHelper, CodeGenerationTracker codeGenerationTracker, String string2, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        FcgType fcgType = null;
        codeGenerationTracker.generateConventionally(this.m_operand, fcgCodeGenHelper, fcgInstructionList);
        Type type2 = codeGenerationTracker.resolveType(this);
        if (type2.equals(IntType.s_intType) || type2.equals(FloatType.s_floatType) || type2.equals(DoubleType.s_doubleType) || type2.equals(IntegerType.s_integerType) || type2.equals(LongType.s_longType) || type2.equals(BigIntegerType.s_bigIntegerType) || type2.equals(DecimalType.s_decimalType)) {
            if (type2.equals(IntegerType.s_integerType) && !fcgCodeGenHelper.getSettings().getArbitraryPrecision() && fcgCodeGenHelper.getSettings().getOverflowDetection()) {
                FcgVariable fcgVariable = fcgInstructionList.defineVar(FcgType.LONG, fcgCodeGenHelper.generateNewLocalVariableName(), true);
                fcgInstructionList.loadVar(fcgVariable);
                fcgInstructionList.loadLiteral(Long.MIN_VALUE);
                fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
                fcgInstructionList.beginIf();
                fcgInstructionList.createObjectExpr((FcgType)FcgType.OVERFLOW_EXCEPTION, 0);
                fcgInstructionList.throwObject();
                fcgInstructionList.endIf();
                fcgInstructionList.loadVar(fcgVariable);
            }
        } else {
            throw new UnsupportedOperationException("Absolute value not supported for type " + type2);
        }
        fcgType = fcgInstructionList.unaryOperationExpr(FcgUnaryOp.ABSOLUTE_VALUE);
        return fcgType;
    }

    @Override
    public String innerToString() {
        return "abs";
    }

    @Override
    public Object evaluate(Environment environment, Function function2, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        Object object2;
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function2);
        }
        if ((object2 = this.m_operand.evaluate(environment, function2, iDebuggerInterceptor, false)) instanceof Long) {
            Long l = (Long)object2;
            if (environment.getOverflowDetection() && l == Long.MIN_VALUE) {
                throw new OverflowException();
            }
            Long l2 = new Long(Math.abs((Long)object2));
            return Debugger.leave(iDebuggerInterceptor, this, environment, function2, (Object)l2);
        }
        if (object2 instanceof Integer) {
            Integer n2 = new Integer(Math.abs((Integer)object2));
            return Debugger.leave(iDebuggerInterceptor, this, environment, function2, (Object)n2);
        }
        if (object2 instanceof Double) {
            Double d = new Double(Math.abs((Double)object2));
            return Debugger.leave(iDebuggerInterceptor, this, environment, function2, (Object)d);
        }
        if (object2 instanceof Float) {
            Float f2 = new Float(Math.abs(((Float)object2).floatValue()));
            return Debugger.leave(iDebuggerInterceptor, this, environment, function2, (Object)f2);
        }
        if (object2 instanceof BigInteger) {
            BigInteger bigInteger = ((BigInteger)object2).abs();
            return Debugger.leave(iDebuggerInterceptor, this, environment, function2, (Object)bigInteger);
        }
        if (object2 instanceof BigDecimal) {
            BigDecimal bigDecimal = ((BigDecimal)object2).abs();
            return Debugger.leave(iDebuggerInterceptor, this, environment, function2, (Object)bigDecimal);
        }
        throw new UnsupportedOperationException("Absolute value is not supported on type " + object2.getClass());
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction2) {
        AbsoluteValueInstruction absoluteValueInstruction = new AbsoluteValueInstruction(instruction2);
        AbsoluteValueInstruction.propagateInfo(this, absoluteValueInstruction);
        return absoluteValueInstruction;
    }
}

