/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.drivers;

import com.ibm.xltxe.rnm1.fcg.FcgAttrs;
import com.ibm.xltxe.rnm1.fcg.FcgClassCollector;
import com.ibm.xltxe.rnm1.fcg.FcgClassGen;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgCodeGen;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgMethodGen;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.fcg.impl.HiddenOptions;
import com.ibm.xltxe.rnm1.fcg.javasrc.FcgClassGenJavaSrc;
import com.ibm.xltxe.rnm1.xylem.AbstractTypeStore;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IdentifierConsolidator;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.ModuleLinker;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.PolymorphicADTDesugarer;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.JavaC;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.commandline.CommandLineParserMultipleInputFile;
import com.ibm.xltxe.rnm1.xylem.drivers.IXylemDriver;
import com.ibm.xltxe.rnm1.xylem.optimizers.DeadLetEliminatorOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.SplitFunctions;
import com.ibm.xltxe.rnm1.xylem.optimizers.TerminalLetOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationOptimizer;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Linker
implements IXylemDriver {
    static final boolean SHOW_CPP_RESULT = false;
    private static final Logger s_logger = LoggerUtil.getLogger(Linker.class);
    private static final String s_className = Linker.class.getName();
    public ModuleSignatureStore m_mss;
    public static final String JAVADESTDIR_OPTION = "javeDestDir";
    public static final String relativeDir = HiddenOptions.getStringValue("javeDestDir", ".");
    public File m_outputDir = new File(relativeDir).getAbsoluteFile();
    public boolean m_isPerf;
    public boolean m_dumpXylem;
    public boolean m_dumpIntermediateXylem;
    public CodeGenerationSettings m_codeGenerationSettings = new CodeGenerationSettings();

    protected void optimize(Module module, Function function2) {
    }

    public static void main(String[] stringArray) {
        Linker linker;
        SessionContext sessionContext = new SessionContext();
        CLP cLP = new CLP();
        cLP.m_linker = linker = new Linker();
        if (!cLP.parseCommandLine(stringArray)) {
            System.exit(-1);
        }
        try {
            cLP.m_signatureSearchPath.addFirst(new File(".").toURL());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        linker.m_mss = new ModuleSignatureStore(cLP.m_signatureSearchPath);
        linker.m_dumpXylem = linker.m_codeGenerationSettings.m_dumpxylem;
        linker.m_dumpIntermediateXylem = cLP.m_dumpIntermediateXylem;
        linker.m_isPerf = cLP.m_isPerf;
        try {
            File file = linker.linkFiles(cLP.m_files, cLP.m_className, null, null, 1, sessionContext);
            if (file != null && !linker.m_codeGenerationSettings.getJavaCSettings().isJavaCDisabled()) {
                JavaC.compile(file.getParentFile(), new String[]{file.getName()}, linker.m_outputDir, null, linker.m_codeGenerationSettings.getJavaCSettings());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public File linkFiles(List list, String string2, String string3, Collection collection2, int n2, SessionContext sessionContext) {
        LinkedList<Module> linkedList = new LinkedList<Module>();
        for (URL uRL : list) {
            s_logger.logp(Level.INFO, s_className, "linkFiles", "linking " + uRL.getPath());
            try {
                Module module = Module.loadCompiled(uRL, this.m_mss);
                linkedList.add(module);
            }
            catch (Exception exception) {
                s_logger.logp(Level.SEVERE, s_className, "linkFiles", "", exception);
                throw new Error();
            }
        }
        return this.linkModules(linkedList, string2, string3, collection2, n2, sessionContext);
    }

    public File linkModules(List list, String string2, String string3, Collection collection2, int n2, SessionContext sessionContext) {
        Object object22;
        Serializable serializable;
        Program program = null;
        Iterator iterator = list.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            serializable = (Module)iterator.next();
            if (!(serializable instanceof Program)) continue;
            if (program != null) {
                s_logger.logp(Level.WARNING, s_className, "linkModules", "Program conflict noted: " + serializable.getName() + " dominates over " + program.getName());
            }
            program = (Program)serializable;
        }
        if (program == null) {
            serializable = new ModuleSignature("");
            program = new Program((ModuleSignature)serializable);
        } else {
            bl = true;
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            program.addModule((Module)iterator.next());
        }
        if (bl) {
            ModuleLinker.reflattenModules(program);
        } else {
            ModuleLinker.flattenModules(program);
        }
        program.expandTypeAliases();
        serializable = null;
        Object object3 = null;
        for (Object object22 : list) {
            s_logger.logp(Level.INFO, s_className, "linkModules", "checking " + ((AbstractTypeStore)object22).getName());
            if (serializable != null || (serializable = program.getFunction(ModuleImportDirective.translateFunctionName("main", (Module)object22))) == null) continue;
            object3 = object22;
            break;
        }
        if (object3 == null) {
            s_logger.logp(Level.SEVERE, s_className, "linkModules", "no primary module found");
            return null;
        }
        object22 = null;
        if (serializable != null) {
            object22 = ModuleImportDirective.translateFunctionName("main", object3);
            program.forceFunctionGeneration(program.getFunction((String)object22));
        }
        if (collection2 != null) {
            for (Object object4 : collection2) {
                program.forceFunctionGeneration(program.getFunction((String)object4));
            }
        }
        if (this.m_dumpIntermediateXylem) {
            s_logger.logp(Level.INFO, s_className, "linkModules", "Dumping pre-optimization Xylem code");
            if (string2 == null) {
                string2 = ((AbstractTypeStore)object3).getName();
            }
            Program.dumpXylemFile(program, this.m_outputDir, string2 + ".preopt");
        }
        try {
            Object object4;
            program.typeCheckReduced();
            program.removeDeadFunctions();
            program.instantiateReducedPolymorphicFunctions();
            program.removeDeadFunctions();
            this.desugar(program);
            if (string2 == null) {
                string2 = ((AbstractTypeStore)object3).getName();
            }
            program.setClassName(string2);
            program.removeDeadFunctions();
            Object object5 = new HashSet();
            object5.add(string2 + "$main");
            object4 = new IdentifierConsolidator();
            Object object6 = new PartialEvaluationOptimizer((Set)object5, new CodeGenerationSettings());
            ((PartialEvaluationOptimizer)object6).m_ic = object4;
            program.optimize((Optimizer)object6);
            object6 = new PartialEvaluationOptimizer((Set)object5, new CodeGenerationSettings());
            ((PartialEvaluationOptimizer)object6).m_ic = object4;
            program.optimize((Optimizer)object6);
            program.optimize(new TerminalLetOptimizer());
            if (this.m_codeGenerationSettings.getPostReductionSplitLimit() > 0) {
                program.optimize(new SplitFunctions((Module)program, this.m_codeGenerationSettings.getPostReductionSplitLimit()));
                DeadLetEliminatorOptimizer.eliminateDeadLets(program);
            }
            this.optimize(program, (Function)serializable);
            if (this.m_dumpXylem) {
                s_logger.logp(Level.INFO, s_className, "linkModules", "Dumping Xylem code to " + new File(this.m_outputDir, string2));
                Program.dumpXylemFile(program, this.m_outputDir, string2);
            }
            switch (this.m_codeGenerationSettings.getTargetLanguage()) {
                case 3: 
                case 4: {
                    object5 = this.m_codeGenerationSettings.getTargetLanguage() == 3 ? ".java" : ".class";
                    object4 = new File(this.m_outputDir, string2 + (String)object5);
                    object6 = new FileWriter((File)object4);
                    PrintWriter printWriter = new PrintWriter((Writer)object6);
                    s_logger.logp(Level.INFO, s_className, "linkModules", "Starting generation");
                    FcgClassCollector fcgClassCollector = new FcgClassCollector((String)object5){
                        final /* synthetic */ String val$fnameExtension;
                        {
                            this.val$fnameExtension = string2;
                        }

                        @Override
                        public void acceptGeneratedClass(FcgClassGen fcgClassGen) {
                            try {
                                fcgClassGen.dump(new File(Linker.this.m_outputDir, fcgClassGen.getClassType().getTypeName() + this.val$fnameExtension));
                            }
                            catch (IOException iOException) {
                                s_logger.logp(Level.SEVERE, s_className, "linkModules", "I/O error", iOException);
                            }
                        }
                    };
                    FcgCodeGenHelper fcgCodeGenHelper = FcgCodeGenHelper.createFcgCodeGenHelper(string2 + "_Common", null, this.m_codeGenerationSettings, fcgClassCollector);
                    program.generateCode(fcgCodeGenHelper, sessionContext);
                    FcgCodeGen fcgCodeGen = fcgCodeGenHelper.getFcgCodeGen();
                    FcgClassGenJavaSrc fcgClassGenJavaSrc = null;
                    FcgClassReferenceType fcgClassReferenceType = fcgCodeGenHelper.getClassReferenceType(string2);
                    FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGenHelper.getClassReferenceType(string2 + "_Common");
                    fcgClassGenJavaSrc = new FcgClassGenJavaSrc(fcgCodeGen, fcgClassReferenceType, fcgClassReferenceType2, string2 + ".java", null, null);
                    FcgMethodGen fcgMethodGen = fcgClassGenJavaSrc.newMethodGen(FcgAttrs.PUBLIC_STATIC, FcgType.VOID, "main");
                    fcgMethodGen.addParameter(FcgType.STRING_ARRAY, "argv");
                    FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
                    fcgInstructionList.beginMethod();
                    fcgInstructionList.createObjectExpr((FcgType)fcgClassReferenceType, 0);
                    FcgVariable fcgVariable = fcgInstructionList.defineVar(fcgClassReferenceType, "instance", true);
                    fcgInstructionList.loadVar(fcgVariable);
                    String string4 = Function.generateFunctionName(fcgCodeGenHelper, (String)object22);
                    fcgInstructionList.invokeClassMethod(fcgClassReferenceType, string4, null, 1);
                    fcgInstructionList.printOut();
                    fcgInstructionList.returnInstruction();
                    fcgInstructionList.endMethod();
                    fcgClassCollector.acceptGeneratedClass(fcgClassGenJavaSrc);
                    printWriter.flush();
                    printWriter.close();
                    return object4;
                }
            }
            throw new XylemError("ERR_SYSTEM", "Unsupported target language");
        }
        catch (Throwable throwable) {
            s_logger.logp(Level.SEVERE, s_className, "linkModules", "Error occurred during linking", throwable);
            return null;
        }
    }

    protected void desugar(Program program) {
        new PolymorphicADTDesugarer(program).desugar();
    }

    public static class CLP
    extends CommandLineParserMultipleInputFile {
        public Linker m_linker;
        public String m_className;
        public boolean m_dumpIntermediateXylem = false;
        public boolean m_isPerf = false;
        public String m_pkgName = null;

        @Override
        protected int parseOption(String[] stringArray, int n2) {
            if (stringArray[n2].equals("-help") || stringArray[n2].equals("-?") || stringArray[n2].equals("-h")) {
                System.out.println("Usage: Linker\n\t[-classname name]\n\t[-packagename name]\n\t[-dumpIntermediateXylem]\n\t[-d outputDir]");
                this.m_linker.m_codeGenerationSettings.parseOption(stringArray, n2);
                super.parseOption(stringArray, n2);
                System.out.println("Input files should be *.cxo");
                return -1;
            }
            if (stringArray[n2].equals("-classname")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-classname missing parameter");
                    return -1;
                }
                this.m_className = stringArray[n2];
                return n2;
            }
            if (stringArray[n2].equals("-packagename")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-packagename missing parameter");
                    return -1;
                }
                this.m_pkgName = stringArray[n2];
                return n2;
            }
            if (stringArray[n2].equals("-javac")) {
                s_logger.logp(Level.INFO, s_className, "parseOption", "-javac is now default; use -disablejavac to suppress");
                return n2;
            }
            if (stringArray[n2].equals("-dumpIntermediateXylem")) {
                this.m_dumpIntermediateXylem = true;
                return n2;
            }
            if (stringArray[n2].equals("-d")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-d missing parameter");
                    return -1;
                }
                this.m_linker.m_outputDir = new File(stringArray[n2]).getAbsoluteFile();
                return n2;
            }
            if (stringArray[n2].equals("-perf")) {
                this.m_isPerf = true;
                return n2;
            }
            int n3 = this.m_linker.m_codeGenerationSettings.parseOption(stringArray, n2);
            if (n3 == -1) {
                return -1;
            }
            if (n3 != -2) {
                return n3;
            }
            return super.parseOption(stringArray, n2);
        }
    }
}

