/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.drivers;

import com.ibm.xltxe.rnm1.xylem.AbstractTypeStore;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.commandline.CommandLineParserMultipleInputFile;
import com.ibm.xltxe.rnm1.xylem.commandline.SearchPathSourceResolver;
import com.ibm.xltxe.rnm1.xylem.drivers.IXylemDriver;
import com.ibm.xltxe.rnm1.xylem.optimizers.VDTMapOptimizer;
import com.ibm.xltxe.rnm1.xylem.parser.Parser;
import com.ibm.xltxe.rnm1.xylem.parser.ParserSource;
import com.ibm.xml.ras.LoggerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Compiler
implements IXylemDriver {
    private static final Logger s_logger = LoggerUtil.getLogger(Compiler.class);
    private static final String s_className = Compiler.class.getName();
    public ModuleSignatureStore m_mss;
    public File m_outputDir = new File(".").getAbsoluteFile();

    public static void main(String[] stringArray) {
        CLP cLP = new CLP();
        Compiler compiler = cLP.m_compiler = new Compiler();
        if (!cLP.parseCommandLine(stringArray)) {
            System.exit(-1);
        }
        try {
            cLP.m_signatureSearchPath.addFirst(new File(".").toURL());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        compiler.m_mss = new ModuleSignatureStore(cLP.m_signatureSearchPath);
        try {
            List list = compiler.compileFiles(cLP, null, true, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public List compileFiles(CLP cLP, Collection collection2, boolean bl, boolean bl2) {
        LinkedList<Module> linkedList = new LinkedList<Module>();
        for (URL uRL : cLP.m_files) {
            s_logger.logp(Level.INFO, s_className, "compileFiles", "compiling " + uRL.getPath());
            try {
                Module module = this.handleFile(uRL, cLP, bl);
                if (!bl2) continue;
                linkedList.add(module);
            }
            catch (Exception exception) {
                s_logger.logp(Level.SEVERE, s_className, "compileFiles", "", exception);
                throw new Error();
            }
        }
        return bl2 ? linkedList : null;
    }

    protected Module handleFile(URL uRL, CLP cLP, boolean bl) {
        String string2 = uRL.toString();
        if (string2.endsWith(".xylem")) {
            String string3;
            Object object2;
            ModuleSignature moduleSignature = null;
            try {
                object2 = uRL.getPath();
                object2 = ((String)object2).substring(((String)object2).lastIndexOf("/") + 1);
                moduleSignature = this.m_mss.resolveModuleSignature(((String)object2).substring(0, ((String)object2).length() - 6));
            }
            catch (Exception exception) {
                s_logger.logp(Level.SEVERE, s_className, "handleFile", "Error reading compiled interface file", exception);
                System.exit(-1);
            }
            object2 = null;
            try {
                object2 = this.compile(uRL, moduleSignature, cLP.m_signatureSearchPath, this.m_mss);
            }
            catch (Exception exception) {
                s_logger.logp(Level.SEVERE, s_className, "handleFile", "Error occurred during compilation of " + uRL, exception);
                System.exit(-1);
            }
            if (((AbstractTypeStore)object2).getName().equals("")) {
                string3 = uRL.getPath();
                string3 = string3.substring(string3.lastIndexOf("/") + 1);
                ((AbstractTypeStore)object2).setName(string3);
            }
            if (((AbstractTypeStore)object2).getName().endsWith(".xylem")) {
                string3 = ((AbstractTypeStore)object2).getName();
                string3 = string3.substring(0, string3.lastIndexOf(".xylem"));
                ((AbstractTypeStore)object2).setName(string3);
            }
            if (bl) {
                Object object3;
                string3 = ((AbstractTypeStore)object2).getName() + ".cxo";
                try {
                    object3 = new File(string3);
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream((File)object3));
                    Module.writeModule(objectOutputStream, (Module)object2);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                }
                catch (Exception exception) {
                    s_logger.logp(Level.SEVERE, s_className, "handleFile", "Error occurred writing of compiled module to " + string3, exception);
                    System.exit(-1);
                }
                object3 = ModuleSignatureStore.makeFilename(((AbstractTypeStore)object2).getName()) + ".cxi";
                Compiler.writeOutSignature(((Module)object2).m_signature, (String)object3);
            }
            return object2;
        }
        if (string2.endsWith(".xylemi")) {
            ModuleSignature moduleSignature = null;
            try {
                moduleSignature = Compiler.compileSignature(uRL, cLP.m_signatureSearchPath, this.m_mss);
            }
            catch (Exception exception) {
                s_logger.logp(Level.SEVERE, s_className, "handleFile", "Error occurred during compilation of signature " + uRL, exception);
                System.exit(-1);
            }
            if (bl) {
                String string4 = ModuleSignatureStore.makeFilename(moduleSignature.getName()) + ".cxi";
                Compiler.writeOutSignature(moduleSignature, string4);
            }
            return null;
        }
        s_logger.logp(Level.WARNING, s_className, "handleFile", "Ignoring file with unrecognized extension: " + uRL);
        return null;
    }

    public Module compile(URL uRL, ModuleSignature moduleSignature, List list, ModuleSignatureStore moduleSignatureStore) throws Exception {
        return this.compile(moduleSignature, new Parser(new SearchPathSourceResolver(list), new ParserSource(uRL), moduleSignatureStore));
    }

    public Module compile(ModuleSignature moduleSignature, Parser parser) throws Exception {
        Module module = parser.parseModule(moduleSignature);
        if (moduleSignature == null) {
            module.exportAllSymbols();
        }
        module.typeCheck();
        if (moduleSignature == null) {
            for (String string2 : new HashSet<String>(module.m_signature.m_functionSignatures.keySet())) {
                module.m_signature.addFunctionSignature(new FunctionSignature(module.getFunction(string2)));
            }
        }
        module.reduce();
        if (module.getVDTMap() != null) {
            Object object2 = new VDTMapOptimizer(module.getVDTMap());
            module.optimize((Optimizer)object2);
            ((VDTMapOptimizer)object2).doUpdate(module);
            object2 = null;
        }
        return module;
    }

    public static final ModuleSignature compileSignature(URL uRL, List list, ModuleSignatureStore moduleSignatureStore) throws Exception {
        ParserSource parserSource = new ParserSource(uRL);
        Parser parser = new Parser(new SearchPathSourceResolver(list), parserSource, moduleSignatureStore);
        return Compiler.compileSignature(uRL, parser);
    }

    public static final ModuleSignature compileSignature(URL uRL, Parser parser) throws Exception {
        ParserSource parserSource = new ParserSource(uRL);
        ModuleSignature moduleSignature = parser.parseExternalModuleSignature(parserSource);
        return moduleSignature;
    }

    public static final void writeOutSignature(ModuleSignature moduleSignature, String string2) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string2));
            moduleSignature.write(objectOutputStream);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "writeOutSignature", "Error occurred writing of compiled signature to " + string2, exception);
            System.exit(-1);
        }
    }

    public static final void writeOutSignature(ModuleSignature moduleSignature, String string2, File file) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(new File(file, string2)));
            moduleSignature.write(objectOutputStream);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "writeOutSignature", "Error occurred writing of compiled signature to " + string2, exception);
            System.exit(-1);
        }
    }

    public static class CLP
    extends CommandLineParserMultipleInputFile {
        public Compiler m_compiler;

        @Override
        protected int parseOption(String[] stringArray, int n2) {
            if (stringArray[n2].equals("-help") || stringArray[n2].equals("-?") || stringArray[n2].equals("-h")) {
                System.out.println("Usage: Compiler");
                super.parseOption(stringArray, n2);
                System.out.println("Input files should be be *.xylem or *.xylemi");
                return -1;
            }
            return super.parseOption(stringArray, n2);
        }
    }
}

