/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.commandline;

import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.commandline.CommandLineParserSingleInputFile;
import com.ibm.xml.ras.LoggerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XylemP
extends CommandLineParserSingleInputFile {
    private static final Logger s_logger = LoggerUtil.getLogger(XylemP.class);
    private static final String s_className = XylemP.class.getName();
    private static final int XYLEM = 0;
    private static final int XYLEMQ = 1;
    private static final int XYLEMML = 2;
    private static int m_language = 0;
    private ArrayList m_files = new ArrayList();
    private File m_outputDir = null;
    private PrintWriter m_currentPrintWriter = null;

    @Override
    protected int parseOption(String[] stringArray, int n2) {
        if (stringArray[n2].equals("-help") || stringArray[n2].equals("-?") || stringArray[n2].equals("-h")) {
            System.out.println("Usage: XylemP [-q] [-ml] [-I searchpath] [-output dirname] (file.cxo)*");
            return -1;
        }
        if ("-q".equals(stringArray[n2])) {
            m_language = 1;
            return n2;
        }
        if ("-ml".equals(stringArray[n2])) {
            m_language = 2;
            return n2;
        }
        if ("-output".equals(stringArray[n2]) || "--output".equals(stringArray[n2])) {
            if (++n2 == stringArray.length) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "-output missing parameter");
                return -1;
            }
            this.m_outputDir = new File(stringArray[n2]);
            if (!this.m_outputDir.exists() || !this.m_outputDir.isDirectory()) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "Directory " + this.m_outputDir + " does not exist");
                return -1;
            }
            return n2;
        }
        this.m_inputFile = this.validateInputFilename(stringArray[n2], false);
        if (this.m_inputFile == null) {
            return -1;
        }
        this.m_files.add(this.m_inputFile);
        return n2;
    }

    public static void main(String[] stringArray) {
        new XylemP(stringArray);
    }

    public XylemP(String[] stringArray) {
        if (!this.parseCommandLine(stringArray)) {
            return;
        }
        try {
            this.m_signatureSearchPath.addFirst(new File(".").toURL());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        ModuleSignatureStore moduleSignatureStore = new ModuleSignatureStore(this.m_signatureSearchPath);
        Iterator iterator = this.m_files.iterator();
        while (iterator.hasNext()) {
            URL uRL = (URL)iterator.next();
            this.m_signatureSearchPath.addFirst(uRL);
            try {
                String string2 = new File(uRL.getPath()).getName();
                string2 = string2.substring(0, string2.lastIndexOf(".cxo"));
                Module module = Module.loadCompiled(uRL, moduleSignatureStore);
                switch (m_language) {
                    case 0: {
                        this.println(string2, module.toString());
                        if (!iterator.hasNext()) break;
                        this.println(null, ";; ============================================");
                        break;
                    }
                    case 2: {
                        s_logger.logp(Level.SEVERE, s_className, "XylemP", "XylemML output not supported.");
                        throw new Error("XylemML output not supported.");
                    }
                    case 1: {
                        try {
                            Class<?> clazz = Class.forName("com.ibm.xltxe.rnm1.xylem.xylemq.parser.QPrettyPrint");
                            Method method = clazz.getMethod("printModule", Module.class, PrintStream.class);
                            if (null != this.m_outputDir) {
                                File file = new File(this.m_outputDir, string2 + ".xylemq");
                                PrintStream printStream = new PrintStream(new FileOutputStream(file));
                                method.invoke(null, module, printStream);
                                break;
                            }
                            method.invoke(null, module, System.out);
                            if (iterator.hasNext()) {
                                this.println(null, "// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
                            }
                            break;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            s_logger.logp(Level.SEVERE, s_className, "XylemP", "Can't do XylemQ pretty print without QPrettyPrint");
                            throw new Error("Can't do XylemQ pretty print without QPrettyPrint");
                        }
                    }
                }
            }
            catch (Exception exception) {
                s_logger.logp(Level.SEVERE, s_className, "XylemP", "Error converting CXO to Module", exception);
                throw new Error("Error converting CXO to Module");
            }
            this.m_signatureSearchPath.removeFirst();
        }
    }

    private void println(String string2, String string3) {
        if (null != this.m_outputDir) {
            if (null == this.m_currentPrintWriter) {
                try {
                    File file = new File(this.m_outputDir, string2 + ".xylem");
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                        s_logger.logp(Level.FINE, s_className, "println", "Dumping program to file " + file);
                    }
                    FileWriter fileWriter = new FileWriter(file);
                    this.m_currentPrintWriter = new PrintWriter(fileWriter);
                    this.m_currentPrintWriter.write(string3);
                    this.m_currentPrintWriter.close();
                    this.m_currentPrintWriter = null;
                }
                catch (IOException iOException) {
                    s_logger.logp(Level.SEVERE, s_className, "println", "i/o error", iOException);
                }
            }
        } else {
            System.out.println(string3);
        }
    }
}

