/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.commandline;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IContext;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.ModuleLinker;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PolymorphicADTDesugarer;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.commandline.XylemC;
import com.ibm.xltxe.rnm1.xylem.instructions.EvalInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.parser.Parser;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.BasicDynamicContext;
import com.ibm.xml.xci.exec.DynamicContext;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XylemInterpreter
extends XylemC {
    private static final Logger s_logger = LoggerUtil.getLogger(XylemInterpreter.class);
    private static final String s_className = XylemInterpreter.class.getName();
    protected boolean m_debugger;
    protected String m_function;
    protected ArrayList m_args;

    public XylemInterpreter(String[] stringArray) {
        super(stringArray);
    }

    public static void main(String[] stringArray) {
        new XylemInterpreter(stringArray);
    }

    @Override
    public void init(String[] stringArray) {
        this.m_function = "main";
        this.m_args = new ArrayList();
        this.m_debugger = false;
        super.init(stringArray);
    }

    @Override
    public Module compile(ModuleSignature moduleSignature, Parser parser) throws Exception {
        return super.compile(moduleSignature, parser);
    }

    @Override
    protected int parseOption(String[] stringArray, int n2) {
        if (stringArray[n2].equals("-debug")) {
            this.m_debugger = true;
            return n2;
        }
        if (stringArray[n2].equals("-function")) {
            this.m_function = stringArray[++n2];
            return n2;
        }
        if (stringArray[n2].equals("-arg")) {
            String string2;
            if ((string2 = stringArray[++n2]).equals("{")) {
                StringBuffer stringBuffer = new StringBuffer();
                while (!stringArray[++n2].equals("}")) {
                    stringBuffer.append(stringArray[n2]);
                    stringBuffer.append(" ");
                }
                string2 = stringBuffer.toString();
            }
            this.m_args.add(string2);
            return n2;
        }
        if (stringArray[n2].equals("-help") || stringArray[n2].equals("-?") || stringArray[n2].equals("-h")) {
            System.out.println("Usage: XylemInterpreter [-debug] [-function main] ([-arg {script}])* (file.xylem | file.xylemi | file.cxo)*");
            return -1;
        }
        return super.parseOption(stringArray, n2);
    }

    @Override
    public void run() {
        Object object22;
        for (Object object22 : this.m_files) {
            this.m_signatureSearchPath.addFirst(object22);
            this.handleFile((URL)object22, this.m_optimizationLevel);
            this.m_signatureSearchPath.removeFirst();
        }
        object22 = new SessionContext();
        BasicDynamicContext basicDynamicContext = new BasicDynamicContext((SessionContext)object22);
        this.evaluate(basicDynamicContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(DynamicContext dynamicContext) {
        Object object2;
        Module module4;
        Module module2;
        Serializable serializable2;
        Module module3 = null;
        LinkedList<Module> linkedList = new LinkedList<Module>();
        for (Serializable serializable2 : this.m_filesToLink) {
            try {
                module2 = Module.loadCompiled((URL)serializable2, this.m_mss);
                if (module2 instanceof Program) {
                    module3 = (Program)module2;
                    continue;
                }
                linkedList.add(module2);
            }
            catch (Exception exception) {
                s_logger.logp(Level.SEVERE, s_className, "evaluate", "", exception);
                throw new Error();
            }
        }
        if (module3 == null) {
            serializable2 = new ModuleSignature("");
            module3 = new Program((ModuleSignature)serializable2);
        }
        Iterator<Object> iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            module3.addModule((Module)iterator.next());
        }
        try {
            module3.typeCheckReduced();
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "evaluate", "", exception);
            throw new Error(exception.getMessage());
        }
        Program.dumpXylemFile(module3, null, "program-preflatten");
        ModuleLinker.reflattenModules((Program)module3);
        Program.dumpXylemFile(module3, null, "program-postflatten");
        serializable2 = null;
        module2 = null;
        for (Module module4 : module3.getModules()) {
            s_logger.logp(Level.INFO, s_className, "evaluate", "checking " + module4.getName());
            if (serializable2 != null || (serializable2 = module3.getFunction(ModuleImportDirective.translateFunctionName(this.m_function, module4))) == null) continue;
            module2 = module4;
        }
        module4 = null;
        if (serializable2 == null) {
            Program.dumpXylemFile(module3, null, "program");
            throw new XylemError("ERR_SYSTEM", "function '" + this.m_function + "' not found");
        }
        try {
            module3.exportAllSymbols();
            module3.clearTypeInformation(true);
            module3.typeCheckReduced();
            module3.removeDeadFunctions();
            module3.instantiateReducedPolymorphicFunctions();
            module3.removeDeadFunctions();
            new PolymorphicADTDesugarer(module3).desugar();
            object2 = ((Function)serializable2).getName();
            ((Program)module3).setClassName((String)object2);
            module3.removeDeadFunctions();
            module3.typeCheckReduced();
            ((Function)serializable2).typeCheckReduced(module3, new LinkedList());
        }
        catch (Exception exception) {
            Program.dumpXylemFile(module3, null, "program");
            s_logger.logp(Level.SEVERE, s_className, "evaluate", "error typechecking module", exception);
            throw new XylemError("ERR_SYSTEM", "!");
        }
        object2 = null;
        Environment environment = new Environment(dynamicContext);
        if (this.m_debugger) {
            object2 = new Debugger(module3);
            object2.enterContext((IContext)((Object)serializable2));
        }
        if (this.m_args.size() != ((Function)serializable2).m_parameters.length) {
            throw new XylemError("ERR_SYSTEM", "Wrong number of args for " + ((Function)serializable2).getName() + ", " + "got " + this.m_args.size() + ", need " + ((Function)serializable2).m_parameters.length);
        }
        environment.establishStackFrame(((Function)serializable2).getStackFrameSize());
        environment.pushForkScope();
        Object object3 = null;
        try {
            for (int i = 0; i < ((Function)serializable2).m_parameters.length; ++i) {
                EvalInstruction evalInstruction = new EvalInstruction(((Function)serializable2).m_parameters[i].getBindingType(), (String)this.m_args.get(i));
                Object object4 = ((Instruction)evalInstruction).evaluate(environment, (Function)serializable2, (IDebuggerInterceptor)object2, false);
                Binding binding = ((Function)serializable2).m_parameters[i];
                environment.bindInEstablishedFrame(binding, object4);
            }
            environment.pushStackFrame();
            object3 = ((Function)serializable2).getBody().evaluate(environment, (Function)serializable2, (IDebuggerInterceptor)object2, false);
            if (this.m_debugger) {
                object2.leaveContext((IContext)((Object)serializable2), object3);
            } else {
                System.out.println("result = " + object3);
            }
            environment.popStackFrame();
            environment.popForkScope(object3);
            environment.release(object3);
        }
        catch (Throwable throwable) {
            environment.popForkScope(object3);
            environment.release(object3);
            throw throwable;
        }
    }
}

