/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.commandline;

import com.ibm.xltxe.rnm1.xylem.AbstractTypeStore;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.codegen.JavaC;
import com.ibm.xltxe.rnm1.xylem.codegen.JavaCSettings;
import com.ibm.xltxe.rnm1.xylem.commandline.CommandLineParserSingleInputFile;
import com.ibm.xltxe.rnm1.xylem.commandline.SearchPathSourceResolver;
import com.ibm.xltxe.rnm1.xylem.drivers.Linker;
import com.ibm.xltxe.rnm1.xylem.optimizers.VDTMapOptimizer;
import com.ibm.xltxe.rnm1.xylem.parser.Parser;
import com.ibm.xltxe.rnm1.xylem.parser.ParserSource;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XylemC
extends CommandLineParserSingleInputFile {
    private static final Logger s_logger = LoggerUtil.getLogger(XylemC.class);
    private static final String s_className = XylemC.class.getName();
    public static XylemC XYLEMC = new XylemC();
    public ArrayList m_files = new ArrayList();
    int m_dumpLevel = 0;
    boolean m_compileOnly = false;
    String m_packageName = null;
    boolean m_javac = true;
    protected File m_outputDir = new File(".");
    boolean m_isPerf = false;
    public int m_optimizationLevel;
    protected ModuleSignatureStore m_mss;
    protected ArrayList m_filesToLink = new ArrayList();

    @Override
    protected int parseOption(String[] stringArray, int n2) {
        if (stringArray[n2].equals("-help") || stringArray[n2].equals("-?") || stringArray[n2].equals("-h")) {
            System.out.println("Usage: XylemC [-disablejavac] [-c] [-O] [-O2] [-I searchpath] [-package packagename] [-output dirname] (file.xylem | file.xylemi)*");
            System.out.println(" -d/--dump to dump final xylem, twice (-d -d) to also dump intermediate xylem");
            return -1;
        }
        if ("-c".equals(stringArray[n2])) {
            this.m_compileOnly = true;
            return n2;
        }
        if ("-d".equals(stringArray[n2]) || "--dump".equals(stringArray[n2])) {
            ++this.m_dumpLevel;
            return n2;
        }
        if ("-javac".equals(stringArray[n2]) || "--javac".equals(stringArray[n2])) {
            s_logger.logp(Level.INFO, s_className, "parseOption", "-javac is now the default; use -disablejavac to prevent classfile generation");
            return n2;
        }
        if ("-disablejavac".equals(stringArray[n2]) || "--disablejavac".equals(stringArray[n2])) {
            this.m_javac = false;
            return n2;
        }
        if ("-perf".equals(stringArray[n2]) || "--perf".equals(stringArray[n2])) {
            this.m_isPerf = true;
            return n2;
        }
        if ("-package".equals(stringArray[n2]) || "--package".equals(stringArray[n2])) {
            if (++n2 == stringArray.length) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "-package missing parameter");
                return -1;
            }
            this.m_packageName = stringArray[n2];
            return n2;
        }
        if ("-output".equals(stringArray[n2]) || "--output".equals(stringArray[n2])) {
            if (++n2 == stringArray.length) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "-output missing parameter");
                return -1;
            }
            this.m_outputDir = new File(stringArray[n2]);
            if (!this.m_outputDir.exists() || !this.m_outputDir.isDirectory()) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "Directory " + this.m_outputDir + " does not exist");
                return -1;
            }
            return n2;
        }
        if ("-I".equals(stringArray[n2])) {
            if (++n2 == stringArray.length) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "-I missing parameter");
                return -1;
            }
            for (String string2 : XylemC.separatePath(stringArray[n2])) {
                File file = new File(string2);
                if (!file.exists() || !file.isDirectory()) {
                    s_logger.logp(Level.WARNING, s_className, "parseOption", "Directory " + string2 + " not found; ignoring");
                    continue;
                }
                try {
                    this.m_signatureSearchPath.add(file.toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
            return n2;
        }
        if ("-O".equals(stringArray[n2])) {
            this.m_optimizationLevel = 1;
            return n2;
        }
        if ("-O2".equals(stringArray[n2])) {
            this.m_optimizationLevel = 2;
            return n2;
        }
        this.m_inputFile = this.validateInputFilename(stringArray[n2], false);
        if (this.m_inputFile == null) {
            return -1;
        }
        this.m_files.add(this.m_inputFile);
        return n2;
    }

    public static void main(String[] stringArray) {
        new XylemC(stringArray);
    }

    public XylemC(String[] stringArray) {
        this.init(stringArray);
        this.run();
    }

    private XylemC() {
    }

    public void init(String[] stringArray) {
        if (!this.parseCommandLine(stringArray)) {
            return;
        }
        try {
            this.m_signatureSearchPath.addFirst(new File(".").toURL());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        this.m_mss = new ModuleSignatureStore(this.m_signatureSearchPath);
    }

    public void run() {
        Serializable serializable;
        Iterator iterator = this.m_files.iterator();
        SessionContext sessionContext = new SessionContext();
        while (iterator.hasNext()) {
            serializable = (URL)iterator.next();
            this.m_signatureSearchPath.addFirst(serializable);
            this.handleFile((URL)serializable, this.m_optimizationLevel);
            this.m_signatureSearchPath.removeFirst();
        }
        if (!this.m_compileOnly && !this.m_filesToLink.isEmpty()) {
            serializable = this.link(this.m_filesToLink, this.m_mss, null, null, this.m_packageName, this.m_outputDir, this.m_isPerf, sessionContext);
            if (serializable == null) {
                System.exit(-1);
            } else {
                JavaC.compile(((File)serializable).getParentFile(), new String[]{((File)serializable).getName()}, this.m_outputDir, null, new JavaCSettings());
            }
        }
    }

    protected void handleFile(URL uRL, int n2) {
        String string2 = uRL.toString();
        if (string2.endsWith(".xylem")) {
            Object object2;
            String string3;
            Object object3;
            ModuleSignature moduleSignature = null;
            try {
                object3 = uRL.getPath();
                moduleSignature = this.m_mss.resolveModuleSignature(((String)object3).substring(0, ((String)object3).length() - 6));
            }
            catch (Exception exception) {
                s_logger.logp(Level.SEVERE, s_className, "handleFile", "Error reading compiled interface file", exception);
                System.exit(-1);
            }
            object3 = null;
            try {
                object3 = this.compile(uRL, moduleSignature, this.m_signatureSearchPath, this.m_mss);
            }
            catch (Exception exception) {
                s_logger.logp(Level.SEVERE, s_className, "handleFile", "Error occurred during compilation of " + uRL, exception);
                System.exit(-1);
            }
            if (((AbstractTypeStore)object3).getName().equals("")) {
                string3 = uRL.getPath();
                string3 = string3.substring(string3.lastIndexOf("/") + 1);
                string3 = string3.substring(0, string3.lastIndexOf(".xylem"));
                ((AbstractTypeStore)object3).setName(string3);
            }
            string3 = ((AbstractTypeStore)object3).getName() + ".cxo";
            try {
                object2 = new File(string3);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream((File)object2));
                Module.writeModule(objectOutputStream, (Module)object3);
                objectOutputStream.flush();
                objectOutputStream.close();
                this.m_filesToLink.add(((File)object2).toURL());
            }
            catch (Exception exception) {
                s_logger.logp(Level.SEVERE, s_className, "handleFile", "Error occurred writing of compiled module to " + string3, exception);
                System.exit(-1);
            }
            object2 = ModuleSignatureStore.makeFilename(((AbstractTypeStore)object3).getName()) + ".cxi";
            XylemC.writeOutSignature(((Module)object3).m_signature, (String)object2);
        } else if (string2.endsWith(".xylemi")) {
            ModuleSignature moduleSignature = null;
            try {
                moduleSignature = XylemC.compileSignature(uRL, this.m_signatureSearchPath, this.m_mss);
            }
            catch (Exception exception) {
                s_logger.logp(Level.SEVERE, s_className, "handleFile", "Error occurred during compilation of signature " + uRL, exception);
                System.exit(-1);
            }
            String string4 = ModuleSignatureStore.makeFilename(moduleSignature.getName()) + ".cxi";
            XylemC.writeOutSignature(moduleSignature, string4);
        } else if (string2.endsWith(".cxo")) {
            this.m_filesToLink.add(uRL);
        } else {
            s_logger.logp(Level.WARNING, s_className, "handleFile", "Ignoring file with unrecognized extension: " + uRL);
        }
    }

    public File link(List list, ModuleSignatureStore moduleSignatureStore, Collection collection2, String string2, String string3, File file, boolean bl, SessionContext sessionContext) {
        Linker linker = new Linker();
        if (this.m_dumpLevel >= 1) {
            linker.m_dumpXylem = true;
        }
        if (this.m_dumpLevel >= 2) {
            linker.m_dumpIntermediateXylem = true;
        }
        linker.m_mss = moduleSignatureStore;
        linker.m_outputDir = file;
        linker.m_isPerf = bl;
        return linker.linkFiles(list, string2, string3, collection2, this.m_optimizationLevel, sessionContext);
    }

    public static final void writeOutSignature(ModuleSignature moduleSignature, String string2) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string2));
            moduleSignature.write(objectOutputStream);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "writeOutSignature", "Error occurred writing of compiled signature to " + string2, exception);
            System.exit(-1);
        }
    }

    public static final void writeOutSignature(ModuleSignature moduleSignature, String string2, File file) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(new File(file, string2)));
            moduleSignature.write(objectOutputStream);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "writeOutSignature", "Error occurred writing of compiled signature to " + string2, exception);
            System.exit(-1);
        }
    }

    public static final ModuleSignature compileSignature(URL uRL, List list, ModuleSignatureStore moduleSignatureStore) throws Exception {
        ParserSource parserSource = new ParserSource(uRL);
        Parser parser = new Parser(new SearchPathSourceResolver(list), parserSource, moduleSignatureStore);
        return XylemC.compileSignature(uRL, parser);
    }

    public static final ModuleSignature compileSignature(URL uRL, Parser parser) throws Exception {
        ParserSource parserSource = new ParserSource(uRL);
        ModuleSignature moduleSignature = parser.parseExternalModuleSignature(parserSource);
        return moduleSignature;
    }

    public Module compile(URL uRL, ModuleSignature moduleSignature, List list, ModuleSignatureStore moduleSignatureStore) throws Exception {
        return this.compile(moduleSignature, new Parser(new SearchPathSourceResolver(list), new ParserSource(uRL), moduleSignatureStore));
    }

    public Module compile(ModuleSignature moduleSignature, Parser parser) throws Exception {
        Module module = parser.parseModule(moduleSignature);
        if (moduleSignature == null) {
            module.exportAllSymbols();
        }
        module.typeCheck();
        if (moduleSignature == null) {
            for (String string2 : new HashSet<String>(module.m_signature.m_functionSignatures.keySet())) {
                module.m_signature.addFunctionSignature(new FunctionSignature(module.getFunction(string2)));
            }
        }
        module.reduce();
        if (module.getVDTMap() != null) {
            Object object2 = new VDTMapOptimizer(module.getVDTMap());
            module.optimize((Optimizer)object2);
            ((VDTMapOptimizer)object2).doUpdate(module);
            object2 = null;
        }
        return module;
    }
}

