/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.commandline;

import com.ibm.xml.ras.LoggerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommandLineParser {
    protected static final Logger s_logger = LoggerUtil.getLogger(CommandLineParser.class);
    protected static final String s_className = CommandLineParser.class.getName();
    public LinkedList m_signatureSearchPath = new LinkedList();

    public static String removeExtension(File file) {
        String string2 = file.getAbsolutePath();
        String string3 = file.getName();
        int n2 = string3.length();
        int n3 = string3.lastIndexOf(46);
        if (n3 != -1 && n3 < n2 - 1) {
            return string2.substring(0, n3 += string2.length() - n2);
        }
        return string2;
    }

    public static List separatePath(String string2) {
        int n2 = string2.length();
        char c = File.pathSeparatorChar;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            char c2 = string2.charAt(i);
            if (c2 == c) {
                if (stringBuffer.length() <= 0) continue;
                arrayList.add(stringBuffer.toString());
                continue;
            }
            stringBuffer.append(c2);
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    protected boolean handleCommandOption(String string2) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string3;
            stringArray = this.validateInputFilename(string2, false);
            if (stringArray == null) {
                return false;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(stringArray.openStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string3 = bufferedReader.readLine()) != null) {
                if ((string3 = string3.trim()).length() <= 0) continue;
                arrayList.add(string3);
            }
            bufferedReader.close();
            inputStreamReader.close();
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "handleCommandOption", "Error reading command file " + string2, exception);
            return false;
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = this.parseOption(stringArray, i);
            if (n2 == -1) {
                return false;
            }
            i = n2;
        }
        return true;
    }

    protected int parseOption(String[] stringArray, int n2) {
        boolean bl;
        boolean bl2 = bl = n2 == stringArray.length - 1;
        if (stringArray[n2].equals("-help") || stringArray[n2].equals("-?") || stringArray[n2].equals("-h")) {
            System.out.println("\t[-command commandfile]\n\t[-I signature_search_directory]");
            return -1;
        }
        if ("-I".equals(stringArray[n2])) {
            if (bl) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "-I missing parameter");
                return -1;
            }
            for (String string2 : CommandLineParser.separatePath(stringArray[++n2])) {
                File file = new File(string2);
                if (!file.exists() || !file.isDirectory()) {
                    s_logger.logp(Level.WARNING, s_className, "parseOption", "Directory " + string2 + " not found; ignoring");
                    continue;
                }
                try {
                    this.m_signatureSearchPath.add(file.toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    s_logger.logp(Level.WARNING, s_className, "parseOption", "Unexpected failure converting directory " + string2 + " to URL; ignoring.");
                }
            }
        } else {
            return -2;
        }
        return n2;
    }

    public URL validateInputFilename(String string2, boolean bl) {
        URL uRL;
        if (string2.startsWith("classpath:")) {
            return this.getClass().getClassLoader().getResource(string2.substring(10));
        }
        File file = new File(string2);
        if (!(bl || file.exists() && !file.isDirectory() && file.canRead())) {
            s_logger.logp(Level.SEVERE, s_className, "validateInputFilename", "Cannot find or access input file " + string2);
            return null;
        }
        try {
            uRL = file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            s_logger.logp(Level.SEVERE, s_className, "validateInputFilename", "File cannot be put into URL form: " + string2);
            return null;
        }
        return uRL;
    }

    public boolean parseCommandLine(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = this.parseOption(stringArray, i);
            if (n2 == -1) {
                return false;
            }
            if (n2 == -2) {
                s_logger.logp(Level.WARNING, s_className, "parseCommandLine", "Unrecognized command line token: " + stringArray[i]);
                n2 = i;
            }
            i = n2;
        }
        return true;
    }
}

