/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.codegen;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public final class MemoryEfficientBuffer
extends PrintWriter {
    private Writer m_writer;
    private File m_file;
    private boolean m_autoMoveToDisk;

    private MemoryEfficientBuffer(Writer writer, boolean bl) {
        super(new BufferedWriter(writer));
        this.m_writer = writer;
        this.m_autoMoveToDisk = bl;
    }

    public static MemoryEfficientBuffer obtainBuffer() {
        try {
            File file = File.createTempFile("xylem", "tmp");
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            MemoryEfficientBuffer memoryEfficientBuffer = new MemoryEfficientBuffer(outputStreamWriter, false);
            memoryEfficientBuffer.m_file = file;
            return memoryEfficientBuffer;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException();
        }
    }

    public int length() {
        if (this.m_writer instanceof StringWriter) {
            this.flush();
            return ((StringWriter)this.m_writer).getBuffer().length();
        }
        throw new UnsupportedOperationException();
    }

    public static MemoryEfficientBuffer obtainCountableBuffer() {
        return new MemoryEfficientBuffer(new StringWriter(), false);
    }

    public void releaseAndWriteOut(Writer writer) {
        this.releaseAndWriteOut(writer, new char[131072]);
    }

    public void releaseAndWriteOut(Writer writer, char[] cArray) {
        try {
            this.flush();
            this.close();
            if (this.m_file != null) {
                FileInputStream fileInputStream = new FileInputStream(this.m_file);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                int n2 = 0;
                while ((n2 = inputStreamReader.read(cArray, 0, cArray.length)) > 0) {
                    writer.write(cArray, 0, n2);
                }
                inputStreamReader.close();
                this.m_file.delete();
            } else {
                writer.write(((StringWriter)this.m_writer).getBuffer().toString());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException();
        }
    }

    public void releaseAndWriteOut(OutputStream outputStream, byte[] byArray) {
        try {
            this.flush();
            this.close();
            if (this.m_file != null) {
                FileInputStream fileInputStream = new FileInputStream(this.m_file);
                int n2 = 0;
                while ((n2 = fileInputStream.read(byArray, 0, byArray.length)) > 0) {
                    outputStream.write(byArray, 0, n2);
                }
                fileInputStream.close();
                this.m_file.delete();
            } else {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
                outputStreamWriter.write(((StringWriter)this.m_writer).getBuffer().toString());
                outputStreamWriter.flush();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException();
        }
    }

    public String toString() {
        throw new UnsupportedOperationException();
    }
}

