/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.codegen;

import com.ibm.xltxe.rnm1.xylem.codegen.JavaCSettings;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaC {
    private static final Logger s_logger = LoggerUtil.getLogger(JavaC.class);
    private static final String s_className = JavaC.class.getName();

    public static final int compile(File file, JavaCSettings javaCSettings) {
        return JavaC.compile(file.getParentFile(), new String[]{file.getName()}, new File("."), null, javaCSettings);
    }

    public static final int compile(File file, String[] stringArray, File file2, String string2, JavaCSettings javaCSettings) {
        boolean bl;
        if (string2 == null) {
            string2 = System.getProperty("java.class.path");
        }
        if (file == null) {
            file = new File(".");
        }
        if (javaCSettings.isJavaCDisabled()) {
            return JavaC.printCompileLine(file, stringArray, file2, string2, javaCSettings);
        }
        String string3 = System.getProperty("java.vm.name");
        boolean bl2 = bl = string3 != null && string3.contains("IBM");
        if (bl) {
            return JavaC.compileWithSpawnOtherJVM(file, stringArray, file2, string2, javaCSettings);
        }
        try {
            return JavaC.compileInThisJVM(file, stringArray, file2, string2, javaCSettings);
        }
        catch (Exception exception) {
            if (!(exception instanceof ClassNotFoundException)) {
                s_logger.logp(Level.WARNING, s_className, "compile", "could not run javac-internal", exception);
            }
            return JavaC.compileWithSpawnOtherJVM(file, stringArray, file2, string2, javaCSettings);
        }
    }

    private static int printCompileLine(File file, String[] stringArray, File file2, String string2, JavaCSettings javaCSettings) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(javaCSettings.getPathToJavaC());
            arrayList.add("-J-Xmx" + javaCSettings.getMaxJavaHeap());
            if (javaCSettings.isGenerateSymbols()) {
                arrayList.add("-g");
            }
            arrayList.add("-sourcepath");
            arrayList.add("\"" + file.getAbsolutePath() + "\"");
            arrayList.add("-d");
            arrayList.add("\"" + file2.getAbsolutePath() + "\"");
            arrayList.add("-target");
            arrayList.add("1.3");
            if (!System.getProperty("java.version").startsWith("1.3")) {
                arrayList.add("-source");
                arrayList.add("1.3");
            }
            arrayList.add("-classpath");
            arrayList.add("\"" + string2 + "\"");
            int n2 = arrayList.size();
            String[] stringArray2 = new String[n2 + stringArray.length];
            arrayList.toArray(stringArray2);
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i + n2] = new File(file, stringArray[i]).getAbsolutePath();
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray2.length; ++i) {
                stringBuffer.append(stringArray2[i]);
                stringBuffer.append(" ");
            }
            s_logger.logp(Level.FINE, s_className, "printCompileLine", stringBuffer.toString());
        }
        return 0;
    }

    private static final int compileInThisJVM(File file, String[] stringArray, File file2, String string2, JavaCSettings javaCSettings) throws Exception {
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-sourcepath");
        arrayList.add(file.getAbsolutePath());
        if (javaCSettings.isGenerateSymbols()) {
            arrayList.add("-g");
        }
        arrayList.add("-d");
        arrayList.add(file2.getAbsolutePath());
        arrayList.add("-target");
        arrayList.add("1.3");
        if (!System.getProperty("java.version").startsWith("1.3")) {
            arrayList.add("-source");
            arrayList.add("1.3");
        }
        arrayList.add("-classpath");
        arrayList.add(string2);
        int n3 = arrayList.size();
        String[] stringArray2 = new String[n3 + stringArray.length];
        arrayList.toArray(stringArray2);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i + n3] = new File(file, stringArray[i]).getAbsolutePath();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("javac-internal ");
        for (int i = 0; i < stringArray2.length; ++i) {
            stringBuffer.append(stringArray2[i]);
            stringBuffer.append(" ");
        }
        long l = System.currentTimeMillis();
        Class<?> clazz = Class.forName("com.sun.tools.javac.Main", true, ClassLoader.getSystemClassLoader());
        Object obj = clazz.newInstance();
        Method method = clazz.getMethod("compile", String[].class);
        boolean bl = (Integer)method.invoke(obj, new Object[]{stringArray2}) == 0;
        long l2 = System.currentTimeMillis();
        if (!bl) {
            String string3 = "JavaC.java: javac-internal reported errors";
            s_logger.logp(Level.SEVERE, s_className, "compileInThisJVM", string3);
            throw new XylemError("ERR_SYSTEM", string3);
        }
        s_logger.logp(Level.INFO, s_className, "compileInThisJVM", stringBuffer.toString());
        s_logger.logp(Level.INFO, s_className, "compileInThisJVM", "timing: javac-internal took " + (l2 - l) + " milliseconds.");
        return n2;
    }

    private static final int compileWithSpawnOtherJVM(File file, String[] stringArray, File file2, String string2, JavaCSettings javaCSettings) {
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(javaCSettings.getPathToJavaC());
        arrayList.add("-J-Xmx" + javaCSettings.getMaxJavaHeap());
        if (javaCSettings.isGenerateSymbols()) {
            arrayList.add("-g");
        }
        arrayList.add("-sourcepath");
        arrayList.add(file.getAbsolutePath());
        arrayList.add("-d");
        arrayList.add(file2.getAbsolutePath());
        arrayList.add("-target");
        arrayList.add("1.5");
        if (!System.getProperty("java.version").startsWith("1.3")) {
            arrayList.add("-source");
            arrayList.add("1.3");
        }
        arrayList.add("-classpath");
        arrayList.add(string2);
        String string3 = System.getProperty("java.endorsed.dirs");
        if (string3 != null && string3.length() > 0) {
            arrayList.add("-endorseddirs");
            arrayList.add(string3);
        }
        int n3 = arrayList.size();
        String[] stringArray2 = new String[n3 + stringArray.length];
        arrayList.toArray(stringArray2);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i + n3] = new File(file, stringArray[i]).getAbsolutePath();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].indexOf(32) >= 0) {
                stringBuffer.append('\"');
                stringBuffer.append(stringArray2[i]);
                stringBuffer.append('\"');
            } else {
                stringBuffer.append(stringArray2[i]);
            }
            stringBuffer.append(" ");
        }
        JavaC.writeRunJavacDotBat(stringBuffer);
        s_logger.logp(Level.INFO, s_className, "compileWithSpawnOtherJVM", stringBuffer.toString());
        long l = System.currentTimeMillis();
        try {
            Process process2 = Runtime.getRuntime().exec(stringArray2);
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(new BufferedInputStream(process2.getErrorStream())));
            LineNumberReader lineNumberReader2 = new LineNumberReader(new InputStreamReader(new BufferedInputStream(process2.getInputStream())));
            while (true) {
                if (lineNumberReader2.ready()) {
                    s_logger.logp(Level.SEVERE, s_className, "compileWithSpawnOtherJVM", lineNumberReader2.readLine());
                    continue;
                }
                while (lineNumberReader.ready()) {
                    s_logger.logp(Level.SEVERE, s_className, "compileWithSpawnOtherJVM", lineNumberReader.readLine());
                }
                try {
                    Thread.sleep(100L);
                    n2 = process2.exitValue();
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
            while (lineNumberReader2.ready()) {
                s_logger.logp(Level.SEVERE, s_className, "compileWithSpawnOtherJVM", lineNumberReader2.readLine());
            }
            while (lineNumberReader.ready()) {
                s_logger.logp(Level.SEVERE, s_className, "compileWithSpawnOtherJVM", lineNumberReader.readLine());
            }
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "compileWithSpawnOtherJVM", "could not run javac", exception);
            n2 = -11;
        }
        long l2 = System.currentTimeMillis();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "compileWithSpawnOtherJVM", "timing: javac took " + (l2 - l) + " milliseconds.");
        }
        if (n2 != 0) {
            s_logger.logp(Level.SEVERE, s_className, "compileWithSpawnOtherJVM", "JAVAC FAILED(" + n2 + ")");
        }
        return n2;
    }

    private static final void writeRunJavacDotBat(StringBuffer stringBuffer) {
        try {
            FileWriter fileWriter = new FileWriter("run-javac.bat");
            fileWriter.write(stringBuffer.toString());
            fileWriter.close();
        }
        catch (IOException iOException) {
            s_logger.logp(Level.WARNING, s_className, "writeRunJavacDotBat", "Couldn't write run-javac.bat.");
            return;
        }
    }
}

