/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.codegen;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.ConventionalGenerationState;
import com.ibm.xltxe.rnm1.xylem.codegen.ExtantGenerationState;
import com.ibm.xltxe.rnm1.xylem.codegen.GenFork;
import com.ibm.xltxe.rnm1.xylem.codegen.GenerationState;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamInADTOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamInADTOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamInADTOptimizedGenerationState;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamOptimizedGenerationState;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.ForkStack;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.IConstructableAsStreamType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.types.UnitType;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CodeGenerationTracker {
    protected HashMap m_bindings = new HashMap(63);
    protected CodeGenerationTracker m_parent = null;
    protected HashMap m_bindingDependencies;
    public TypeEnvironment m_typeEnvironment;
    public Function m_function;
    public BindingEnvironment m_bindingEnvironment;
    private static final Logger s_logger = LoggerUtil.getLogger(CodeGenerationTracker.class);
    private static final String s_className = CodeGenerationTracker.class.getName();
    private final SessionContext _sessionContext;
    private final CodeGenerationOptimizationStyle[] m_optimizationStyles;
    public final Hashtable<String, String> _executablesTable;
    public final Hashtable<String, FcgVariable> _globalVars;
    protected int m_registerCounter = 1;
    public static boolean DORELEASEMANAGEMENT = !HiddenOptions.wasSpecified("doreleasemanagement") || !HiddenOptions.optionValueIs("doreleasemanagement", "off");

    public CodeGenerationTracker(HashMap hashMap, Function function2, CodeGenerationOptimizationStyle[] codeGenerationOptimizationStyleArray, SessionContext sessionContext) {
        this(hashMap, function2, codeGenerationOptimizationStyleArray, 1, sessionContext, new Hashtable<String, String>(), new Hashtable<String, FcgVariable>());
    }

    private CodeGenerationTracker(HashMap hashMap, Function function2, CodeGenerationOptimizationStyle[] codeGenerationOptimizationStyleArray, int n2, SessionContext sessionContext, Hashtable<String, String> hashtable, Hashtable<String, FcgVariable> hashtable2) {
        this.m_bindingDependencies = hashMap;
        this.m_typeEnvironment = function2.getTypeEnvironment();
        this.m_function = function2;
        this.m_bindingEnvironment = function2.getBindingEnvironment();
        this.m_registerCounter = n2;
        this._sessionContext = sessionContext;
        this.m_optimizationStyles = codeGenerationOptimizationStyleArray;
        this._executablesTable = hashtable;
        this._globalVars = hashtable2;
    }

    public int allocateRegister() {
        return this.m_registerCounter++;
    }

    public int allocateRegister(com.ibm.xltxe.rnm1.xtq.bcel.generic.Type type2) {
        int n2 = this.m_registerCounter;
        this.m_registerCounter += type2.getSize();
        return n2;
    }

    protected HashMap getBindingDependencies() {
        if (this.m_bindingDependencies.isEmpty()) {
            this.m_function.determineDataDependencies(null, this.m_bindingDependencies);
        }
        return this.m_bindingDependencies;
    }

    public boolean isBindingUsed(IBinding iBinding) {
        HashMap hashMap = this.getBindingDependencies();
        return hashMap.containsKey(iBinding) && ((List)hashMap.get(iBinding)).size() > 0;
    }

    public int getBindingUseCount(IBinding iBinding) {
        HashMap hashMap = this.getBindingDependencies();
        if (!hashMap.containsKey(iBinding)) {
            return 0;
        }
        return ((List)hashMap.get(iBinding)).size();
    }

    public CodeGenerationTracker cloneBranch() {
        CodeGenerationTracker codeGenerationTracker = new CodeGenerationTracker(this.m_bindingDependencies, this.m_function, this.m_optimizationStyles, this.m_registerCounter, this._sessionContext, this._executablesTable, this._globalVars);
        codeGenerationTracker.m_parent = this;
        return codeGenerationTracker;
    }

    public void registerBinding(IBinding iBinding, Instruction instruction2) {
        HashMap hashMap = this.getBindingDependencies();
        List list = (List)hashMap.get(iBinding);
        if (list != null) {
            for (int i = 0; i < this.m_optimizationStyles.length; ++i) {
                GenerationState generationState = this.m_optimizationStyles[i].getSupportedGenerationState(iBinding, instruction2, list, this.m_typeEnvironment, this.m_bindingEnvironment);
                if (generationState == null) continue;
                this.registerBinding(iBinding, generationState);
                return;
            }
        }
        ConventionalGenerationState conventionalGenerationState = new ConventionalGenerationState(iBinding, instruction2, list == null ? -1 : list.size());
        this.registerBinding(iBinding, conventionalGenerationState);
    }

    public void registerExtantBinding(IBinding iBinding, String string2) {
        this.m_bindings.put(iBinding, new ExtantGenerationState(iBinding, string2));
    }

    public void registerBinding(IBinding iBinding, GenerationState generationState) {
        HashMap hashMap;
        List list;
        if (generationState instanceof ConventionalGenerationState && (list = (List)(hashMap = this.getBindingDependencies()).get(iBinding)) != null && list.size() <= 1) {
            ((ConventionalGenerationState)generationState).setOneTime();
        }
        this.m_bindings.put(iBinding, generationState);
    }

    public GenerationState getGenerationState(IBinding iBinding) {
        GenerationState generationState = (GenerationState)this.m_bindings.get(iBinding);
        if (generationState == null && this.m_parent != null && (generationState = this.m_parent.getGenerationState(iBinding)) != null) {
            generationState = (GenerationState)generationState.clone();
            this.m_bindings.put(iBinding, generationState);
        }
        return generationState;
    }

    public GenerationState getGenerationState(Instruction instruction2) {
        return this.getGenerationState(((IdentifierInstruction)instruction2).getBinding(this.m_bindingEnvironment));
    }

    public void generateAddToStream(Instruction instruction2, String string2, IConstructableAsStreamType iConstructableAsStreamType, FcgCodeGenHelper fcgCodeGenHelper, FcgInstructionList fcgInstructionList, boolean bl) {
        Type type2 = instruction2.getType(this.m_typeEnvironment, this.m_bindingEnvironment);
        assert (type2 != null);
        if (instruction2 instanceof IdentifierInstruction) {
            IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction2;
            ConventionalGenerationState conventionalGenerationState = (ConventionalGenerationState)this.getGenerationState(identifierInstruction.getBinding(this.m_bindingEnvironment));
            if (conventionalGenerationState == null) {
                throw new XylemError("ERR_SYSTEM", "Null CGS for ii=" + identifierInstruction);
            }
            if (conventionalGenerationState.isGenerated() || !(conventionalGenerationState instanceof StreamOptimizedGenerationState)) {
                conventionalGenerationState.generate(fcgCodeGenHelper, this, bl, fcgInstructionList, GenFork.NOTNEEDED, false);
                iConstructableAsStreamType.generateAddMultipleElementsToStream(fcgCodeGenHelper, this, fcgInstructionList, string2, type2);
            } else {
                ((StreamOptimizedGenerationState)conventionalGenerationState).generateAddToStream(fcgCodeGenHelper, fcgInstructionList, this, string2, iConstructableAsStreamType, bl);
            }
        } else if (instruction2.supportsCodeGenerationOptimization(StreamOptimizationStyle.s_streamOptimizationStyle, this.m_typeEnvironment, this.m_bindingEnvironment)) {
            ((IStreamOptimizationInstruction)((Object)instruction2)).generateCodeWithStreamOptimization(fcgCodeGenHelper, fcgInstructionList, string2, iConstructableAsStreamType, this, bl);
        } else {
            instruction2.generateCode(fcgCodeGenHelper, this, null, false, fcgInstructionList, GenFork.NOTNEEDED);
            iConstructableAsStreamType.generateAddMultipleElementsToStream(fcgCodeGenHelper, this, fcgInstructionList, string2, type2);
        }
    }

    public void generateAddElementToStream(Instruction instruction2, String string2, IConstructableAsStreamType iConstructableAsStreamType, FcgCodeGenHelper fcgCodeGenHelper, FcgInstructionList fcgInstructionList, boolean bl) {
        Type type2 = instruction2.getType(this.m_typeEnvironment, this.m_bindingEnvironment);
        if (instruction2 instanceof IdentifierInstruction) {
            IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction2;
            ConventionalGenerationState conventionalGenerationState = (ConventionalGenerationState)this.getGenerationState(identifierInstruction.getBinding(this.m_bindingEnvironment));
            if (conventionalGenerationState == null) {
                throw new XylemError("ERR_SYSTEM", "Null CGS for ii=" + identifierInstruction);
            }
            if (conventionalGenerationState.isGenerated() || !(conventionalGenerationState instanceof StreamOptimizedGenerationState)) {
                FcgType fcgType = conventionalGenerationState.generate(fcgCodeGenHelper, this, bl, fcgInstructionList, GenFork.NOTNEEDED, false);
                iConstructableAsStreamType.generateAddElementToStream(fcgCodeGenHelper, fcgInstructionList, string2, type2, fcgType, this);
            } else {
                ((StreamOptimizedGenerationState)conventionalGenerationState).generateAddToStream(fcgCodeGenHelper, fcgInstructionList, this, string2, iConstructableAsStreamType, bl);
            }
        } else if (instruction2.supportsCodeGenerationOptimization(StreamOptimizationStyle.s_streamOptimizationStyle, this.m_typeEnvironment, this.m_bindingEnvironment)) {
            ((IStreamOptimizationInstruction)((Object)instruction2)).generateCodeWithStreamOptimization(fcgCodeGenHelper, fcgInstructionList, string2, iConstructableAsStreamType, this, bl);
        } else {
            FcgType fcgType = instruction2.generateCode(fcgCodeGenHelper, this, null, false, fcgInstructionList, GenFork.NOTNEEDED);
            iConstructableAsStreamType.generateAddElementToStream(fcgCodeGenHelper, fcgInstructionList, string2, type2, fcgType, this);
        }
    }

    public FcgType generateAddToStreamInADT(Instruction instruction2, String string2, Binding binding, FcgCodeGenHelper fcgCodeGenHelper, FcgInstructionList fcgInstructionList, boolean bl) {
        IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction2;
        GenerationState generationState = this.getGenerationState(identifierInstruction.getBinding(this.m_bindingEnvironment));
        try {
            if (!(generationState instanceof StreamInADTOptimizedGenerationState) && ((ConventionalGenerationState)generationState).getNumDependencies() == 1 && ((ConventionalGenerationState)generationState).m_instruction.supportsCodeGenerationOptimization(StreamInADTOptimizationStyle.s_streamInADTOptimizationStyle, this.m_typeEnvironment, this.m_bindingEnvironment)) {
                Instruction instruction3 = ((ConventionalGenerationState)generationState).m_instruction;
                return ((IStreamInADTOptimizationInstruction)((Object)instruction3)).generateCode(fcgCodeGenHelper, fcgInstructionList, string2, binding, this, ((IStreamInADTOptimizationInstruction)((Object)instruction3)).canGenerateObjectless(this.m_typeEnvironment), bl);
            }
            StreamInADTOptimizedGenerationState streamInADTOptimizedGenerationState = (StreamInADTOptimizedGenerationState)generationState;
            if (streamInADTOptimizedGenerationState.isGenerated()) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "generateAddToStreamInADT", "ADT optimization could not occur unfortunately");
                }
                StreamType streamType = (StreamType)binding.getBindingType();
                FcgType fcgType = streamType.getFCGType(fcgCodeGenHelper);
                FcgClassReferenceType fcgClassReferenceType = (FcgClassReferenceType)streamInADTOptimizedGenerationState.generate(fcgCodeGenHelper, this, bl, fcgInstructionList, GenFork.ONLY, false);
                NamedType namedType = (NamedType)this.resolveType(instruction2);
                AbstractDataType.Constructor constructor = namedType.resolveNameToADT((Module)this.getCurrentModule()).m_constructors[0];
                Type type2 = generationState.m_binding.getBindingType();
                fcgInstructionList.loadInstanceField(fcgClassReferenceType, constructor.getConstructorQualifiedFieldName(constructor.findBinding(binding), fcgCodeGenHelper), fcgType);
                streamType.generateAddMultipleElementsToStream(fcgCodeGenHelper, this, fcgInstructionList, string2, type2);
                return fcgType;
            }
            if (!streamInADTOptimizedGenerationState.m_member.getName().equals(binding.getName().toString())) {
                throw new XylemError("ERR_SYSTEM", "Add to stream in ADT called for a member that was not expected");
            }
            return streamInADTOptimizedGenerationState.generateAddToStreamInADT(fcgCodeGenHelper, fcgInstructionList, this, string2, bl);
        }
        catch (ClassCastException classCastException) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "generateAddToStreamInADT", "could not generate stream-in-adt state for " + identifierInstruction + " ");
            }
            throw classCastException;
        }
    }

    public boolean isADTBindingGeneratedObjectless(Instruction instruction2) {
        IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction2;
        GenerationState generationState = this.getGenerationState(identifierInstruction.getBinding(this.m_bindingEnvironment));
        if (!(generationState instanceof StreamInADTOptimizedGenerationState)) {
            return false;
        }
        StreamInADTOptimizedGenerationState streamInADTOptimizedGenerationState = (StreamInADTOptimizedGenerationState)generationState;
        return streamInADTOptimizedGenerationState.isObjectless();
    }

    public Type resolveType(Instruction instruction2) {
        return instruction2.getType(this.m_typeEnvironment, this.m_bindingEnvironment).resolveType(this.m_typeEnvironment);
    }

    public Module getCurrentModule() {
        return this.m_typeEnvironment.getModule();
    }

    public void generateFreeBindings(Instruction instruction2, FcgCodeGenHelper fcgCodeGenHelper, FcgInstructionList fcgInstructionList, IBinding iBinding, boolean bl, GenFork genFork) {
        HashSet hashSet = new HashSet();
        instruction2.accumulateNonLiteralFreeBindings(hashSet, this.m_bindingEnvironment);
        for (IBinding iBinding2 : hashSet) {
            FcgType fcgType;
            if (iBinding2 == iBinding || (fcgType = this.generateConventionally(iBinding2, fcgCodeGenHelper, bl, fcgInstructionList, genFork)) == FcgType.VOID) continue;
            String string2 = fcgCodeGenHelper.generateNewLocalVariableName();
            fcgInstructionList.defineVar(fcgType, string2, true);
        }
    }

    public void generateFreeBindings(Instruction instruction2, FcgCodeGenHelper fcgCodeGenHelper, FcgInstructionList fcgInstructionList, IBinding iBinding, boolean bl) {
        this.generateFreeBindings(instruction2, fcgCodeGenHelper, fcgInstructionList, iBinding, bl, false);
    }

    public void generateFreeBindings(Instruction instruction2, FcgCodeGenHelper fcgCodeGenHelper, FcgInstructionList fcgInstructionList, IBinding iBinding, boolean bl, boolean bl2) {
        HashSet hashSet = new HashSet();
        instruction2.accumulateNonLiteralFreeBindings(hashSet, this.m_bindingEnvironment);
        for (IBinding iBinding2 : hashSet) {
            if (iBinding2 == iBinding) continue;
            Type type2 = iBinding2.getBindingType(this.m_typeEnvironment, this.m_bindingEnvironment);
            if (bl2 && type2 == UnitType.s_unitType) continue;
            this.generateConventionally(iBinding2, fcgCodeGenHelper, bl, fcgInstructionList, true);
        }
    }

    public FcgType generateConventionally(IBinding iBinding, FcgCodeGenHelper fcgCodeGenHelper, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        ConventionalGenerationState conventionalGenerationState = (ConventionalGenerationState)this.getGenerationState(iBinding);
        if (conventionalGenerationState == null) {
            throw new XylemError("ERR_SYSTEM", "ConventionalGenerationState is null, for b=" + iBinding);
        }
        return conventionalGenerationState.generate(fcgCodeGenHelper, this, bl, fcgInstructionList, genFork, false);
    }

    public FcgType generateConventionally(IBinding iBinding, FcgCodeGenHelper fcgCodeGenHelper, boolean bl, FcgInstructionList fcgInstructionList, boolean bl2) {
        ConventionalGenerationState conventionalGenerationState = (ConventionalGenerationState)this.getGenerationState(iBinding);
        if (conventionalGenerationState == null) {
            throw new XylemError("ERR_SYSTEM", "ConventionalGenerationState is null, for b=" + iBinding);
        }
        return conventionalGenerationState.generate(fcgCodeGenHelper, this, bl, fcgInstructionList, GenFork.NOTNEEDED, bl2);
    }

    public FcgType generateConventionally(Instruction instruction2, FcgCodeGenHelper fcgCodeGenHelper, FcgInstructionList fcgInstructionList, GenFork genFork) {
        return this.generateConventionally(instruction2, fcgCodeGenHelper, false, fcgInstructionList, genFork);
    }

    public FcgType generateConventionally(Instruction instruction2, FcgCodeGenHelper fcgCodeGenHelper, FcgInstructionList fcgInstructionList) {
        return this.generateConventionally(instruction2, fcgCodeGenHelper, false, fcgInstructionList, GenFork.NOTNEEDED);
    }

    public FcgType generateConventionally(Instruction instruction2, FcgCodeGenHelper fcgCodeGenHelper, boolean bl, FcgInstructionList fcgInstructionList, GenFork genFork) {
        if (instruction2 instanceof LiteralInstruction) {
            return instruction2.generateCode(fcgCodeGenHelper, this, null, bl, fcgInstructionList, genFork);
        }
        if (instruction2 instanceof IdentifierInstruction) {
            IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction2;
            IBinding iBinding = identifierInstruction.getBinding(this.m_bindingEnvironment);
            return this.generateConventionally(iBinding, fcgCodeGenHelper, bl, fcgInstructionList, genFork);
        }
        throw new XylemError("ERR_SYSTEM", "should not occur in reduced code " + instruction2 + " " + instruction2.getClass());
    }

    public FcgType getResolvedType(FcgCodeGenHelper fcgCodeGenHelper, Type type2) {
        Type type3 = type2.resolveType(this.m_typeEnvironment);
        if (type3 == null) {
            throw new XylemError("ERR_SYSTEM", "type not found for " + type2);
        }
        FcgType fcgType = type3.getFCGType(fcgCodeGenHelper);
        return fcgType;
    }

    public Function getFunction() {
        return this.m_function;
    }

    public SessionContext getSessionContext() {
        return this._sessionContext;
    }

    public FcgClassReferenceType generateRefToForkStack(FcgCodeGenHelper fcgCodeGenHelper, FcgInstructionList fcgInstructionList) {
        if (!DORELEASEMANAGEMENT) {
            return null;
        }
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGenHelper.getForkStackOwnerClass();
        assert (fcgClassReferenceType != null);
        if (fcgClassReferenceType != null) {
            FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGenHelper.loadThisVar(fcgInstructionList);
            assert (fcgClassReferenceType2 != null);
            if (fcgClassReferenceType2 != null) {
                FcgClassReferenceType fcgClassReferenceType3 = fcgCodeGenHelper.getClassReferenceType(ForkStack.class.getName());
                String string2 = "__ForkStack";
                fcgInstructionList.loadInstanceField(fcgClassReferenceType, string2, fcgClassReferenceType3);
            }
            return fcgClassReferenceType2;
        }
        return null;
    }
}

