/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.codegen;

import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.JavaCSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.LazyStreamFixedIndexOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamInADTOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.bcel.ClassCollector;
import com.ibm.xltxe.rnm1.xylem.config.Settings;
import com.ibm.xml.ras.LoggerUtil;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CodeGenerationSettings
extends Settings
implements IntegerSettings {
    private static final Logger s_logger = LoggerUtil.getLogger(CodeGenerationSettings.class);
    private static final String s_className = CodeGenerationSettings.class.getName();
    protected boolean m_makeAllMethodsStatic = true;
    protected boolean m_multiClassMethodOutput = true;
    protected boolean m_singleThreadPerInstance = true;
    protected boolean m_enableTracing = false;
    protected boolean m_obfuscateFunctionNames = false;
    protected int m_maxFunctionsPerPartition = 800;
    protected boolean m_suppressComments = false;
    public boolean m_dumpxylem = false;
    protected int m_targetLanguage = 3;
    protected JavaCSettings m_javaCSettings = new JavaCSettings();
    protected int m_postReductionSplitLimit = 0;
    protected boolean m_threadSafe = false;
    protected boolean m_byteCodeLineNumbers = false;
    protected boolean m_bufferDiagnostics = false;
    protected ClassCollector m_classCollector = null;
    protected boolean m_bcelAutoSplitFunctions = false;
    protected boolean m_emitAutoSplitWarning = true;
    protected int m_reservedBytes = 0;
    protected boolean m_orderSafeSplit = false;
    protected boolean m_externalizeStrings = false;
    protected boolean m_outlineStreamAppend = false;
    protected boolean m_mixedModeModuleCompilation = false;
    protected List<String> m_mixedModeFunctionExcludeList = null;
    protected boolean m_arbitraryPrecision = false;
    protected boolean m_overflowDetection = false;
    protected CodeGenerationOptimizationStyle[] m_optGenerationStyles;
    public static final int s_cpp = 1;
    public static final int s_cxo = 2;
    public static final int s_javaSource = 3;
    public static final int s_bcel = 4;

    public CodeGenerationSettings(CodeGenerationOptimizationStyle[] codeGenerationOptimizationStyleArray) {
        this.m_optGenerationStyles = codeGenerationOptimizationStyleArray;
    }

    public CodeGenerationSettings() {
        this.m_optGenerationStyles = new CodeGenerationOptimizationStyle[]{StreamOptimizationStyle.s_streamOptimizationStyle, LazyStreamFixedIndexOptimizationStyle.s_lazyStreamFixedIndexOptimizationStyle, StreamInADTOptimizationStyle.s_streamInADTOptimizationStyle};
    }

    public void setMakeAllMethodsStatic(boolean bl) {
        this.m_makeAllMethodsStatic = bl;
    }

    public boolean isMakeAllMethodsStatic() {
        return this.m_makeAllMethodsStatic;
    }

    public void setTargetLanguage(int n2) {
        this.m_targetLanguage = n2;
    }

    public int getTargetLanguage() {
        return this.m_targetLanguage;
    }

    public void setSuppressComments(boolean bl) {
        this.m_suppressComments = bl;
    }

    public boolean isSuppressComments() {
        return this.m_suppressComments;
    }

    public void setMultiPartitionOutput(boolean bl) {
        this.m_multiClassMethodOutput = bl;
    }

    public boolean isMultiPartitionOutput() {
        return this.m_multiClassMethodOutput;
    }

    public void setSingleThreadPerInstance(boolean bl) {
        this.m_singleThreadPerInstance = bl;
    }

    public boolean isSingleThreadPerInstance() {
        return this.m_singleThreadPerInstance;
    }

    public void setFunctionCallTracing(boolean bl) {
        this.m_enableTracing = bl;
    }

    public boolean isFunctionCallTracing() {
        return this.m_enableTracing;
    }

    public void setObfuscateFunctionNames(boolean bl) {
        this.m_obfuscateFunctionNames = bl;
    }

    public boolean isObfuscateFunctionNames() {
        return this.m_obfuscateFunctionNames;
    }

    public void setMaxFunctionsPerPartition(int n2) {
        this.m_maxFunctionsPerPartition = n2;
    }

    public int getMaxFunctionsPerPartition() {
        return this.m_maxFunctionsPerPartition;
    }

    public JavaCSettings getJavaCSettings() {
        return this.m_javaCSettings;
    }

    public boolean getBCELAutoSplitFunctions() {
        return this.m_bcelAutoSplitFunctions;
    }

    public void setBCELAutoSplitFunctions(boolean bl) {
        this.m_bcelAutoSplitFunctions = bl;
    }

    public boolean getEmitAutoSplitWarning() {
        return this.m_emitAutoSplitWarning;
    }

    public void setEmitAutoSplitWarning(boolean bl) {
        this.m_emitAutoSplitWarning = bl;
    }

    public int getReservedBytes() {
        return this.m_reservedBytes;
    }

    public void setReservedBytes(int n2) {
        this.m_reservedBytes = n2;
    }

    public boolean getOrderSafeSplit() {
        return this.m_orderSafeSplit;
    }

    public void setOrderSafeSplit(boolean bl) {
        this.m_orderSafeSplit = bl;
    }

    public boolean isExternalizeStrings() {
        return this.m_externalizeStrings;
    }

    public void setExternalizeStrings(boolean bl) {
        this.m_externalizeStrings = bl;
    }

    public boolean isMixedModeModuleCompilation() {
        return this.m_mixedModeModuleCompilation;
    }

    public void setMixedModeModuleCompilation(boolean bl) {
        this.m_mixedModeModuleCompilation = bl;
    }

    public List<String> getMixedModeFunctionExcludeList() {
        return this.m_mixedModeFunctionExcludeList;
    }

    public void setMixedModeFunctionExcludeList(List<String> list) {
        this.m_mixedModeFunctionExcludeList = list;
    }

    public boolean isOutlineStreamAppend() {
        return this.m_outlineStreamAppend;
    }

    public void setOutlineStreamAppend(boolean bl) {
        this.m_outlineStreamAppend = bl;
    }

    public int parseOption(String[] stringArray, int n2) {
        if (stringArray[n2].equals("-help") || stringArray[n2].equals("-?") || stringArray[n2].equals("-h")) {
            System.out.println("\t[-language java|cpp]\n\t[-disablejavac]\n\t[-dumpxylem]\n\t[-suppressComments]\n\t[-combinePartitions]\n\t[-enableTracing]\n\t[-newsplit n]\n\t[-maxfunctionsperpartition n]\n\t[-reservebytes bytes]\n\t[-generateBCEL]\n\t[-autosplitBCEL]\n\t[-obfuscate]\n\t[-externStrings]\n\t[-outlineAppend]\n\t[-generateCXO]\n");
            return n2;
        }
        if (stringArray[n2].equals("-language")) {
            if (++n2 == stringArray.length) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "-language missing parameter");
                return -1;
            }
            if (!stringArray[n2].equals("java")) {
                if (stringArray[n2].equals("cpp")) {
                    this.setTargetLanguage(1);
                } else {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "invalid language: " + stringArray[n2]);
                    return -1;
                }
            }
            return n2;
        }
        if (stringArray[n2].equals("-suppressComments")) {
            this.setSuppressComments(true);
            return n2;
        }
        if (stringArray[n2].equals("-combinepartitions")) {
            this.setMultiPartitionOutput(false);
            return n2;
        }
        if (stringArray[n2].equals("-enabletracing")) {
            this.setFunctionCallTracing(true);
            return n2;
        }
        if (stringArray[n2].equals("-newsplit")) {
            if (++n2 == stringArray.length) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "-newsplit missing parameter");
                return -1;
            }
            try {
                this.setPostReductionSplitLimit(Integer.parseInt(stringArray[n2]));
            }
            catch (NumberFormatException numberFormatException) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "invalid split limit: " + stringArray[n2]);
                return -1;
            }
            return n2;
        }
        if (stringArray[n2].equals("-generateBCEL")) {
            this.setTargetLanguage(4);
            return n2;
        }
        if (stringArray[n2].equals("-generateCXO")) {
            this.setTargetLanguage(2);
            return n2;
        }
        if (stringArray[n2].equals("-autosplitBCEL")) {
            this.setBCELAutoSplitFunctions(true);
            return n2;
        }
        if (stringArray[n2].equals("-obfuscate")) {
            this.setObfuscateFunctionNames(true);
            return n2;
        }
        if (stringArray[n2].equals("-externStrings")) {
            this.setExternalizeStrings(true);
            return n2;
        }
        if (stringArray[n2].equals("-outlineAppend")) {
            this.setOutlineStreamAppend(true);
            return n2;
        }
        if (stringArray[n2].equals("-maxfunctionsperpartition")) {
            if (++n2 == stringArray.length) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "-maxfunctionsperpartition missing parameter");
                return -1;
            }
            this.setMaxFunctionsPerPartition(Integer.parseInt(stringArray[n2]));
            return n2;
        }
        if (stringArray[n2].equals("-reservebytes")) {
            if (++n2 == stringArray.length) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "-reservebytes missing parameter");
                return -1;
            }
            this.setReservedBytes(Integer.parseInt(stringArray[n2]));
            return n2;
        }
        if (stringArray[n2].equals("-disablejavac")) {
            this.getJavaCSettings().setJavaCDisabled(true);
            return n2;
        }
        if (stringArray[n2].equals("-dumpxylem")) {
            this.m_dumpxylem = true;
            return n2;
        }
        return -2;
    }

    public int getPostReductionSplitLimit() {
        return this.m_postReductionSplitLimit;
    }

    public void setPostReductionSplitLimit(int n2) {
        this.m_postReductionSplitLimit = n2;
    }

    public boolean isThreadSafe() {
        return this.m_threadSafe;
    }

    public void setThreadSafe(boolean bl) {
        this.m_threadSafe = bl;
    }

    public boolean isByteCodeLineNumbers() {
        return this.m_byteCodeLineNumbers;
    }

    public boolean isBufferDiagnostics() {
        return this.m_bufferDiagnostics;
    }

    public void setBCELClassCollector(ClassCollector classCollector) {
        this.m_classCollector = classCollector;
    }

    public ClassCollector getBCELClassCollector() {
        return this.m_classCollector;
    }

    @Override
    public boolean getArbitraryPrecision() {
        return this.m_arbitraryPrecision;
    }

    @Override
    public boolean getOverflowDetection() {
        return this.m_overflowDetection;
    }

    @Override
    public void setArbitraryPrecision(boolean bl) {
        this.m_arbitraryPrecision = bl;
    }

    @Override
    public void setOverflowDetection(boolean bl) {
        this.m_overflowDetection = bl;
    }

    public void setCodeGenptimizationStyles(CodeGenerationOptimizationStyle[] codeGenerationOptimizationStyleArray) {
        this.m_optGenerationStyles = codeGenerationOptimizationStyleArray;
    }

    public CodeGenerationOptimizationStyle[] getCodeGenOptimizationStyles() {
        return this.m_optGenerationStyles;
    }
}

