/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.codegen;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.instructions.BeginInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TryCatchInstruction;

public class CodeGenerationOptUtils {
    public static final int LEN_UNKNOWN = -1;

    public static int getStreamLength(Instruction instruction2, BindingEnvironment bindingEnvironment) {
        int n2 = 0;
        if (instruction2 instanceof StreamInstruction) {
            StreamInstruction streamInstruction = (StreamInstruction)instruction2;
            int n3 = streamInstruction.getChildInstructionCount();
            for (int i = 0; i < n3; ++i) {
                Instruction instruction3 = streamInstruction.getChildInstruction(i);
                int n4 = CodeGenerationOptUtils.numberOfElements(instruction3, bindingEnvironment);
                if (n4 == -1) {
                    return -1;
                }
                n2 += n4;
            }
            return n2;
        }
        if (instruction2 instanceof IdentifierInstruction) {
            Object object2;
            IBinding iBinding;
            LetInstruction letInstruction;
            IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction2;
            BindingEnvironment bindingEnvironment2 = identifierInstruction.getBindingEnvironment();
            if (bindingEnvironment2 == null) {
                bindingEnvironment2 = bindingEnvironment;
            }
            if ((letInstruction = (iBinding = bindingEnvironment2.getVariableBinding(object2 = identifierInstruction.getVariable())).getLet()) != null) {
                Instruction instruction4 = letInstruction.getValue();
                return CodeGenerationOptUtils.getStreamLength(instruction4, bindingEnvironment);
            }
        } else if (instruction2 instanceof BeginInstruction) {
            BeginInstruction beginInstruction = (BeginInstruction)instruction2;
            int n5 = beginInstruction.getChildInstructionCount();
            if (n5 >= 0) {
                Instruction instruction5 = beginInstruction.getChildInstruction(n5 - 1);
                return CodeGenerationOptUtils.getStreamLength(instruction5, bindingEnvironment);
            }
        } else if (instruction2 instanceof TryCatchInstruction) {
            TryCatchInstruction tryCatchInstruction = (TryCatchInstruction)instruction2;
            Instruction instruction6 = tryCatchInstruction.getBody();
            return CodeGenerationOptUtils.getStreamLength(instruction6, bindingEnvironment);
        }
        return -1;
    }

    private static int numberOfElements(Instruction instruction2, BindingEnvironment bindingEnvironment) {
        if (instruction2 instanceof LiteralInstruction) {
            return 1;
        }
        return CodeGenerationOptUtils.getStreamLength(instruction2, bindingEnvironment);
    }
}

