/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.codegen;

import com.ibm.xltxe.rnm1.xylem.codegen.CodeGeneration;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.FunctionGenerationStyle;
import com.ibm.xltxe.rnm1.xylem.types.LambdaType;
import com.ibm.xltxe.rnm1.xylem.types.LazyStreamType;
import com.ibm.xltxe.rnm1.xylem.types.PromiseType;
import com.ibm.xltxe.rnm1.xylem.types.SlotType;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class CodeGenerationHelper
implements CodeGeneration {
    private static final char ESCAPE_DELIM_CHAR = '$';
    private String m_className;
    private CodeGenerationSettings m_settings;
    private HashMap m_obfuscatedFunctionNames = new HashMap();
    private HashMap m_generationMemos = new HashMap();
    private HashMap m_lambdaTypeGenerationRequests = new HashMap();
    private HashMap m_slotTypeGenerationRequests = new HashMap();
    private HashMap m_lazyStreamTypeGenerationRequests = new HashMap();
    private HashMap m_promiseTypeGenerationRequests = new HashMap();
    private TreeSet m_functionGenerationRequests = new TreeSet(new Comparator(){

        public int compare(Object object2, Object object3) {
            return ((FunctionGenerationStyle)object2).getSignature().compareTo(((FunctionGenerationStyle)object3).getSignature());
        }
    });
    HashMap safeNamesMap = new HashMap();

    @Override
    public final String getClassName() {
        return this.m_className;
    }

    @Override
    public final void setClassName(String string2) {
        this.m_className = string2;
    }

    @Override
    public void requestFunctionGeneration(FunctionGenerationStyle functionGenerationStyle) {
        this.m_functionGenerationRequests.add(functionGenerationStyle);
    }

    @Override
    public Iterator functionGenerationRequestsIterator() {
        return this.m_functionGenerationRequests.iterator();
    }

    @Override
    public boolean functionGenerationRequestsIsEmpty() {
        return this.m_functionGenerationRequests.isEmpty();
    }

    @Override
    public void requestLambdaTypeGeneration(String string2, LambdaType lambdaType) {
        this.m_lambdaTypeGenerationRequests.put(string2, lambdaType);
    }

    @Override
    public void requestPromiseTypeGeneration(String string2, PromiseType promiseType) {
        this.m_promiseTypeGenerationRequests.put(string2, promiseType);
    }

    @Override
    public final Iterator promiseTypeGenerationRequestsIterator() {
        return this.m_promiseTypeGenerationRequests.keySet().iterator();
    }

    @Override
    public final PromiseType promiseTypeGenerationRequestsGet(String string2) {
        return (PromiseType)this.m_promiseTypeGenerationRequests.get(string2);
    }

    @Override
    public void requestSlotTypeGeneration(String string2, SlotType slotType) {
        this.m_slotTypeGenerationRequests.put(string2, slotType);
    }

    @Override
    public final Iterator slotTypeGenerationRequestsIterator() {
        return this.m_slotTypeGenerationRequests.keySet().iterator();
    }

    @Override
    public final SlotType slotTypeGenerationRequestsGet(String string2) {
        return (SlotType)this.m_slotTypeGenerationRequests.get(string2);
    }

    public void requestLazyStreamTypeGeneration(String string2, LazyStreamType lazyStreamType) {
        this.m_lazyStreamTypeGenerationRequests.put(string2, lazyStreamType);
    }

    public final Iterator lazyStreamTypeGenerationRequestsIterator() {
        return this.m_lazyStreamTypeGenerationRequests.keySet().iterator();
    }

    public final LazyStreamType lazyStreamTypeGenerationRequestsGet(String string2) {
        return (LazyStreamType)this.m_lazyStreamTypeGenerationRequests.get(string2);
    }

    @Override
    public String getSafeName(String string2) {
        if (this.m_settings.isObfuscateFunctionNames()) {
            return this.getObfuscatedFunctionName(string2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string2.length();
        char c = string2.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            stringBuffer.append('_');
        }
        for (int i = 0; i < n2; ++i) {
            char c2 = string2.charAt(i);
            if (c2 != '$' && (Character.isJavaIdentifierStart(c2) || Character.isJavaIdentifierPart(c2))) {
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append('$').append("0x").append(Integer.toHexString(c2)).append('$');
        }
        String string3 = stringBuffer.toString().length() > 80 ? (stringBuffer.toString().substring(0, 80) + stringBuffer.toString().hashCode()).replace('-', '_') : stringBuffer.toString();
        String string4 = (String)this.safeNamesMap.get(string2.toLowerCase());
        if (null == string4) {
            this.safeNamesMap.put(string2.toLowerCase(), string2);
            return string3;
        }
        if (string4.equals(string2)) {
            return string3;
        }
        return (string3 + string3.hashCode()).replace('-', '_');
    }

    @Override
    public final CodeGenerationSettings getSettings() {
        return this.m_settings;
    }

    @Override
    public final void setSettings(CodeGenerationSettings codeGenerationSettings) {
        this.m_settings = codeGenerationSettings;
    }

    @Override
    public final String getObfuscatedFunctionName(String string2) {
        String string3 = (String)this.m_obfuscatedFunctionNames.get(string2);
        if (string3 == null) {
            string3 = "f" + this.m_obfuscatedFunctionNames.size();
            this.m_obfuscatedFunctionNames.put(string2, string3);
        }
        return string3;
    }

    @Override
    public final void generationMemosPut(Object object2, Object object3) {
        this.m_generationMemos.put(object2, object3);
    }

    @Override
    public final Object generationMemosGet(Object object2) {
        return this.m_generationMemos.get(object2);
    }

    @Override
    public final int generationMemosSize() {
        return this.m_generationMemos.size();
    }

    @Override
    public final boolean generationMemosContainsKey(Object object2) {
        return this.m_generationMemos.containsKey(object2);
    }

    @Override
    public final LambdaType lambdaTypeGenerationRequestsGet(String string2) {
        return (LambdaType)this.m_lambdaTypeGenerationRequests.get(string2);
    }

    @Override
    public final Iterator lambdaTypeGenerationRequestsIterator() {
        return this.m_lambdaTypeGenerationRequests.keySet().iterator();
    }
}

